/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.database.table.impl;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.tinygroup.commons.tools.StringUtil;
import org.tinygroup.database.config.table.Index;
import org.tinygroup.database.config.table.Table;
import org.tinygroup.database.config.table.TableField;
import org.tinygroup.database.exception.DatabaseRuntimeException;
import org.tinygroup.database.table.TableSqlProcessor;
import org.tinygroup.database.table.impl.SqlProcessorImpl;
import org.tinygroup.database.table.impl.TableProcessorImpl;
import org.tinygroup.database.util.ColTypeGroupUtil;
import org.tinygroup.database.util.DataBaseUtil;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;
import org.tinygroup.metadata.config.stdfield.StandardField;
import org.tinygroup.metadata.util.MetadataUtil;

public class OracleSqlProcessorImpl
extends SqlProcessorImpl {
    private static TableSqlProcessor tableSqlProcessor = new OracleSqlProcessorImpl();
    private Logger logger = LoggerFactory.getLogger(OracleSqlProcessorImpl.class);
    private String currentDbSchema = null;
    private List<String> cacheSeqList = null;

    public static TableSqlProcessor getTableSqlProcessor() {
        tableSqlProcessor.setTableProcessor(TableProcessorImpl.getTableProcessor());
        return tableSqlProcessor;
    }

    @Override
    protected String getDatabaseType() {
        return "oracle";
    }

    @Override
    protected String getQueryForeignSql(Table table, String schema) {
        String sql = "Select a.constraint_name CONSTRAINT_NAME,a.column_name  COLUMN_NAME,b.table_name  REFERENCED_TABLE_NAME,b.column_name REFERENCED_COLUMN_NAME From (Select a.owner,a.constraint_name,b.table_name,b.column_name,a.r_constraint_name From all_constraints a, all_cons_columns b Where a.constraint_type = 'R' And a.constraint_name = b.constraint_name) a,(Select Distinct a.r_constraint_name, b.table_name, b.column_name From all_constraints a, all_cons_columns b Where a.constraint_type = 'R' And a.r_constraint_name = b.constraint_name) b Where a.r_constraint_name = b.r_constraint_name and a.table_name ='" + table.getNameWithOutSchema().toUpperCase() + "'";
        if (schema != null && schema.trim().length() > 0) {
            sql = sql + " and a.owner='" + schema.toUpperCase() + "'";
        }
        return sql;
    }

    @Override
    protected String createAlterTypeSql(String tableName, String fieldName, String tableDataType) {
        return String.format("ALTER TABLE %s MODIFY %s %s", tableName, this.delimiter(fieldName), tableDataType);
    }

    protected void appendComment(String comment, StringBuffer ddlBuffer) {
    }

    @Override
    protected void appendFooter(StringBuffer ddlBuffer, Table table, List<String> list) {
        super.appendFooter(ddlBuffer, table, list);
        this.appendFooterComment(table, list);
    }

    @Override
    protected void appendComment(String comment, StringBuffer ddlBuffer, List<String> list) {
    }

    @Override
    protected boolean checkCommentSame(String standardComment, String remarks) {
        return true;
    }

    @Override
    protected boolean checkTypeSame(String dbColumnType, String tableDataType, String dbDataType) {
        String type = ColTypeGroupUtil.getSpecialType(tableDataType);
        if (type != null) {
            tableDataType = type;
        }
        String tbDataTypeLower = tableDataType.replaceAll(" ", "").replaceAll(",0", "").toLowerCase();
        return dbColumnType.replaceAll(",0", "").indexOf(tbDataTypeLower) != -1;
    }

    @Override
    protected String getSchema(String schema, Connection connection) throws SQLException {
        if (!StringUtil.isBlank((String)schema)) {
            return schema;
        }
        if (this.currentDbSchema == null) {
            this.currentDbSchema = connection.getMetaData().getUserName();
        }
        return this.currentDbSchema;
    }

    @Override
    protected List<String> getSeqTriggerSql(Table table, String packageName) {
        ArrayList<String> sqlList = new ArrayList<String>();
        for (TableField tableField : table.getFieldList()) {
            if (!tableField.isAutoIncrease() || !tableField.getPrimary()) continue;
            StandardField standardField = MetadataUtil.getStandardField((String)tableField.getStandardFieldId(), (ClassLoader)this.getClass().getClassLoader());
            sqlList.add(String.format("create sequence %s", this.getSeqName(table)).toUpperCase());
            String baseStr = "create or replace trigger %s before insert on %s for each row when (new.%s is null) begin select %s.nextval into :new.%s from dual; end;";
            String from = DataBaseUtil.fromSourceLocal.get();
            if (from != null && from.equals("tool")) {
                baseStr = baseStr + "\n/\n";
            }
            String triggerName = "TRI_" + table.getNameWithOutSchema();
            sqlList.add(String.format(baseStr, triggerName, table.getNameWithOutSchema(), standardField.getName(), this.getSeqName(table), standardField.getName()).toUpperCase());
        }
        return sqlList;
    }

    @Override
    protected void getChangedFooterComment(Connection connection, Table table, List<String> list) throws SQLException {
    }

    @Override
    protected void getSeqTriggerUpdate(Connection connection, Table table, List<String> list) throws SQLException {
        String querySchemaName = this.getSchema(table.getSchema(), connection);
        boolean isSeqExits = this.getAllSequence(connection, querySchemaName).contains(this.getSeqName(table));
        if (isSeqExits) {
            return;
        }
        list.addAll(this.getSeqTriggerSql(table, null));
    }

    private String getSeqName(Table table) {
        return "SEQ_" + table.getNameWithOutSchema().toUpperCase();
    }

    @Override
    protected String getDropForeignSql(String dropConstraint, Table table) {
        return String.format("ALTER TABLE %s DROP CONSTRAINT %s", this.getTableName(table), this.delimiter(dropConstraint));
    }

    @Override
    protected String getDropIndexBaseSql(String dropIndexName, String tableName) {
        return String.format("DROP INDEX %s", this.delimiter(dropIndexName));
    }

    private String getSeqSql(String schema) {
        String queryStr = "select SEQUENCE_NAME from all_sequences ";
        if (schema != null && schema.trim().length() > 0) {
            queryStr = queryStr + " where SEQUENCE_OWNER='" + schema.toUpperCase() + "'";
        }
        return queryStr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getAllSequence(Connection connection, String schema) throws SQLException {
        Statement statement = null;
        ResultSet rs = null;
        ArrayList<String> seqlist = new ArrayList<String>();
        try {
            statement = connection.createStatement();
            rs = statement.executeQuery(this.getSeqSql(schema));
            if (this.cacheSeqList != null) {
                List<String> list = this.cacheSeqList;
                return list;
            }
            this.cacheSeqList = new ArrayList<String>();
            while (rs.next()) {
                String seq = rs.getString(1);
                if (seq != null) {
                    seq = seq.toUpperCase();
                }
                seqlist.add(seq);
            }
            this.cacheSeqList.addAll(seqlist);
        }
        finally {
            if (statement != null) {
                statement.close();
            }
            if (rs != null) {
                rs.close();
            }
        }
        return this.cacheSeqList;
    }

    @Override
    public List<String> getClearTableSql(Table table, Connection connection) throws SQLException {
        ArrayList<String> clearSqls = new ArrayList<String>();
        this.clearSeq(clearSqls, table, connection);
        return clearSqls;
    }

    private void clearSeq(List<String> clearsqls, Table table, Connection connection) throws SQLException {
        boolean isSeqExits = this.getAllSequence(connection, table.getSchema()).contains(this.getSeqName(table));
        if (isSeqExits) {
            clearsqls.add(String.format("DROP SEQUENCE %s", this.getSeqName(table)));
            this.logger.logMessage(LogLevel.WARN, "\u8868\u683c[{0}]\u5728\u6570\u636e\u5e93\u4e2d\u4e0d\u5b58\u5728,\u5c06\u6e05\u7406\u6b8b\u7559\u7684\u5e8f\u5217[{1}]", new Object[]{table.getName(), this.getSeqName(table)});
        }
    }

    @Override
    protected void dealDefaultValueUpdate(StringBuffer alterTypeBuffer, String fieldDefaultValue, String columnDef) {
        if (columnDef != null && fieldDefaultValue == null) {
            alterTypeBuffer.append(" DEFAULT NULL");
        } else {
            this.appendDefaultValue(fieldDefaultValue, alterTypeBuffer);
        }
    }

    @Override
    protected void dealNotNullSql(StringBuffer alterTypeBuffer, TableField field, boolean dbNullAble) {
        if (field.getNotNull() && dbNullAble) {
            alterTypeBuffer.append(" NOT NULL");
        } else if (!field.getNotNull() && !dbNullAble) {
            alterTypeBuffer.append(" NULL");
        }
    }

    @Override
    protected boolean checkIndexBaseSame(Index tableIndex, Map<String, String> dbIndexMap, Connection con) {
        boolean isDbReverse = this.isIndexReverse(tableIndex, con);
        boolean isIndexReverse = false;
        if (tableIndex.getReverse() != null) {
            isIndexReverse = tableIndex.getReverse();
        }
        return super.checkIndexBaseSame(tableIndex, dbIndexMap, con) && isDbReverse == isIndexReverse;
    }

    private boolean isIndexReverse(Index tableIndex, Connection con) {
        Statement statement = null;
        ResultSet rs = null;
        try {
            String indexType;
            statement = con.createStatement();
            rs = statement.executeQuery(String.format("select INDEX_TYPE from user_indexes where index_name='%s'", tableIndex.getName().toUpperCase()));
            if (rs.next() && "NORMAL/REV".equalsIgnoreCase(indexType = rs.getString("INDEX_TYPE"))) {
                boolean bl = true;
                return bl;
            }
        }
        catch (SQLException e) {
            throw new DatabaseRuntimeException(e);
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return false;
    }

    @Override
    protected void appendIndexReverse(StringBuffer ddlBuffer, Index index) {
        if (index.getReverse() != null && index.getReverse().booleanValue()) {
            ddlBuffer.append(" REVERSE");
        }
    }
}

