/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.database.table.impl;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.tinygroup.commons.tools.CollectionUtil;
import org.tinygroup.commons.tools.StringUtil;
import org.tinygroup.database.config.table.ForeignReference;
import org.tinygroup.database.config.table.Index;
import org.tinygroup.database.config.table.IndexField;
import org.tinygroup.database.config.table.Table;
import org.tinygroup.database.config.table.TableField;
import org.tinygroup.database.config.tablespace.TableSpace;
import org.tinygroup.database.table.TableProcessor;
import org.tinygroup.database.table.TableSqlProcessor;
import org.tinygroup.database.util.ColTypeGroupUtil;
import org.tinygroup.database.util.DataBaseNameUtil;
import org.tinygroup.database.util.DataBaseUtil;
import org.tinygroup.database.util.SqlUtil;
import org.tinygroup.metadata.config.stddatatype.StandardType;
import org.tinygroup.metadata.config.stdfield.StandardField;
import org.tinygroup.metadata.util.MetadataUtil;

public abstract class SqlProcessorImpl
implements TableSqlProcessor {
    private TableProcessor tableProcessor;
    private Map<String, Map<String, Map<String, String>>> allTableColsCache = new HashMap<String, Map<String, Map<String, String>>>();

    @Override
    public TableProcessor getTableProcessor() {
        return this.tableProcessor;
    }

    @Override
    public void setTableProcessor(TableProcessor tableProcessor) {
        this.tableProcessor = tableProcessor;
    }

    protected abstract String getDatabaseType();

    @Override
    public List<String> getCreateSql(Table table, String packageName) {
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(this.getTableCreateSql(table, packageName));
        list.addAll(this.getSeqTriggerSql(table, packageName));
        list.addAll(this.getForeignKeySqls(table, packageName));
        list.addAll(this.getIndexCreateSql(table, packageName));
        return list;
    }

    protected List<String> getSeqTriggerSql(Table table, String packageName) {
        return new ArrayList<String>();
    }

    protected void appendPrimarySql(StringBuffer ddlBuffer, Table table, List<String> list) {
        List<TableField> fieldList = table.getFieldList();
        StringBuffer keyBuffer = new StringBuffer();
        boolean isFirst = true;
        for (int i = 0; i < fieldList.size(); ++i) {
            TableField tableField = fieldList.get(i);
            Boolean primary = tableField.getPrimary();
            if (primary == null || !primary.booleanValue()) continue;
            if (!isFirst) {
                keyBuffer.append(",");
            } else {
                isFirst = false;
            }
            StandardField standardField = MetadataUtil.getStandardField((String)tableField.getStandardFieldId(), (ClassLoader)this.getClass().getClassLoader());
            keyBuffer.append(this.delimiter(DataBaseUtil.getDataBaseName(standardField.getName())));
        }
        if (0 == keyBuffer.length()) {
            return;
        }
        ddlBuffer.append(String.format(",CONSTRAINT %s PRIMARY KEY (%s)", this.delimiter("pk_" + table.getNameWithOutSchema()), keyBuffer));
    }

    @Override
    public List<String> getForeignKeySqls(Table table, String packageName) {
        return this.getForeignKeySqls(table, packageName, table.getForeignReferences());
    }

    public List<String> getForeignKeySqls(Table table, String packageName, List<ForeignReference> foreignReferences) {
        ArrayList<String> foreignSqls = new ArrayList<String>();
        if (!CollectionUtil.isEmpty(foreignReferences)) {
            for (ForeignReference foreignReference : foreignReferences) {
                Table foreignTable = this.tableProcessor.getTableById(foreignReference.getMainTable());
                String sql = String.format("ALTER TABLE %s ADD CONSTRAINT %s FOREIGN KEY (%s) REFERENCES %s(%s)", this.getTableName(table), this.delimiter(foreignReference.getName()), this.delimiter(this.getFieldStdFieldName(foreignReference.getForeignField(), table)), this.delimiter(foreignTable.getNameWithOutSchema()), this.delimiter(this.getFieldStdFieldName(foreignReference.getReferenceField(), foreignTable)));
                foreignSqls.add(sql);
            }
        }
        return foreignSqls;
    }

    @Override
    public List<String> getTableCreateSql(Table table, String packageName) {
        StringBuffer ddlBuffer = new StringBuffer();
        ArrayList<String> list = new ArrayList<String>();
        this.appendHeader(ddlBuffer, table, list);
        this.appendBody(ddlBuffer, table, list);
        this.appendFooter(ddlBuffer, table, list);
        list.add(0, ddlBuffer.toString());
        return list;
    }

    @Override
    public List<String> getIndexCreateSql(Table table, String packageName) {
        return this.appendIndexes(table);
    }

    @Override
    public List<String> getUpdateSql(Table table, String packageName, Connection connection) throws SQLException {
        ArrayList<String> list = new ArrayList<String>();
        DatabaseMetaData metadata = connection.getMetaData();
        String catalog = connection.getCatalog();
        this.getTableColumnUpdate(table, packageName, metadata, catalog, list);
        this.getOtherUpdate(table, packageName, connection, list);
        return list;
    }

    protected void getOtherUpdate(Table table, String packageName, Connection connection, List<String> list) throws SQLException {
        this.getChangedFooterComment(connection, table, list);
        this.getSeqTriggerUpdate(connection, table, list);
        this.getForeignUpdate(table, packageName, connection, list);
        this.getIndexUpdate(connection, table, list);
    }

    protected void getSeqTriggerUpdate(Connection connection, Table table, List<String> list) throws SQLException {
    }

    protected void getIndexUpdate(Connection connection, Table table, List<String> list) throws SQLException {
        List<Index> tableIndexList = table.getIndexList();
        if (tableIndexList == null) {
            return;
        }
        Map<String, Map<String, String>> dbIndexMaps = this.getDbIndexColumns(connection.getMetaData(), this.getSchema(table.getSchema(), connection), table);
        ArrayList<String> preDropIndexes = new ArrayList<String>();
        List<Index> preAddIndexes = this.mergeIndexes(tableIndexList, table);
        this.dealIndex(preAddIndexes, preDropIndexes, table, dbIndexMaps, connection);
        for (String dropIndexName : preDropIndexes) {
            list.add(this.getDropIndexBaseSql(dropIndexName, table.getNameWithOutSchema()));
        }
        for (Index index : preAddIndexes) {
            list.add(this.getIndex(index, table));
        }
    }

    protected String getDropIndexBaseSql(String dropIndexName, String nameWithOutSchema) {
        return String.format("ALTER TABLE %s DROP INDEX %s", this.delimiter(nameWithOutSchema), this.delimiter(dropIndexName));
    }

    protected String getSchema(String schema, Connection connection) throws SQLException {
        return schema;
    }

    private List<Index> mergeIndexes(List<Index> tableIndexList, Table table) {
        ArrayList<Index> newIndexes = new ArrayList<Index>();
        ArrayList<String> indexNames = new ArrayList<String>();
        for (Index index : tableIndexList) {
            newIndexes.add(index);
            indexNames.add(index.getName());
        }
        for (TableField tableField : table.getFieldList()) {
            String isUniqueIndexName;
            StandardField standardField = MetadataUtil.getStandardField((String)tableField.getStandardFieldId(), (ClassLoader)this.getClass().getClassLoader());
            if (tableField.getPrimary() || !this.isUnique(tableField) || indexNames.contains(isUniqueIndexName = ("idx_" + table.getNameWithOutSchema() + "_" + standardField.getName()).toUpperCase())) continue;
            Index index = new Index();
            index.setName(isUniqueIndexName);
            index.setUnique(true);
            ArrayList<IndexField> fields = new ArrayList<IndexField>();
            IndexField indexField = new IndexField();
            indexField.setField(tableField.getId());
            fields.add(indexField);
            index.setFields(fields);
            newIndexes.add(index);
        }
        return newIndexes;
    }

    private void dealIndex(List<Index> preAddIndexes, List<String> preDropIndexes, Table table, Map<String, Map<String, String>> dbIndexMaps, Connection con) {
        for (String dbIndexName : dbIndexMaps.keySet()) {
            if ("PRIMARY".equalsIgnoreCase(dbIndexName)) continue;
            preDropIndexes.add(dbIndexName);
        }
        this.dealConstraintIndex(table, preDropIndexes, dbIndexMaps);
    }

    protected boolean checkIndexBaseSame(Index tableIndex, Map<String, String> dbIndexMap, Connection con) {
        return tableIndex.getUnique() != Boolean.valueOf(dbIndexMap.get("NON_UNIQUE"));
    }

    private void dealConstraintIndex(Table table, List<String> preDropIndexes, Map<String, Map<String, String>> dbIndexes) {
        List<ForeignReference> foreignReferenceList = table.getForeignReferences();
        Iterator<String> preDropIndexesIter = preDropIndexes.iterator();
        block0: while (preDropIndexesIter.hasNext()) {
            Map<String, String> indexCols;
            String preDropIndexName = preDropIndexesIter.next();
            for (ForeignReference fr : foreignReferenceList) {
                String stdForeignField = this.getFieldStdFieldName(fr.getForeignField(), table);
                indexCols = dbIndexes.get(preDropIndexName);
                if (!indexCols.get("COLUMN_NAME").equalsIgnoreCase(stdForeignField)) continue;
                preDropIndexesIter.remove();
                break;
            }
            for (TableField tableField : table.getFieldList()) {
                StandardField standardField = MetadataUtil.getStandardField((String)tableField.getStandardFieldId(), (ClassLoader)this.getClass().getClassLoader());
                indexCols = dbIndexes.get(preDropIndexName);
                if (!tableField.getPrimary() || !indexCols.get("COLUMN_NAME").equalsIgnoreCase(standardField.getName())) continue;
                preDropIndexesIter.remove();
                continue block0;
            }
        }
    }

    private boolean checkIndexFieldSame(Table table, List<IndexField> fields, String dbFields) {
        List<String> dbFieldArray = Arrays.asList(dbFields.split(","));
        if (fields.size() != dbFieldArray.size()) {
            return false;
        }
        for (IndexField indexField : fields) {
            String stdFieldName = this.getFieldStdFieldName(indexField.getField(), table);
            String filedName = stdFieldName.toUpperCase();
            if (dbFieldArray.contains(filedName)) continue;
            return false;
        }
        return true;
    }

    protected void getChangedFooterComment(Connection connection, Table table, List<String> list) throws SQLException {
        DatabaseMetaData metadata = connection.getMetaData();
        String catalog = connection.getCatalog();
        Map<String, Map<String, String>> dbColumns = this.getColumns(metadata, catalog, table);
        for (TableField field : table.getFieldList()) {
            StandardField standardField = MetadataUtil.getStandardField((String)field.getStandardFieldId(), (ClassLoader)this.getClass().getClassLoader());
            String standardComment = this.getComment(standardField);
            if (standardField.getName() != null) {
                String remarks;
                Map<String, String> attribute = dbColumns.get(standardField.getName().toLowerCase());
                if (attribute == null) {
                    attribute = dbColumns.get(standardField.getName().toUpperCase());
                }
                String string = remarks = attribute == null ? null : this.getDbColumnRemarks(attribute);
                if (StringUtil.equals((String)standardComment, (String)remarks)) continue;
            }
            this.appendFooterColumnComment(table, standardField, standardComment, list);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<Map<String, String>> getDbForeignList(Connection connection, Table table) throws SQLException {
        String querySchemaName = this.getQuerySchemaName(this.getSchema(table.getSchema(), connection), connection.getCatalog());
        String sql = this.getQueryForeignSql(table, querySchemaName);
        ArrayList<Map<String, String>> flist = new ArrayList<Map<String, String>>();
        if (sql != null) {
            Statement statement = null;
            ResultSet rs = null;
            try {
                statement = connection.createStatement();
                rs = statement.executeQuery(sql);
                while (rs.next()) {
                    String constraintName = rs.getString("CONSTRAINT_NAME");
                    String columnName = rs.getString("COLUMN_NAME");
                    String referenceTableName = rs.getString("REFERENCED_TABLE_NAME");
                    String referenceColumnName = rs.getString("REFERENCED_COLUMN_NAME");
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("COLUMN_NAME", columnName);
                    map.put("CONSTRAINT_NAME", constraintName);
                    map.put("REFERENCED_TABLE_NAME", referenceTableName);
                    map.put("REFERENCED_COLUMN_NAME", referenceColumnName);
                    flist.add(map);
                }
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
                if (rs != null) {
                    rs.close();
                }
            }
        }
        return flist;
    }

    protected void getForeignUpdate(Table table, String packageName, Connection connection, List<String> list) throws SQLException {
        List<Map<String, String>> dbForeignList = this.getDbForeignList(connection, table);
        List<ForeignReference> foreignRefs = table.getForeignReferences();
        List<ForeignReference> preparedForeignRefs = this.cloneReferences(foreignRefs);
        ArrayList<String> dropConstraints = new ArrayList<String>();
        for (Map<String, String> dbForeignMap : dbForeignList) {
            int index = this.indexOfTableReference(preparedForeignRefs, table, dbForeignMap);
            if (index >= 0) {
                preparedForeignRefs.remove(index);
                continue;
            }
            dropConstraints.add(dbForeignMap.get("CONSTRAINT_NAME"));
        }
        for (String dropConstraint : dropConstraints) {
            list.add(this.getDropForeignSql(dropConstraint, table));
        }
        list.addAll(this.getForeignKeySqls(table, packageName, preparedForeignRefs));
    }

    protected String getDropForeignSql(String dropConstraint, Table table) {
        return String.format("ALTER TABLE %s DROP FOREIGN KEY %s", this.getTableName(table), this.delimiter(dropConstraint));
    }

    private String getQuerySchemaName(String schema, String catalog) {
        return schema != null && schema.trim().length() != 0 ? schema : catalog;
    }

    private int indexOfTableReference(List<ForeignReference> foreignRefs, Table table, Map<String, String> dbForeignMap) {
        for (int i = 0; i < foreignRefs.size(); ++i) {
            ForeignReference fr = foreignRefs.get(i);
            Table foreignTable = this.tableProcessor.getTableById(fr.getMainTable());
            String stdRefFieldName = this.getFieldStdFieldName(fr.getReferenceField(), foreignTable);
            String stdForeignField = this.getFieldStdFieldName(fr.getForeignField(), table);
            String constraintName = dbForeignMap.get("CONSTRAINT_NAME");
            String columnName = dbForeignMap.get("COLUMN_NAME");
            String referenceTableName = dbForeignMap.get("REFERENCED_TABLE_NAME");
            String referenceColumnName = dbForeignMap.get("REFERENCED_COLUMN_NAME");
            if (!stdRefFieldName.equalsIgnoreCase(referenceColumnName) || !fr.getName().equalsIgnoreCase(constraintName) || !foreignTable.getNameWithOutSchema().equalsIgnoreCase(referenceTableName) || !stdForeignField.equalsIgnoreCase(columnName)) continue;
            return i;
        }
        return -1;
    }

    protected String getQueryForeignSql(Table table, String schema) {
        return null;
    }

    private List<ForeignReference> cloneReferences(List<ForeignReference> foreignRefs) {
        ArrayList<ForeignReference> cloneForeignRefs = new ArrayList<ForeignReference>();
        for (ForeignReference foreignReference : foreignRefs) {
            cloneForeignRefs.add(foreignReference);
        }
        return cloneForeignRefs;
    }

    protected void getTableColumnUpdate(Table table, String packageName, DatabaseMetaData metadata, String catalog, List<String> list) throws SQLException {
        Map<String, Map<String, String>> dbColumns = this.getColumns(metadata, catalog, table);
        Map<String, TableField> tableFieldDbNames = this.getFiledDbNames(table.getFieldList());
        HashMap<String, TableField> existInTable = new HashMap<String, TableField>();
        List<String> dropFields = this.checkTableColumn(dbColumns, tableFieldDbNames, existInTable);
        for (TableField field : tableFieldDbNames.values()) {
            if (!field.getPrimary()) continue;
            list.add(this.getDropSql(table, packageName));
            list.addAll(this.getCreateSql(table, packageName));
            return;
        }
        List<String> existUpdateList = this.dealExistFields(existInTable, dbColumns, table);
        List<String> dropList = this.dealDropFields(dropFields, table);
        List<String> addList = this.dealAddFields(tableFieldDbNames, packageName, table);
        list.addAll(existUpdateList);
        list.addAll(dropList);
        list.addAll(addList);
    }

    protected List<String> checkTableColumn(Map<String, Map<String, String>> columns, Map<String, TableField> fieldDbNames, Map<String, TableField> existInTable) {
        ArrayList<String> dropFields = new ArrayList<String>();
        for (String col : columns.keySet()) {
            String temp = col.toUpperCase();
            if (fieldDbNames.containsKey(temp)) {
                existInTable.put(temp, fieldDbNames.get(temp));
                fieldDbNames.remove(temp);
                continue;
            }
            dropFields.add(col);
        }
        return dropFields;
    }

    protected List<String> dealDropFields(List<String> dropFields, Table table) {
        ArrayList<String> droplist = new ArrayList<String>();
        for (String column : dropFields) {
            StringBuffer ddlBuffer = new StringBuffer();
            ddlBuffer.append(String.format("ALTER TABLE %s DROP COLUMN %s", this.getTableName(table), this.delimiter(column)));
            droplist.add(ddlBuffer.toString());
        }
        return droplist;
    }

    protected List<String> dealAddFields(Map<String, TableField> fieldDbNames, String packageName, Table table) {
        ArrayList<String> addList = new ArrayList<String>();
        for (TableField field : fieldDbNames.values()) {
            StringBuffer ddlBuffer = new StringBuffer();
            ddlBuffer.append(String.format("ALTER TABLE %s ADD ", this.getTableName(table)));
            this.appendField(ddlBuffer, field, addList, table);
            addList.add(ddlBuffer.toString());
        }
        return addList;
    }

    protected List<String> dealExistFields(Map<String, TableField> existInTable, Map<String, Map<String, String>> dbColumns, Table table) {
        ArrayList<String> existUpdateList = new ArrayList<String>();
        for (String fieldName : existInTable.keySet()) {
            TableField field = existInTable.get(fieldName);
            if (field.getPrimary()) continue;
            StandardField standardField = MetadataUtil.getStandardField((String)field.getStandardFieldId(), (ClassLoader)this.getClass().getClassLoader());
            Map<String, String> attribute = dbColumns.get(fieldName);
            String tableDataType = MetadataUtil.getStandardFieldType((String)standardField.getId(), (String)this.getDatabaseType(), (ClassLoader)this.getClass().getClassLoader());
            String standardFieldName = standardField.getName();
            String dbColumnType = this.getDbColumnType(attribute).replaceAll(" ", "").toLowerCase();
            String remarks = this.getDbColumnRemarks(attribute);
            String columnDef = this.getDbColumnColumnDef(attribute);
            String standardComment = this.getComment(standardField);
            String standardDefault = this.getDefaultValue(field, standardField);
            standardDefault = StringUtil.defaultIfEmpty((String)standardDefault, null);
            columnDef = StringUtil.defaultIfEmpty((String)columnDef, null);
            boolean dbNullAble = Integer.parseInt(attribute.get("NULLABLE")) == 1;
            boolean fieldNotNull = field.getNotNull();
            if (this.checkTypeSame(dbColumnType, tableDataType, attribute.get("DATA_TYPE")) && this.checkDefSame(standardDefault, columnDef) && this.checkCommentSame(standardComment, remarks) && dbNullAble != fieldNotNull) continue;
            StringBuffer alterTypeBuffer = new StringBuffer();
            alterTypeBuffer.append(this.createAlterTypeSql(table.getName(), standardFieldName, tableDataType));
            if (!field.isAutoIncrease()) {
                String fieldDefaultValue = this.getDefaultValue(field, standardField);
                this.dealDefaultValueUpdate(alterTypeBuffer, fieldDefaultValue, columnDef);
            }
            this.dealNotNullSql(alterTypeBuffer, field, dbNullAble);
            this.appendComment(standardComment, alterTypeBuffer, existUpdateList);
            existUpdateList.add(alterTypeBuffer.toString());
        }
        return existUpdateList;
    }

    protected void dealNotNullSql(StringBuffer alterTypeBuffer, TableField field, boolean dbNullAble) {
        if (field.getNotNull()) {
            alterTypeBuffer.append(" NOT NULL");
        }
    }

    protected void dealDefaultValueUpdate(StringBuffer alterTypeBuffer, String fieldDefaultValue, String columnDef) {
        if (fieldDefaultValue != null) {
            this.appendDefaultValue(fieldDefaultValue, alterTypeBuffer);
        }
    }

    private boolean isOnlyOneIdx(Map<String, String> uniqueColumns, String fieldName) {
        Collection<String> uCols = uniqueColumns.values();
        int idxNum = 0;
        for (String col : uCols) {
            if (!col.equalsIgnoreCase(fieldName)) continue;
            ++idxNum;
        }
        return idxNum == 1;
    }

    private boolean isUnique(TableField field) {
        Boolean unique = field.getUnique();
        return unique != null && unique != false;
    }

    protected boolean checkUniqueSame(Map<String, String> uniqueColumns, String indexName, boolean isFieldUnique) {
        boolean isDbUnique = false;
        if (uniqueColumns != null && uniqueColumns.keySet().contains(indexName.toUpperCase())) {
            isDbUnique = true;
        }
        return isDbUnique == isFieldUnique;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, Map<String, String>> getDbIndexColumns(DatabaseMetaData metadata, String schema, Table table) throws SQLException {
        ResultSet colRet = null;
        HashMap<String, Map<String, String>> dbIndexMap = new HashMap<String, Map<String, String>>();
        try {
            Connection connection = metadata.getConnection();
            colRet = metadata.getIndexInfo(connection.getCatalog(), schema, table.getNameWithOutSchema(), false, false);
            boolean isExists = false;
            while (colRet.next()) {
                isExists = true;
                this.addToDbIndexMap(colRet, dbIndexMap);
            }
            if (!isExists) {
                colRet = metadata.getIndexInfo(connection.getCatalog(), schema, table.getNameWithOutSchema().toUpperCase(), false, false);
                while (colRet.next()) {
                    this.addToDbIndexMap(colRet, dbIndexMap);
                }
            }
            HashMap<String, Map<String, String>> hashMap = dbIndexMap;
            return hashMap;
        }
        finally {
            if (colRet != null) {
                colRet.close();
            }
        }
    }

    private void addToDbIndexMap(ResultSet colRet, Map<String, Map<String, String>> dbIndexMap) throws SQLException {
        if (colRet.getString("INDEX_NAME") == null) {
            return;
        }
        String dbIndexName = colRet.getString("INDEX_NAME").toUpperCase();
        if (dbIndexMap.keySet().contains(dbIndexName)) {
            Map<String, String> indexMap = dbIndexMap.get(dbIndexName);
            String col_name = indexMap.get("COLUMN_NAME");
            indexMap.put("COLUMN_NAME", col_name + "," + colRet.getString("COLUMN_NAME").toUpperCase());
        } else {
            HashMap<String, String> indexMap = new HashMap<String, String>();
            indexMap.put("INDEX_NAME", dbIndexName);
            indexMap.put("NON_UNIQUE", colRet.getString("NON_UNIQUE"));
            indexMap.put("COLUMN_NAME", colRet.getString("COLUMN_NAME").toUpperCase());
            indexMap.put("TABLE_NAME", colRet.getString("TABLE_NAME").toUpperCase());
            dbIndexMap.put(dbIndexName, indexMap);
        }
    }

    private String getUniqueIndexInfo(String tableName, String schema) {
        StringBuffer sb = new StringBuffer();
        sb.append("SHOW INDEX FROM ");
        if (schema != null) {
            sb.append(schema).append(".");
        }
        sb.append(tableName).append(" WHERE Non_unique = 0");
        return sb.toString();
    }

    private boolean checkDefSame(String standardDefault, String columnDef) {
        String preComparedStdDef = standardDefault;
        if (standardDefault != null) {
            preComparedStdDef = SqlUtil.trim(standardDefault.trim(), "^['\"`]?|['\"`]?$");
        }
        if (columnDef != null) {
            columnDef = columnDef.indexOf("NULL") >= 0 && "NULL".equalsIgnoreCase(columnDef.replaceAll("\n", "")) ? null : SqlUtil.trim(columnDef.trim(), "^['\"`]?|['\"`]?$");
        }
        return StringUtil.equals((String)preComparedStdDef, (String)columnDef);
    }

    protected boolean checkCommentSame(String standardComment, String remarks) {
        return StringUtil.equals((String)standardComment, (String)remarks);
    }

    protected boolean checkTypeSame(String dbColumnType, String tableDataType, String dbDataType) {
        String tbDataTypeLower = tableDataType.replaceAll(" ", "").replaceAll(",0", "").toLowerCase();
        return dbColumnType.replaceAll(",0", "").indexOf(tbDataTypeLower) != -1;
    }

    protected abstract String createAlterTypeSql(String var1, String var2, String var3);

    protected void appendBody(StringBuffer ddlBuffer, Table table, List<String> list) {
        boolean isFirst = true;
        for (TableField field : table.getFieldList()) {
            if (!isFirst) {
                ddlBuffer.append(",");
            } else {
                isFirst = false;
            }
            this.appendField(ddlBuffer, field, list, table);
        }
        this.appendPrimarySql(ddlBuffer, table, list);
    }

    protected void appendField(StringBuffer ddlBuffer, TableField field, List<String> list, Table table) {
        Boolean notNull;
        StandardField standardField = MetadataUtil.getStandardField((String)field.getStandardFieldId(), (ClassLoader)this.getClass().getClassLoader());
        ddlBuffer.append(String.format(" %s ", this.delimiter(DataBaseUtil.getDataBaseName(standardField.getName()))));
        ddlBuffer.append(" ");
        ddlBuffer.append(MetadataUtil.getStandardFieldType((String)standardField.getId(), (String)this.getDatabaseType(), (ClassLoader)this.getClass().getClassLoader()));
        String fieldDefaultValue = this.getDefaultValue(field, standardField);
        if (!field.isAutoIncrease()) {
            this.appendDefaultValue(fieldDefaultValue, ddlBuffer);
        }
        if ((notNull = Boolean.valueOf(field.getNotNull())) != null && notNull.booleanValue()) {
            ddlBuffer.append(" NOT NULL");
        }
        if (field.isAutoIncrease() && field.getPrimary()) {
            ddlBuffer.append(this.appendIncrease());
        }
        this.dealComment(ddlBuffer, standardField, list);
    }

    private void dealComment(StringBuffer ddlBuffer, StandardField standardField, List<String> list) {
        String comment = this.getComment(standardField);
        this.appendComment(comment, ddlBuffer, list);
    }

    private String getComment(StandardField standardField) {
        String title = standardField.getTitle();
        String description = standardField.getDescription();
        String comment = StringUtil.isBlank((String)title) ? description : (StringUtil.isBlank((String)description) ? title : title + " " + description);
        return comment == null ? "" : comment;
    }

    protected void appendComment(String comment, StringBuffer ddlBuffer, List<String> list) {
        if (!StringUtil.isBlank((String)comment)) {
            ddlBuffer.append(" COMMENT ").append("'").append(comment.replaceAll("'", "\\\\'").replaceAll("\"", "\\\\\"")).append("'");
        }
    }

    protected void appendFooterComment(Table table, List<String> list) {
        for (TableField field : table.getFieldList()) {
            StandardField standardField = MetadataUtil.getStandardField((String)field.getStandardFieldId(), (ClassLoader)this.getClass().getClassLoader());
            String standardComment = this.getComment(standardField);
            this.appendFooterColumnComment(table, standardField, standardComment, list);
        }
    }

    private void appendFooterColumnComment(Table table, StandardField standardField, String standardComment, List list) {
        String columnName = StringUtil.isBlank((String)table.getSchema()) ? String.format("%s.%s", this.delimiter(table.getNameWithOutSchema()), this.delimiter(standardField.getName())) : String.format("%s.%s.%s", this.delimiter(table.getSchema()), this.delimiter(table.getNameWithOutSchema()), this.delimiter(standardField.getName()));
        StringBuffer commentBuffer = new StringBuffer();
        commentBuffer.append("COMMENT ON COLUMN ").append(columnName).append(" IS ").append("'").append(standardComment).append("'");
        list.add(commentBuffer.toString());
    }

    protected void appendDefaultValue(String defaultValue, StringBuffer ddlBuffer) {
        if (!StringUtil.isBlank((String)defaultValue)) {
            ddlBuffer.append(" DEFAULT ").append(defaultValue);
        }
    }

    protected String appendIncrease() {
        return "";
    }

    private List<String> appendIndexes(Table table) {
        table.setIndexList(this.mergeIndexes(table.getIndexList(), table));
        ArrayList<String> indexSqlList = new ArrayList<String>();
        List<Index> list = table.getIndexList();
        if (list != null) {
            for (Index index : list) {
                indexSqlList.add(this.getIndex(index, table));
            }
        }
        return indexSqlList;
    }

    private String getIndex(Index index, Table table) {
        StringBuffer ddlBuffer = new StringBuffer();
        Boolean unique = index.getUnique();
        if (unique != null && unique.booleanValue()) {
            ddlBuffer.append("CREATE UNIQUE INDEX ");
        } else {
            ddlBuffer.append("CREATE INDEX ");
        }
        ddlBuffer.append(this.delimiter(index.getName()));
        ddlBuffer.append(" ON ");
        if (!StringUtil.isEmpty((String)table.getSchema())) {
            ddlBuffer.append(this.delimiter(table.getSchema())).append(".");
        }
        ddlBuffer.append(this.delimiter(table.getNameWithOutSchema())).append(" ( ");
        List<IndexField> fields = index.getFields();
        String fieldsStr = "";
        if (fields != null) {
            for (IndexField field : fields) {
                fieldsStr = fieldsStr + "," + this.delimiter(this.getFieldStdFieldName(field.getField(), table));
                if (StringUtil.isEmpty((String)field.getDirection())) continue;
                fieldsStr = fieldsStr + " " + field.getDirection();
            }
            if (fieldsStr.startsWith(",")) {
                fieldsStr = fieldsStr.substring(1);
            }
        }
        ddlBuffer.append(fieldsStr);
        ddlBuffer.append(" ) ");
        this.appendIndexReverse(ddlBuffer, index);
        this.appendTableSpace(ddlBuffer, table);
        return ddlBuffer.toString();
    }

    protected void appendIndexReverse(StringBuffer ddlBuffer, Index index) {
    }

    protected String getIndexName(Index index, Table table) {
        String indexName = null;
        indexName = table.getSchema() == null || "".equals(table.getSchema()) ? index.getName() : String.format("%s.%s", this.delimiter(table.getSchema()), this.delimiter(index.getName()));
        return indexName;
    }

    private String getFieldStdFieldName(String fieldId, Table table) {
        for (TableField field : table.getFieldList()) {
            if (!field.getId().equals(fieldId)) continue;
            StandardField standardField = MetadataUtil.getStandardField((String)field.getStandardFieldId(), (ClassLoader)this.getClass().getClassLoader());
            return DataBaseUtil.getDataBaseName(standardField.getName());
        }
        throw new RuntimeException(String.format("\u672a\u627e\u5230ID\uff1a%s\u7684\u8868\u683c\u5b57\u6bb5(\u6216\u8be5\u8868\u683c\u5b57\u6bb5\u5bf9\u5e94\u7684\u6807\u51c6\u5b57\u6bb5)", fieldId));
    }

    protected void appendFooter(StringBuffer ddlBuffer, Table table, List<String> list) {
        ddlBuffer.append(")");
        this.appendTableSpace(ddlBuffer, table);
    }

    protected void appendTableSpace(StringBuffer ddlBuffer, Table table) {
        if (!StringUtil.isEmpty((String)table.getTableSpace())) {
            TableSpace tableSpace = DataBaseUtil.getTableSpace(this.getClass().getClassLoader(), table.getTableSpace());
            ddlBuffer.append(" TABLESPACE ").append(this.delimiter(tableSpace.getName()));
        }
    }

    private void appendHeader(StringBuffer ddlBuffer, Table table, List<String> list) {
        ddlBuffer.append(String.format("CREATE TABLE %s (", this.getTableName(table)));
    }

    protected String getTableName(Table table) {
        if (table.getSchema() == null || "".equals(table.getSchema())) {
            return this.delimiter(table.getNameWithOutSchema());
        }
        return String.format("%s.%s", this.delimiter(table.getSchema()), this.delimiter(table.getNameWithOutSchema()));
    }

    private Map<String, TableField> getFiledDbNames(List<TableField> fields) {
        HashMap<String, TableField> filedDbNames = new HashMap<String, TableField>();
        for (TableField field : fields) {
            StandardField standardField = MetadataUtil.getStandardField((String)field.getStandardFieldId(), (ClassLoader)this.getClass().getClassLoader());
            String filedDbName = DataBaseUtil.getDataBaseName(standardField.getName());
            filedDbNames.put(DataBaseNameUtil.getColumnNameFormat(filedDbName), field);
        }
        return filedDbNames;
    }

    @Override
    public String getDropSql(Table table, String packageName) {
        return String.format("DROP TABLE %s", this.getTableName(table));
    }

    protected Map<String, Map<String, String>> getColumns(DatabaseMetaData metadata, String catalog, Table table) throws SQLException {
        String tableName = table.getNameWithOutSchema();
        return this.getColumns(metadata, catalog, this.getSchema(table.getSchema(), metadata.getConnection()), tableName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Map<String, String>> getColumns(DatabaseMetaData metadata, String catalog, String schema, String tableName) throws SQLException {
        ResultSet colRet = null;
        if (this.allTableColsCache.containsKey(tableName.toUpperCase())) {
            return this.allTableColsCache.get(tableName.toUpperCase());
        }
        HashMap<String, Map<String, String>> map = new HashMap<String, Map<String, String>>();
        this.allTableColsCache.put(tableName.toUpperCase(), map);
        try {
            colRet = metadata.getColumns(catalog, schema, tableName, "%");
            boolean exist = false;
            while (colRet.next()) {
                this.getMapByResultSet(colRet, map);
                exist = true;
            }
            if (!exist) {
                colRet.close();
                colRet = metadata.getColumns(catalog, schema, tableName.toUpperCase(), "%");
                while (colRet.next()) {
                    this.getMapByResultSet(colRet, map);
                    exist = true;
                }
                if (!exist && schema != null) {
                    colRet.close();
                    colRet = metadata.getColumns(catalog, schema.toUpperCase(), tableName.toUpperCase(), "%");
                    while (colRet.next()) {
                        this.getMapByResultSet(colRet, map);
                        exist = true;
                    }
                }
            }
        }
        finally {
            if (colRet != null) {
                colRet.close();
            }
        }
        return map;
    }

    private void getMapByResultSet(ResultSet colRet, Map<String, Map<String, String>> map) throws SQLException {
        HashMap<String, String> attributes = new HashMap<String, String>();
        String columnName = colRet.getString("COLUMN_NAME");
        attributes.put("NULLABLE", colRet.getString("NULLABLE"));
        attributes.put("TYPE_NAME", colRet.getString("TYPE_NAME"));
        attributes.put("COLUMN_SIZE", colRet.getString("COLUMN_SIZE"));
        attributes.put("DECIMAL_DIGITS", colRet.getString("DECIMAL_DIGITS"));
        attributes.put("COLUMN_DEF", colRet.getString("COLUMN_DEF"));
        attributes.put("REMARKS", colRet.getString("REMARKS"));
        attributes.put("DATA_TYPE", colRet.getString("DATA_TYPE"));
        map.put(columnName.toUpperCase(), attributes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean checkTableExist(Table table, Connection connection) throws SQLException {
        ResultSet resultset = null;
        DatabaseMetaData metadata = connection.getMetaData();
        try {
            String schema = DataBaseUtil.getSchema(table, metadata);
            resultset = metadata.getTables(connection.getCatalog(), schema, table.getNameWithOutSchema(), new String[]{"TABLE"});
            if (resultset.next()) {
                boolean bl = true;
                return bl;
            }
            resultset.close();
            resultset = metadata.getTables(connection.getCatalog(), schema, table.getNameWithOutSchema().toUpperCase(), new String[]{"TABLE"});
            if (resultset.next()) {
                boolean bl = true;
                return bl;
            }
            resultset.close();
            resultset = metadata.getTables(connection.getCatalog(), schema.toUpperCase(), table.getNameWithOutSchema().toUpperCase(), new String[]{"TABLE"});
            if (resultset.next()) {
                boolean bl = true;
                return bl;
            }
        }
        finally {
            if (resultset != null) {
                resultset.close();
            }
        }
        return false;
    }

    protected String getDbColumnType(Map<String, String> attributes) {
        if (ColTypeGroupUtil.isNumberType(attributes.get("TYPE_NAME")) && (attributes.get("DECIMAL_DIGITS") == null || "0".equals(attributes.get("DECIMAL_DIGITS")))) {
            return attributes.get("TYPE_NAME");
        }
        String lengthInfo = attributes.get("COLUMN_SIZE");
        if (attributes.get("DECIMAL_DIGITS") != null) {
            lengthInfo = lengthInfo + "," + attributes.get("DECIMAL_DIGITS");
        }
        return String.format("%s(%s)", attributes.get("TYPE_NAME"), lengthInfo);
    }

    protected String getDbColumnRemarks(Map<String, String> attributes) {
        return attributes.get("REMARKS");
    }

    protected String getDbColumnColumnDef(Map<String, String> attributes) {
        return attributes.get("COLUMN_DEF");
    }

    private String getDefaultValue(TableField field, StandardField standardField) {
        String defaultId = this.getDefaultId(field, standardField);
        if (!StringUtil.isEmpty((String)defaultId)) {
            return MetadataUtil.getDefaultValue((String)defaultId, (String)this.getDatabaseType(), (ClassLoader)this.getClass().getClassLoader());
        }
        return null;
    }

    private String getDefaultId(TableField field, StandardField standardField) {
        String fieldDefaultId = standardField.getDefaultValue();
        if (StringUtil.isEmpty((String)fieldDefaultId)) {
            StandardType standardType = MetadataUtil.getStandardType((StandardField)standardField, (ClassLoader)this.getClass().getClassLoader());
            fieldDefaultId = standardType.getDefaultValueId();
        }
        return fieldDefaultId;
    }

    protected String delimiter(String name) {
        return name;
    }

    @Override
    public List<String> getClearTableSql(Table table, Connection connection) throws SQLException {
        return new ArrayList<String>();
    }
}

