/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.database.table.impl;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.tinygroup.commons.tools.CollectionUtil;
import org.tinygroup.database.ProcessorManager;
import org.tinygroup.database.config.table.ForeignReference;
import org.tinygroup.database.config.table.Table;
import org.tinygroup.database.config.table.Tables;
import org.tinygroup.database.exception.DatabaseRuntimeException;
import org.tinygroup.database.table.TableProcessor;
import org.tinygroup.database.table.TableSqlProcessor;
import org.tinygroup.metadata.util.MetadataUtil;

public class TableProcessorImpl
implements TableProcessor {
    private static TableProcessor tableProcessor = new TableProcessorImpl();
    private Map<String, Map<String, Table>> tableMap = new HashMap<String, Map<String, Table>>();
    private ProcessorManager processorManager;
    private List<Table> orderTables = new ArrayList<Table>();
    private Map<String, Table> idMap = new HashMap<String, Table>();
    private Map<String, Boolean> tableInited = new HashMap<String, Boolean>();
    private Map<String, Long> tableModifiedTimeMap = new HashMap<String, Long>();

    public static TableProcessor getTableProcessor() {
        return tableProcessor;
    }

    @Override
    public ProcessorManager getProcessorManager() {
        return this.processorManager;
    }

    @Override
    public void setProcessorManager(ProcessorManager processorManager) {
        this.processorManager = processorManager;
    }

    @Override
    public void registerModifiedTime(Tables tables, long lastModifiedTime) {
        for (Table table : tables.getTableList()) {
            this.tableModifiedTimeMap.put(table.getId(), lastModifiedTime);
        }
    }

    @Override
    public long getLastModifiedTime(String tableId) {
        return this.tableModifiedTimeMap.get(tableId);
    }

    @Override
    public void addTables(Tables tables) {
        String packageName = MetadataUtil.passNull((String)tables.getPackageName());
        if (!this.tableMap.containsKey(packageName)) {
            this.tableMap.put(packageName, new HashMap());
        }
        for (Table table : tables.getTableList()) {
            this.addTable(table);
        }
    }

    @Override
    public void removeTables(Tables tables) {
        String packageName = MetadataUtil.passNull((String)tables.getPackageName());
        Map<String, Table> nameMap = this.tableMap.get(packageName);
        if (!CollectionUtil.isEmpty(nameMap)) {
            for (Table table : tables.getTableList()) {
                this.removeTable(table);
            }
        }
    }

    @Override
    public void addTable(Table table) {
        String packageName = MetadataUtil.passNull((String)table.getPackageName());
        if (!this.tableMap.containsKey(packageName)) {
            this.tableMap.put(packageName, new HashMap());
        }
        Map<String, Table> nameMap = this.tableMap.get(packageName);
        nameMap.put(table.getName(), table);
        if (this.idMap.containsKey(table.getId())) {
            throw new DatabaseRuntimeException("0TE120055001", table.getId());
        }
        this.idMap.put(table.getId(), table);
    }

    @Override
    public void removeTable(Table table) {
        String packageName = MetadataUtil.passNull((String)table.getPackageName());
        Map<String, Table> nameMap = this.tableMap.get(packageName);
        if (!CollectionUtil.isEmpty(nameMap)) {
            nameMap.remove(table.getName());
        }
        this.idMap.remove(table.getId());
    }

    @Override
    public Table getTable(String packageName, String name) {
        Table table;
        Map<String, Table> packageMap;
        if (packageName != null && (packageMap = this.tableMap.get(packageName)) != null && (table = packageMap.get(name)) != null) {
            return table;
        }
        for (String pkgName : this.tableMap.keySet()) {
            Table table2;
            Map<String, Table> packageMap2 = this.tableMap.get(pkgName);
            if (packageMap2 == null || (table2 = packageMap2.get(name)) == null) continue;
            return table2;
        }
        throw new RuntimeException("\u672a\u627e\u5230package:" + packageName + ",name:" + name + "\u7684\u8868\u683c");
    }

    @Override
    public Table getTable(String name) {
        return this.getTable(null, name);
    }

    @Override
    public List<String> getCreateSql(String name, String language) {
        return this.getCreateSql(name, null, language);
    }

    @Override
    public List<String> getCreateSql(String name, String packageName, String language) {
        Table table = this.getTable(packageName, name);
        return this.getCreateSql(table, language);
    }

    @Override
    public List<String> getCreateSql(Table table, String packageName, String language) {
        table.setPackageName(packageName);
        return this.getCreateSql(table, language);
    }

    @Override
    public List<String> getCreateSql(Table table, String language) {
        TableSqlProcessor sqlProcessor = this.getSqlProcessor(language);
        return sqlProcessor.getCreateSql(table, table.getPackageName());
    }

    @Override
    public Table getTableById(String id) {
        return this.idMap.get(id);
    }

    @Override
    public List<Table> getTables() {
        if (!CollectionUtil.isEmpty(this.orderTables)) {
            return this.orderTables;
        }
        for (Table table : this.idMap.values()) {
            this.addOrderTable(table);
        }
        return this.orderTables;
    }

    @Override
    public List<Table> getSortedTables(List<Table> tableList) {
        ArrayList<Table> result = new ArrayList<Table>();
        if (!CollectionUtil.isEmpty(tableList)) {
            for (Table table : tableList) {
                this.sortTable(table, result);
            }
        }
        return result;
    }

    private void sortTable(Table table, List<Table> sortTableList) {
        List<ForeignReference> references = table.getForeignReferences();
        for (ForeignReference foreignReference : references) {
            Table foreignTable = this.idMap.get(foreignReference.getMainTable());
            if (((Object)((Object)foreignTable)).equals((Object)table)) continue;
            this.sortTable(foreignTable, sortTableList);
        }
        if (!sortTableList.contains((Object)table)) {
            sortTableList.add(table);
        }
    }

    private void addOrderTable(Table table) {
        List<ForeignReference> references = table.getForeignReferences();
        for (ForeignReference foreignReference : references) {
            Table foreignTable = this.idMap.get(foreignReference.getMainTable());
            if (((Object)((Object)foreignTable)).equals((Object)table)) continue;
            this.addOrderTable(foreignTable);
        }
        Boolean inited = this.tableInited.get(table.getId());
        if (inited == null || inited.equals(Boolean.FALSE)) {
            this.orderTables.add(table);
            this.tableInited.put(table.getId(), true);
        }
    }

    @Override
    public List<String> getUpdateSql(String name, String packageName, String language, Connection connection) throws SQLException {
        Table table = this.getTable(packageName, name);
        return this.getUpdateSql(table, packageName, language, connection);
    }

    @Override
    public List<String> getUpdateSql(Table table, String packageName, String language, Connection connection) throws SQLException {
        TableSqlProcessor sqlProcessor = this.getSqlProcessor(language);
        return sqlProcessor.getUpdateSql(table, packageName, connection);
    }

    @Override
    public String getDropSql(String name, String packageName, String language) {
        Table table = this.getTable(packageName, name);
        return this.getDropSql(table, packageName, language);
    }

    @Override
    public String getDropSql(Table table, String packageName, String language) {
        TableSqlProcessor sqlProcessor = this.getSqlProcessor(language);
        return sqlProcessor.getDropSql(table, packageName);
    }

    @Override
    public boolean checkTableExist(Table table, String language, Connection connection) throws SQLException {
        TableSqlProcessor sqlProcessor = this.getSqlProcessor(language);
        return sqlProcessor.checkTableExist(table, connection);
    }

    private TableSqlProcessor getSqlProcessor(String language) {
        TableSqlProcessor sqlProcessor = (TableSqlProcessor)this.processorManager.getProcessor(language, "table");
        return sqlProcessor;
    }

    @Override
    public List<String> getCreateSqls(String language) {
        ArrayList<String> sqls = new ArrayList<String>();
        List<Table> tables = this.getTables();
        for (Table table : tables) {
            sqls.addAll(this.getCreateSql(table, language));
        }
        return sqls;
    }

    @Override
    public List<String> clearRefSqls(Table table, String language, Connection connection) throws SQLException {
        TableSqlProcessor sqlProcessor = this.getSqlProcessor(language);
        return sqlProcessor.getClearTableSql(table, connection);
    }
}

