/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.database.tablespace.impl;

import java.util.HashMap;
import java.util.Map;
import org.tinygroup.commons.tools.CollectionUtil;
import org.tinygroup.database.ProcessorManager;
import org.tinygroup.database.config.tablespace.TableSpace;
import org.tinygroup.database.config.tablespace.TableSpaces;
import org.tinygroup.database.exception.DatabaseRuntimeException;
import org.tinygroup.database.tablespace.TableSpaceProcessor;

public class TableSpaceProcessorImpl
implements TableSpaceProcessor {
    private static TableSpaceProcessor tableSpaceProcessor = new TableSpaceProcessorImpl();
    private ProcessorManager processorManager;
    private Map<String, TableSpace> nameMap = new HashMap<String, TableSpace>();
    private Map<String, TableSpace> idMap = new HashMap<String, TableSpace>();

    public static TableSpaceProcessor getTableSpaceProcessor() {
        return tableSpaceProcessor;
    }

    public ProcessorManager getProcessorManager() {
        return this.processorManager;
    }

    public void setProcessorManager(ProcessorManager processorManager) {
        this.processorManager = processorManager;
    }

    @Override
    public void addTableSpaces(TableSpaces tableSpaces) {
        for (TableSpace tableSpace : tableSpaces.getTableSpaces()) {
            this.addTableSpace(tableSpace);
        }
    }

    @Override
    public void addTableSpace(TableSpace tableSpace) {
        this.nameMap.put(tableSpace.getName(), tableSpace);
        if (this.idMap.containsKey(tableSpace.getId())) {
            throw new DatabaseRuntimeException("0TE120055003", tableSpace.getId());
        }
        this.idMap.put(tableSpace.getId(), tableSpace);
    }

    @Override
    public TableSpace getTableSpace(String tableSpaceId) {
        if (this.idMap.containsKey(tableSpaceId)) {
            return this.idMap.get(tableSpaceId);
        }
        throw new RuntimeException(String.format("\u627e\u4e0d\u5230ID\uff1a[%s]\u7684\u8868\u7a7a\u95f4\u3002", tableSpaceId));
    }

    @Override
    public void removeTableSpaces(TableSpaces tableSpaces) {
        if (!CollectionUtil.isEmpty(this.nameMap)) {
            for (TableSpace tableSpace : tableSpaces.getTableSpaces()) {
                this.removeTableSpace(tableSpace);
            }
        }
    }

    public void removeTableSpace(TableSpace tableSpace) {
        if (!CollectionUtil.isEmpty(this.nameMap)) {
            this.nameMap.remove(tableSpace.getName());
        }
        this.idMap.remove(tableSpace.getId());
    }
}

