/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.database.trigger.impl;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.tinygroup.database.ProcessorManager;
import org.tinygroup.database.config.SqlBody;
import org.tinygroup.database.config.trigger.Trigger;
import org.tinygroup.database.config.trigger.Triggers;
import org.tinygroup.database.trigger.TriggerProcessor;
import org.tinygroup.database.trigger.TriggerSqlProcessor;

public class TriggerProcessorImpl
implements TriggerProcessor {
    private static TriggerProcessor triggerProcessor = new TriggerProcessorImpl();
    private Map<String, Trigger> triggerMap = new HashMap<String, Trigger>();
    private ProcessorManager processorManager;

    public static TriggerProcessor getTriggerProcessor() {
        return triggerProcessor;
    }

    @Override
    public ProcessorManager getProcessorManager() {
        return this.processorManager;
    }

    @Override
    public void setProcessorManager(ProcessorManager processorManager) {
        this.processorManager = processorManager;
    }

    @Override
    public void addTriggers(Triggers triggers) {
        for (Trigger trigger : triggers.getTriggers()) {
            this.triggerMap.put(trigger.getName(), trigger);
        }
    }

    @Override
    public void removeTriggers(Triggers triggers) {
        for (Trigger trigger : triggers.getTriggers()) {
            this.triggerMap.remove(trigger.getName());
        }
    }

    @Override
    public Trigger getTrigger(String triggerName) {
        return this.triggerMap.get(triggerName);
    }

    @Override
    public String getCreateSql(String triggerName, String language) {
        Trigger trigger = this.getTrigger(triggerName);
        if (trigger == null) {
            throw new RuntimeException(String.format("trigger[name:%s]\u4e0d\u5b58\u5728,", triggerName));
        }
        return this.getCreateSql(trigger, language);
    }

    private String getCreateSql(Trigger trigger, String language) {
        List<SqlBody> sqls = trigger.getTriggerSqls();
        for (SqlBody sqlBody : sqls) {
            if (!sqlBody.getDialectTypeName().equals(language)) continue;
            String sql = sqlBody.getContent();
            if (!sql.endsWith(";")) {
                sql = sql + ";";
            }
            return sql;
        }
        throw new RuntimeException(String.format("[language:%s]\u5bf9\u5e94\u7684trigger\u4e0d\u5b58\u5728,", language));
    }

    @Override
    public String getDropSql(String triggerName, String language) {
        Trigger trigger = this.getTrigger(triggerName);
        if (trigger == null) {
            throw new RuntimeException(String.format("trigger[name:%s]\u4e0d\u5b58\u5728,", triggerName));
        }
        return this.getDropSql(trigger, language);
    }

    private String getDropSql(Trigger trigger, String language) {
        return "DROP TRIGGER " + trigger.getName();
    }

    @Override
    public List<String> getCreateSql(String language) {
        ArrayList<String> sqls = new ArrayList<String>();
        for (Trigger trigger : this.triggerMap.values()) {
            sqls.add(this.getCreateSql(trigger, language));
        }
        return sqls;
    }

    @Override
    public List<String> getDropSql(String language) {
        ArrayList<String> sqls = new ArrayList<String>();
        for (Trigger trigger : this.triggerMap.values()) {
            sqls.add(this.getDropSql(trigger, language));
        }
        return sqls;
    }

    @Override
    public List<Trigger> getTriggers(String language) {
        ArrayList<Trigger> triggers = new ArrayList<Trigger>();
        triggers.addAll(this.triggerMap.values());
        return triggers;
    }

    @Override
    public boolean checkTriggerExist(String language, Trigger trigger, Connection connection) throws SQLException {
        TriggerSqlProcessor sqlProcessor = (TriggerSqlProcessor)this.processorManager.getProcessor(language, "trigger");
        return sqlProcessor.checkSequenceExist(trigger, connection);
    }
}

