/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.database.util;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.tinygroup.beancontainer.BeanContainerFactory;
import org.tinygroup.commons.namestrategy.NameStrategy;
import org.tinygroup.commons.namestrategy.impl.NormalCaseStrategy;
import org.tinygroup.database.config.table.Table;
import org.tinygroup.database.config.table.TableField;
import org.tinygroup.database.config.tablespace.TableSpace;
import org.tinygroup.database.config.view.View;
import org.tinygroup.database.table.TableProcessor;
import org.tinygroup.database.table.impl.TableProcessorImpl;
import org.tinygroup.database.tablespace.TableSpaceProcessor;
import org.tinygroup.database.tablespace.impl.TableSpaceProcessorImpl;
import org.tinygroup.database.view.ViewProcessor;
import org.tinygroup.metadata.config.stdfield.StandardField;
import org.tinygroup.metadata.util.ConfigUtil;
import org.tinygroup.metadata.util.MetadataUtil;

public class DataBaseUtil {
    public static final String DB_TYPE_ORACLE = "oracle";
    public static final String DB_TYPE_DB2 = "db2";
    public static final String DB_TYPE_MYSQL = "mysql";
    public static final String DB_TYPE_SQLSERVER = "sqlserver";
    public static final String DB_TYPE_INFORMIX = "informix";
    public static final String DB_TYPE_SYBASE = "sybase";
    public static final String DB_TYPE_DERBY = "derby";
    public static String DATABASE_XSTREAM = "database";
    public static String INITDATA_XSTREAM = "initdata";
    public static String PROCESSOR_XSTREAM = "processor";
    public static String PROCESSORMANAGER_BEAN = "processorManager";
    public static String TABLEPROCESSOR_BEAN = "tableProcessor";
    public static String CUSTOMESQL_BEAN = "customSqlProcessor";
    public static String FUNCTION_BEAN = "dialectFunctionProcessor";
    public static String INITDATA_BEAN = "initDataProcessor";
    public static String PROCEDURE_BEAN = "procedureProcessor";
    public static String VIEW_BEAN = "viewProcessor";
    public static String TRIGGER_BEAN = "triggerProcessor";
    public static String SEQUENCE_BEAN = "sequenceProcessor";
    public static String TABLE_SPACE_PROCESSOR_BEAN = "tableSpaceProcessor";
    public static ThreadLocal<String> fromSourceLocal = new ThreadLocal();

    public static StandardField getStandardField(String tableFieldId, Table table, ClassLoader loader) {
        for (TableField field : table.getFieldList()) {
            if (!field.getId().equals(tableFieldId)) continue;
            return MetadataUtil.getStandardField((String)field.getStandardFieldId(), (ClassLoader)loader);
        }
        return null;
    }

    public static Table getTableById(String id, ClassLoader loader) {
        return DataBaseUtil.getTableProcessor(loader).getTableById(id);
    }

    public static List<Table> getTables(ClassLoader loader) {
        return DataBaseUtil.getTableProcessor(loader).getTables();
    }

    private static TableProcessor getTableProcessor(ClassLoader loader) {
        try {
            return (TableProcessor)BeanContainerFactory.getBeanContainer((ClassLoader)loader).getBean(TABLEPROCESSOR_BEAN);
        }
        catch (Exception exception) {
            return TableProcessorImpl.getTableProcessor();
        }
    }

    private static TableSpaceProcessor getTableSpaceProcessor(ClassLoader loader) {
        try {
            return (TableSpaceProcessor)BeanContainerFactory.getBeanContainer((ClassLoader)loader).getBean(TABLE_SPACE_PROCESSOR_BEAN);
        }
        catch (Exception exception) {
            return TableSpaceProcessorImpl.getTableSpaceProcessor();
        }
    }

    public static TableSpace getTableSpace(ClassLoader loader, String spaceId) {
        TableSpaceProcessor tableSpaceProcessor = DataBaseUtil.getTableSpaceProcessor(loader);
        return tableSpaceProcessor.getTableSpace(spaceId);
    }

    public static View getViewById(String id, ClassLoader loader) {
        ViewProcessor viewProcessor = (ViewProcessor)BeanContainerFactory.getBeanContainer((ClassLoader)loader).getBean(VIEW_BEAN);
        return viewProcessor.getViewById(id);
    }

    public static TableField getPrimaryField(Table table) {
        for (TableField field : table.getFieldList()) {
            if (!field.getPrimary()) continue;
            return field;
        }
        throw new RuntimeException("\u8868\u683c" + table.getName() + "\u4e3b\u952e\u4e0d\u5b58\u5728");
    }

    public static NameStrategy getNameStrategy() {
        return new NormalCaseStrategy();
    }

    public static String getDataBaseName(String name) {
        return DataBaseUtil.getNameStrategy().getFieldName(name);
    }

    public static String getSchema(Table table, DatabaseMetaData metadata) throws SQLException {
        String schema = table.getSchema();
        if (schema == null || "".equals(schema)) {
            schema = metadata.getUserName();
        }
        return schema;
    }

    public static void closeResultSet(ResultSet r) {
        if (r != null) {
            try {
                r.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public static boolean isNeedCache() {
        String from = fromSourceLocal.get();
        return "processor".equals(from) && ConfigUtil.isCheckModified();
    }
}

