/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.database.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.Properties;

public class DatabaseTmpProUtil {
    protected static final String TEMP_DIR = System.getProperty("user.home");
    protected static final String USER_DIR = new File(System.getProperty("user.dir")).getName();

    public static void saveTmpFileProperties(File proFile, Properties tmpFileProperties, Properties newProperties, String title) {
        if (newProperties == null || newProperties.size() == 0) {
            return;
        }
        tmpFileProperties.putAll((Map<?, ?>)newProperties);
        FileOutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(proFile);
            tmpFileProperties.store(outputStream, title);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                ((OutputStream)outputStream).close();
            }
            catch (IOException iOException) {}
        }
    }

    public static Properties loadFileProperties(File proFile) {
        Properties fileProperties = new Properties();
        if (!proFile.exists()) {
            try {
                proFile.createNewFile();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(proFile);
            fileProperties.load(inputStream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (inputStream != null) {
                try {
                    ((InputStream)inputStream).close();
                }
                catch (IOException iOException) {}
            }
        }
        return fileProperties;
    }
}

