/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.database.view.impl;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.tinygroup.database.config.view.View;
import org.tinygroup.database.view.impl.ViewSqlProcessorImpl;

public class H2ViewSqlProcessorImpl
extends ViewSqlProcessorImpl {
    @Override
    protected String getDatabaseType() {
        return "h2";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean checkViewExists(View view, Connection conn) throws SQLException {
        boolean checkResult = false;
        String checkSql = this.buildCheckViewSql(view);
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = conn.prepareStatement(checkSql);
            preparedStatement.setString(1, view.getName());
            resultSet.next();
            long count = resultSet.getLong(1);
            checkResult = count > 0L;
        }
        finally {
            if (null != resultSet) {
                resultSet.close();
            }
            if (null != preparedStatement) {
                preparedStatement.close();
            }
        }
        return checkResult;
    }

    private String buildCheckViewSql(View view) {
        StringBuffer checkSql = new StringBuffer();
        checkSql.append("SELECT count(0) from information_schema.views where table_name=upper(?)");
        return checkSql.toString();
    }
}

