/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.database.view.impl;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.tinygroup.database.ProcessorManager;
import org.tinygroup.database.config.view.RefViewIds;
import org.tinygroup.database.config.view.View;
import org.tinygroup.database.config.view.Views;
import org.tinygroup.database.exception.DatabaseRuntimeException;
import org.tinygroup.database.view.ViewProcessor;
import org.tinygroup.database.view.ViewSqlProcessor;
import org.tinygroup.database.view.impl.ViewSort;

public class ViewProcessorImpl
implements ViewProcessor {
    private static ViewProcessor viewProcessor = new ViewProcessorImpl();
    private Map<String, View> viewMap = new HashMap<String, View>();
    private Map<String, View> viewIdMap = new HashMap<String, View>();
    private ProcessorManager processorManager;
    private Map<String, Long> viewModifiedTimeMap = new HashMap<String, Long>();
    private Map<String, List<String>> dependencyMap = new HashMap<String, List<String>>();

    public static ViewProcessor getViewProcessor() {
        return viewProcessor;
    }

    @Override
    public ProcessorManager getProcessorManager() {
        return this.processorManager;
    }

    @Override
    public void setProcessorManager(ProcessorManager processorManager) {
        this.processorManager = processorManager;
    }

    @Override
    public void registerModifiedTime(Views views, long lastModify) {
        for (View view : views.getViewTableList()) {
            this.viewModifiedTimeMap.put(view.getId(), lastModify);
        }
    }

    @Override
    public long getLastModifiedTime(String viewId) {
        return this.viewModifiedTimeMap.get(viewId);
    }

    @Override
    public void addViews(Views views) {
        for (View view : views.getViewTableList()) {
            if (this.viewIdMap.containsKey(view.getId())) {
                throw new DatabaseRuntimeException("0TE120055002", view.getId());
            }
            this.viewMap.put(view.getName(), view);
            this.viewIdMap.put(view.getId(), view);
        }
    }

    @Override
    public void removeViews(Views views) {
        for (View view : views.getViewTableList()) {
            this.viewMap.remove(view.getName());
            this.viewIdMap.remove(view.getId());
        }
    }

    @Override
    public View getView(String name) {
        if (!this.viewMap.containsKey(name)) {
            throw new RuntimeException(String.format("\u89c6\u56fe[name:%s]\u4e0d\u5b58\u5728,", name));
        }
        return this.viewMap.get(name);
    }

    @Override
    public String getCreateSql(String name, String language) {
        View view = this.getView(name);
        return this.getCreateSql(view, language);
    }

    @Override
    public String getCreateSql(View view, String language) {
        ViewSqlProcessor sqlProcessor = (ViewSqlProcessor)this.processorManager.getProcessor(language, "view");
        return sqlProcessor.getCreateSql(view);
    }

    @Override
    public List<String> getCreateSql(String language) {
        ArrayList<String> list = new ArrayList<String>();
        List<View> views = this.getViews();
        for (View view : views) {
            list.add(this.getCreateSql(view, language));
        }
        return list;
    }

    @Override
    public String getDropSql(String name, String language) {
        View view = this.getView(name);
        return this.getDropSql(view, language);
    }

    @Override
    public String getDropSql(View view, String language) {
        ViewSqlProcessor sqlProcessor = (ViewSqlProcessor)this.processorManager.getProcessor(language, "view");
        return sqlProcessor.getDropSql(view);
    }

    @Override
    public List<String> getDropSql(String language) {
        ArrayList<String> list = new ArrayList<String>();
        for (View view : this.viewMap.values()) {
            list.add(this.getDropSql(view, language));
        }
        return list;
    }

    @Override
    public List<View> getViews() {
        ArrayList<View> list = new ArrayList<View>();
        list.addAll(this.viewMap.values());
        Collections.sort(list, new ViewSort(this.dependencyMap));
        return list;
    }

    @Override
    public View getViewById(String id) {
        if (!this.viewIdMap.containsKey(id)) {
            throw new RuntimeException(String.format("\u89c6\u56fe[id:%s]\u4e0d\u5b58\u5728,", id));
        }
        return this.viewIdMap.get(id);
    }

    @Override
    public void dependencyInit() {
        for (View view : this.viewIdMap.values()) {
            RefViewIds refViews;
            List<String> dependencies = this.dependencyMap.get(view.getId());
            if (dependencies == null) {
                dependencies = new ArrayList<String>();
                this.dependencyMap.put(view.getId(), dependencies);
            }
            if ((refViews = view.getRefViewIds()) == null || refViews.getRefViewIdList() == null || refViews.getRefViewIdList().size() == 0) continue;
            for (String refViewId : refViews.getRefViewIdList()) {
                View dependView = this.viewIdMap.get(refViewId);
                if (dependView == null) {
                    throw new RuntimeException(String.format("\u89c6\u56fe[id:%s]\u4f9d\u8d56\u7684\u89c6\u56fe[id:%s]\u4e0d\u5b58\u5728,", view.getId(), refViewId));
                }
                if (dependencies.contains(dependView.getId())) continue;
                dependencies.add(dependView.getId());
            }
        }
    }

    @Override
    public boolean checkViewExists(View view, Connection conn, String language) throws SQLException {
        ViewSqlProcessor sqlProcessor = (ViewSqlProcessor)this.processorManager.getProcessor(language, "view");
        return sqlProcessor.checkViewExists(view, conn);
    }
}

