/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.database.view.impl;

import java.util.List;
import org.tinygroup.database.config.SqlBody;
import org.tinygroup.database.config.view.View;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;

public class ViewSqlCreator {
    protected View view;
    protected Logger logger = LoggerFactory.getLogger(ViewSqlCreator.class);

    public ViewSqlCreator(View view) {
        this.view = view;
    }

    public String getCreateSql(String language) {
        StringBuffer buffer = new StringBuffer();
        List<SqlBody> sqlBodyList = this.view.getSqlBodyList();
        String defaultSql = "";
        String dialectSql = null;
        for (SqlBody sqlBody : sqlBodyList) {
            if ("default".equals(sqlBody.getDialectTypeName())) {
                defaultSql = sqlBody.getContent();
                continue;
            }
            if (!sqlBody.getDialectTypeName().equalsIgnoreCase(language)) continue;
            dialectSql = sqlBody.getContent();
        }
        if (dialectSql != null) {
            buffer.append(dialectSql);
        } else {
            buffer.append(defaultSql);
        }
        this.logger.logMessage(LogLevel.DEBUG, "\u65b0\u5efa\u89c6\u56fesql:{1}", new Object[]{buffer.toString()});
        return buffer.toString();
    }

    public String getDropSql() {
        return String.format("DROP VIEW %s", this.view.getName());
    }

    protected String getLanguage() {
        return null;
    }
}

