/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.flowbasiccomponent;

import org.tinygroup.beancontainer.BeanContainerFactory;
import org.tinygroup.commons.tools.StringUtil;
import org.tinygroup.context.Context;
import org.tinygroup.context2object.impl.ClassNameObjectGenerator;
import org.tinygroup.flow.ComponentInterface;
import org.tinygroup.loader.LoaderManager;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;

public class Context2Object
implements ComponentInterface {
    private static Logger logger = LoggerFactory.getLogger(Context2Object.class);
    private String className;
    private String collectionClassName;
    private boolean isArray = false;
    private String resultKey;
    private String varName;
    private String beanName;
    private static String DEFAULT_KEY = "context2Object_result";

    public boolean isArray() {
        return this.isArray;
    }

    public void setArray(boolean isArray) {
        this.isArray = isArray;
    }

    public String getBeanName() {
        return this.beanName;
    }

    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    public String getCollectionClassName() {
        return this.collectionClassName;
    }

    public void setCollectionClassName(String collectionClassName) {
        this.collectionClassName = collectionClassName;
    }

    public String getVarName() {
        return this.varName;
    }

    public void setVarName(String varName) {
        this.varName = varName;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getResultKey() {
        return this.resultKey;
    }

    public void setResultKey(String resultKey) {
        this.resultKey = resultKey;
    }

    public void execute(Context context) {
        ClassLoader loader;
        ClassNameObjectGenerator generator = (ClassNameObjectGenerator)BeanContainerFactory.getBeanContainer((ClassLoader)this.getClass().getClassLoader()).getBean("classNameObjectGenerator");
        try {
            loader = LoaderManager.getLoader((String)this.className);
        }
        catch (ClassNotFoundException e1) {
            logger.errorMessage("\u7c7b" + this.className + "\u6ca1\u627e\u5230", (Throwable)e1);
            throw new RuntimeException(e1);
        }
        if (this.isNull(this.resultKey)) {
            this.resultKey = this.varName;
        }
        if (this.isNull(this.resultKey)) {
            try {
                this.resultKey = loader.loadClass(this.className).getSimpleName().toLowerCase();
            }
            catch (ClassNotFoundException e) {
                logger.logMessage(LogLevel.WARN, e.getMessage());
            }
            if (this.isNull(this.resultKey)) {
                this.resultKey = DEFAULT_KEY;
            }
        }
        if (this.collectionClassName == null || "".equals(this.collectionClassName)) {
            context.put(this.resultKey, generator.getObject(this.varName, this.beanName, this.className, loader, context));
        } else if (this.isArray) {
            context.put(this.resultKey, generator.getObjectArray(this.varName, this.className, loader, context));
        } else {
            context.put(this.resultKey, (Object)generator.getObjectCollection(this.varName, this.collectionClassName, this.className, loader, context));
        }
    }

    private boolean isNull(String str) {
        return StringUtil.isBlank((String)str);
    }
}

