/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.flowprocessor;

import java.util.ArrayList;
import java.util.List;
import org.tinygroup.cepcore.CEPCore;
import org.tinygroup.cepcore.impl.AbstractEventProcessor;
import org.tinygroup.event.Event;
import org.tinygroup.event.ServiceInfo;
import org.tinygroup.flow.FlowExecutor;
import org.tinygroup.flow.config.Flow;
import org.tinygroup.flowprocessor.FlowServiceInfo;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlowEventProcessor
extends AbstractEventProcessor {
    private FlowExecutor executor;
    private static final Logger LOGGER = LoggerFactory.getLogger(FlowEventProcessor.class);

    public void process(Event event) {
        String serviceId;
        Flow flow = null;
        String nodeId = null;
        String flowId = serviceId = event.getServiceRequest().getServiceId();
        String[] str = serviceId.split(":");
        if (str.length > 1) {
            nodeId = str[str.length - 1];
            flowId = serviceId.substring(0, serviceId.length() - nodeId.length() - 1);
        }
        if ((flow = this.executor.getFlow(flowId)) == null) {
            LOGGER.logMessage(LogLevel.ERROR, "[Flow:{0}]\u4e0d\u5b58\u5728\u6216\u65e0\u5408\u9002\u7684Flow\u6d41\u7a0b\u6267\u884c\u5668", new Object[]{flowId});
            throw new RuntimeException("[Flow:" + flowId + "]\u4e0d\u5b58\u5728\u6216\u65e0\u5408\u9002\u7684Flow\u6d41\u7a0b\u6267\u884c\u5668");
        }
        this.executor.execute(flowId, nodeId, event.getServiceRequest().getContext());
    }

    public void setCepCore(CEPCore cepCore) {
    }

    public void setExecutor(FlowExecutor executor) {
        this.executor = executor;
    }

    public List<ServiceInfo> getServiceInfos() {
        ArrayList<ServiceInfo> list = new ArrayList<ServiceInfo>();
        for (Flow f : this.executor.getFlowIdMap().values()) {
            list.add(new FlowServiceInfo(f));
        }
        return list;
    }

    public int getWeight() {
        return 0;
    }

    public List<String> getRegex() {
        return null;
    }

    public boolean isRead() {
        return !this.executor.isChange();
    }

    public void setRead(boolean read) {
        this.executor.setChange(!read);
    }
}

