/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.menucommand;

import junit.framework.TestCase;
import org.tinygroup.beancontainer.BeanContainerFactory;
import org.tinygroup.context.Context;
import org.tinygroup.context.impl.ContextImpl;
import org.tinygroup.menucommand.CommandExecutor;
import org.tinygroup.menucommand.CommandResult;
import org.tinygroup.menucommand.MenuConfigManager;
import org.tinygroup.menucommand.config.MenuConfig;
import org.tinygroup.menucommand.config.SystemCommand;
import org.tinygroup.tinytestutil.AbstractTestUtil;

public class MenuConfigTest
extends TestCase {
    private MenuConfigManager menuConfigManager;

    protected void setUp() throws Exception {
        AbstractTestUtil.init(null, (boolean)false);
        this.menuConfigManager = (MenuConfigManager)BeanContainerFactory.getBeanContainer((ClassLoader)((Object)((Object)this)).getClass().getClassLoader()).getBean("menuConfigManager");
    }

    public void testMenuConfigManager() {
        MenuConfigTest.assertNotNull((Object)this.menuConfigManager);
        MenuConfig config = this.menuConfigManager.getMenuConfig("m001");
        MenuConfigTest.assertNotNull((Object)config);
        MenuConfigTest.assertEquals((String)"\u670d\u52a1\u83dc\u5355", (String)config.getName());
        MenuConfigTest.assertEquals((boolean)true, (boolean)config.match("menu"));
        MenuConfigTest.assertEquals((boolean)true, (boolean)config.match("\u83dc\u5355"));
        MenuConfig gameConfig = this.menuConfigManager.getMenuConfig("m012");
        MenuConfigTest.assertEquals((Object)gameConfig.getParent(), (Object)config);
        MenuConfigTest.assertEquals((boolean)true, (boolean)gameConfig.match("g"));
        MenuConfigTest.assertEquals((boolean)true, (boolean)gameConfig.match("game"));
        MenuConfigTest.assertEquals((boolean)false, (boolean)gameConfig.match("GAME"));
        MenuConfigTest.assertNotNull((Object)gameConfig.getMatchMenuConfig("buy"));
        SystemCommand systemCommand = this.menuConfigManager.getSystemCommand("back");
        MenuConfigTest.assertNotNull((Object)systemCommand);
        MenuConfigTest.assertEquals((String)"\u8fd4\u56de\u4e0a\u4e00\u7ea7", (String)systemCommand.getName());
        MenuConfig guessNumberConfig = this.menuConfigManager.getMenuConfig("g001");
        MenuConfigTest.assertEquals((String)"\u670d\u52a1\u83dc\u5355/\u6e38\u620f/\u731c\u6570\u5b57", (String)guessNumberConfig.getMenuConfigPath());
        MenuConfigTest.assertNull((Object)guessNumberConfig.getMatchMenuCommand("abc"));
        MenuConfigTest.assertNotNull((Object)guessNumberConfig.getMatchMenuCommand("new"));
        MenuConfigTest.assertNotNull((Object)guessNumberConfig.getMatchMenuCommand("100"));
    }

    public void testMenuCommand() {
        ContextImpl context = new ContextImpl();
        CommandExecutor executor = null;
        CommandResult result = null;
        executor = this.menuConfigManager.getCommandExecutor(null, "m", (Context)context);
        result = executor.execute((Context)context);
        MenuConfigTest.assertNotNull((Object)result);
        MenuConfigTest.assertEquals((String)"m001", (String)result.getMenuId());
        executor = this.menuConfigManager.getCommandExecutor("m001", "\u5947\u602a\u6307\u4ee4", (Context)context);
        result = executor.execute((Context)context);
        MenuConfigTest.assertNotNull((Object)result);
        MenuConfigTest.assertEquals((String)"m001", (String)result.getMenuId());
        executor = this.menuConfigManager.getCommandExecutor("m001", "game", (Context)context);
        result = executor.execute((Context)context);
        MenuConfigTest.assertNotNull((Object)result);
        MenuConfigTest.assertEquals((String)"m012", (String)result.getMenuId());
        executor = this.menuConfigManager.getCommandExecutor("m012", "guess", (Context)context);
        result = executor.execute((Context)context);
        MenuConfigTest.assertNotNull((Object)result);
        MenuConfigTest.assertEquals((String)"g001", (String)result.getMenuId());
        executor = this.menuConfigManager.getCommandExecutor("g001", "back", (Context)context);
        result = executor.execute((Context)context);
        MenuConfigTest.assertNotNull((Object)result);
        MenuConfigTest.assertEquals((String)"m012", (String)result.getMenuId());
        executor = this.menuConfigManager.getCommandExecutor("g001", "home", (Context)context);
        result = executor.execute((Context)context);
        MenuConfigTest.assertNotNull((Object)result);
        MenuConfigTest.assertEquals((String)"m001", (String)result.getMenuId());
        executor = this.menuConfigManager.getCommandExecutor("g001", "exit", (Context)context);
        result = executor.execute((Context)context);
        MenuConfigTest.assertNotNull((Object)result);
        MenuConfigTest.assertNull((Object)result.getMenuId());
        executor = this.menuConfigManager.getCommandExecutor("m023", "query \u533a", (Context)context);
        result = executor.execute((Context)context);
        MenuConfigTest.assertNotNull((Object)result);
    }

    public void testShowTime() {
        ContextImpl context = new ContextImpl();
        CommandExecutor executor = null;
        CommandResult result = null;
        executor = this.menuConfigManager.getCommandExecutor("g003", "1", (Context)context);
        result = executor.execute((Context)context);
        MenuConfigTest.assertNotNull((Object)result);
        executor = this.menuConfigManager.getCommandExecutor("g003", "2", (Context)context);
        result = executor.execute((Context)context);
        MenuConfigTest.assertNotNull((Object)result);
    }

    public void testGuessNumber() {
        ContextImpl context = new ContextImpl();
        CommandExecutor executor = null;
        CommandResult result = null;
        context.put("userId", (Object)"user123");
        executor = this.menuConfigManager.getCommandExecutor("g001", "new", (Context)context);
        result = executor.execute((Context)context);
        MenuConfigTest.assertNotNull((Object)result);
        executor = this.menuConfigManager.getCommandExecutor("g001", "2000", (Context)context);
        result = executor.execute((Context)context);
        MenuConfigTest.assertNotNull((Object)result);
        executor = this.menuConfigManager.getCommandExecutor("g001", "50", (Context)context);
        result = executor.execute((Context)context);
        MenuConfigTest.assertNotNull((Object)result);
        executor = this.menuConfigManager.getCommandExecutor("g001", "1", (Context)context);
        result = executor.execute((Context)context);
        MenuConfigTest.assertNotNull((Object)result);
        executor = this.menuConfigManager.getCommandExecutor("g001", "100", (Context)context);
        result = executor.execute((Context)context);
        MenuConfigTest.assertNotNull((Object)result);
        executor = this.menuConfigManager.getCommandExecutor("g001", "delete", (Context)context);
        result = executor.execute((Context)context);
        MenuConfigTest.assertNotNull((Object)result);
    }
}

