/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.menucommand.config;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import org.tinygroup.beancontainer.BeanContainerFactory;
import org.tinygroup.commons.tools.StringUtil;
import org.tinygroup.menucommand.config.BaseObject;
import org.tinygroup.menucommand.exception.MenuCommandException;

public class BaseCommand
extends BaseObject {
    @XStreamAlias(value="bean-name")
    @XStreamAsAttribute
    private String beanName;
    @XStreamAlias(value="class-name")
    @XStreamAsAttribute
    private String className;

    public String getBeanName() {
        return this.beanName;
    }

    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public <T> T createCommandObject() {
        if (!StringUtil.isEmpty((String)this.getBeanName())) {
            try {
                return (T)BeanContainerFactory.getBeanContainer((ClassLoader)this.getClass().getClassLoader()).getBean(this.getBeanName());
            }
            catch (Exception e) {
                throw new MenuCommandException(String.format("bean\u540d\u79f0\u4e3a[%s],\u5b9e\u4f8b\u5316bean\u5931\u8d25", this.getBeanName()), e);
            }
        }
        if (!StringUtil.isEmpty((String)this.getClassName())) {
            try {
                return (T)this.getClass().getClassLoader().loadClass(this.getClassName()).newInstance();
            }
            catch (Exception e) {
                throw new MenuCommandException(String.format("\u7c7b\u540d\u79f0\u4e3a[%s],\u5b9e\u4f8b\u5316\u7c7b\u5931\u8d25", this.getClassName()), e);
            }
        }
        throw new MenuCommandException(String.format("\u540d\u79f0\u4e3a[%s]\u7684BaseCommand\u6ca1\u6709\u5339\u914d\u5904\u7406\u5bf9\u8c61,\u5b9e\u4f8b\u5316\u5931\u8d25!", this.getName()));
    }
}

