/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.menucommand.executor;

import org.tinygroup.context.Context;
import org.tinygroup.menucommand.CommandExecutor;
import org.tinygroup.menucommand.CommandHandler;
import org.tinygroup.menucommand.CommandResult;
import org.tinygroup.menucommand.MenuCommandConstants;
import org.tinygroup.menucommand.exception.MenuCommandException;
import org.tinygroup.template.TemplateContext;
import org.tinygroup.template.TemplateException;
import org.tinygroup.template.TemplateRender;
import org.tinygroup.template.impl.TemplateContextDefault;

public class DefaultCommandExecutor
implements CommandExecutor {
    private TemplateRender templateRender;
    private CommandHandler commandHandler;

    public TemplateRender getTemplateRender() {
        return this.templateRender;
    }

    public void setTemplateRender(TemplateRender templateRender) {
        this.templateRender = templateRender;
    }

    public CommandHandler getCommandHandler() {
        return this.commandHandler;
    }

    public void setCommandHandler(CommandHandler commandHandler) {
        this.commandHandler = commandHandler;
    }

    @Override
    public CommandResult execute(Context context) {
        if (this.commandHandler != null) {
            this.commandHandler.beforeExecute(context);
        }
        try {
            String path = this.getRenderPath(context);
            String message = this.render(path, context);
            CommandResult commandResult = new CommandResult(message, this.getMenuId(context));
            return commandResult;
        }
        catch (TemplateException e) {
            throw new MenuCommandException("\u547d\u4ee4\u6267\u884c\u5668\u6e32\u67d3\u6a21\u677f\u53d1\u751f\u5f02\u5e38:", e);
        }
        finally {
            if (this.commandHandler != null) {
                this.commandHandler.afterExecute(context);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String render(String path, Context context) throws TemplateException {
        TemplateContextDefault templateContext = new TemplateContextDefault();
        templateContext.setParent(context);
        try {
            String string = this.templateRender.renderTemplateWithOutLayout(path, (TemplateContext)templateContext);
            return string;
        }
        finally {
            templateContext.setParent(null);
        }
    }

    protected String getRenderPath(Context context) {
        return MenuCommandConstants.getRenderPath(context);
    }

    protected String getMenuId(Context context) {
        return (String)context.get("_goto_menu_id");
    }
}

