/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.sqlindexsource;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.tinygroup.fulltext.IndexOperator;
import org.tinygroup.fulltext.Pager;
import org.tinygroup.fulltext.document.Document;
import org.tinygroup.fulltext.field.Field;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemoryIndexOperator
implements IndexOperator {
    private Map<String, Document> results = new HashMap<String, Document>();

    public void createIndex(List<Document> docs) {
        for (Document doc : docs) {
            this.results.put((String)doc.getId().getValue(), doc);
        }
    }

    public void deleteIndex(List<Field> docIds) {
        for (Field field : docIds) {
            this.results.remove(field.getValue());
        }
    }

    public Pager<Document> search(String searchCondition, int start, int limit) {
        List<Document> list = new ArrayList();
        String[] keys = searchCondition.split(",");
        for (Map.Entry<String, Document> entry : this.results.entrySet()) {
            boolean tag = this.isMatch(keys, entry.getValue());
            if (!tag) continue;
            list.add(entry.getValue());
        }
        int total = list.size();
        if (start < total && start > 0) {
            list = list.subList(start, total);
        }
        if (limit < list.size() && limit > 0) {
            list = list.subList(0, limit);
        }
        Pager page = new Pager(total, start, limit, list);
        return page;
    }

    private boolean isMatch(String[] keys, Document doc) {
        for (Field field : doc) {
            String content = field.getValue().toString();
            for (String key : keys) {
                if (!content.contains(key)) continue;
                return true;
            }
        }
        return false;
    }
}

