/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.sqlindexsource;

import java.nio.charset.Charset;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.TestCase;
import org.tinygroup.beancontainer.BeanContainer;
import org.tinygroup.beancontainer.BeanContainerFactory;
import org.tinygroup.commons.tools.Resources;
import org.tinygroup.fulltext.FullText;
import org.tinygroup.fulltext.Pager;
import org.tinygroup.fulltext.document.Document;
import org.tinygroup.sqlindexsource.ScriptRunner;
import org.tinygroup.tinyrunner.Runner;

public class SqlIndexTest
extends TestCase {
    private FullText fullText;
    private static final String driver = "org.apache.derby.jdbc.EmbeddedDriver";
    private static final String url = "jdbc:derby:TESTDB;create=true";
    private static final String user = "opensource";
    private static final String password = "opensource";

    protected void setUp() throws Exception {
        super.setUp();
        Runner.init((String)"application.xml", null);
        BeanContainer container = BeanContainerFactory.getBeanContainer((ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        this.fullText = (FullText)container.getBean("memoryFullText");
        Class.forName(driver);
        this.initDerby();
    }

    private Connection getConnection() throws SQLException {
        return DriverManager.getConnection(url, "opensource", "opensource");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initDerby() throws Exception {
        Connection conn = this.getConnection();
        Statement stmt = null;
        try {
            ScriptRunner runner = new ScriptRunner(conn, false, false);
            Resources.setCharset((Charset)Charset.forName("utf-8"));
            runner.runScript(Resources.getResourceAsReader((String)"table_derby.sql"));
            stmt = conn.createStatement();
            stmt.execute("delete from ARTICLE");
            stmt.execute("insert into ARTICLE (id,title,content,author,create_date) values('10001','\u5c71\u6d77\u5173','\u4e00\u4e8c\u4e09\u56db\u4e94\u516d\u4e03\u516b\u4e5d','\u767d\u7389','20061225')");
            stmt.execute("insert into ARTICLE (id,title,content,author,create_date) values('10002','\u968f\u673a\u6570\u636e','abcdefdfdfdfdfdf','\u9ed1\u7bb1','20160522')");
            stmt.execute("insert into ARTICLE (id,title,content,author,create_date) values('10003','\u6d4b\u8bd5\u6570\u636e','\u6211\u7231\u6211\u5bb6','Mr.R','20061125')");
            conn.commit();
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
            if (conn != null) {
                conn.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDB() throws Exception {
        SqlIndexTest.assertNotNull((Object)this.fullText);
        Connection conn = this.getConnection();
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = conn.createStatement();
            rs = stmt.executeQuery("select * from ARTICLE");
            this.fullText.createIndex("db", (Object)rs, new Object[0]);
            Pager page = this.fullText.search("\u6570\u636e");
            SqlIndexTest.assertEquals((int)2, (int)page.getTotalCount());
            Document doc = (Document)page.getRecords().get(0);
            SqlIndexTest.assertEquals((Object)"10002", (Object)doc.getId().getValue());
            SqlIndexTest.assertEquals((Object)"db", (Object)doc.getType().getValue());
            SqlIndexTest.assertEquals((Object)"\u968f\u673a\u6570\u636e", (Object)doc.getTitle().getValue());
            SqlIndexTest.assertEquals((Object)"abcdefdfdfdfdfdf\u9ed1\u7bb1", (Object)doc.getAbstract().getValue());
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
            if (conn != null) {
                conn.close();
            }
        }
    }
}

