/*
 * Decompiled with CFR 0.152.
 */
package org.typesense.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import org.typesense.model.Field;

public class CollectionSchema {
    @Schema(example="companies", required=true, description="Name of the collection")
    private String name = null;
    @Schema(example="[{\"name\":\"num_employees\",\"type\":\"int32\",\"facet\":false},{\"name\":\"company_name\",\"type\":\"string\",\"facet\":false},{\"name\":\"country\",\"type\":\"string\",\"facet\":true}]", required=true, description="A list of fields for querying, filtering and faceting")
    private List<Field> fields = new ArrayList<Field>();
    @Schema(example="num_employees", description="The name of an int32 / float field that determines the order in which the search results are ranked when a sort_by clause is not provided during searching. This field must indicate some kind of popularity.")
    private String defaultSortingField = "";
    @Schema(description="List of symbols or special characters to be used for  splitting the text into individual words in addition to space and new-line characters. ")
    private List<String> tokenSeparators = null;
    @Schema(example="true", description="Enables experimental support at a collection level for nested object or object array fields. This field is only available if the Typesense server is version `0.24.0.rcn34` or later.")
    private Boolean enableNestedFields = false;
    @Schema(description="List of symbols or special characters to be indexed. ")
    private List<String> symbolsToIndex = null;

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public CollectionSchema name(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty(value="fields")
    public List<Field> getFields() {
        return this.fields;
    }

    public void setFields(List<Field> fields) {
        this.fields = fields;
    }

    public CollectionSchema fields(List<Field> fields) {
        this.fields = fields;
        return this;
    }

    public CollectionSchema addFieldsItem(Field fieldsItem) {
        this.fields.add(fieldsItem);
        return this;
    }

    @JsonProperty(value="default_sorting_field")
    public String getDefaultSortingField() {
        return this.defaultSortingField;
    }

    public void setDefaultSortingField(String defaultSortingField) {
        this.defaultSortingField = defaultSortingField;
    }

    public CollectionSchema defaultSortingField(String defaultSortingField) {
        this.defaultSortingField = defaultSortingField;
        return this;
    }

    @JsonProperty(value="token_separators")
    public List<String> getTokenSeparators() {
        return this.tokenSeparators;
    }

    public void setTokenSeparators(List<String> tokenSeparators) {
        this.tokenSeparators = tokenSeparators;
    }

    public CollectionSchema tokenSeparators(List<String> tokenSeparators) {
        this.tokenSeparators = tokenSeparators;
        return this;
    }

    public CollectionSchema addTokenSeparatorsItem(String tokenSeparatorsItem) {
        this.tokenSeparators.add(tokenSeparatorsItem);
        return this;
    }

    @JsonProperty(value="enable_nested_fields")
    public Boolean isEnableNestedFields() {
        return this.enableNestedFields;
    }

    public void setEnableNestedFields(Boolean enableNestedFields) {
        this.enableNestedFields = enableNestedFields;
    }

    public CollectionSchema enableNestedFields(Boolean enableNestedFields) {
        this.enableNestedFields = enableNestedFields;
        return this;
    }

    @JsonProperty(value="symbols_to_index")
    public List<String> getSymbolsToIndex() {
        return this.symbolsToIndex;
    }

    public void setSymbolsToIndex(List<String> symbolsToIndex) {
        this.symbolsToIndex = symbolsToIndex;
    }

    public CollectionSchema symbolsToIndex(List<String> symbolsToIndex) {
        this.symbolsToIndex = symbolsToIndex;
        return this;
    }

    public CollectionSchema addSymbolsToIndexItem(String symbolsToIndexItem) {
        this.symbolsToIndex.add(symbolsToIndexItem);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CollectionSchema {\n");
        sb.append("    name: ").append(CollectionSchema.toIndentedString(this.name)).append("\n");
        sb.append("    fields: ").append(CollectionSchema.toIndentedString(this.fields)).append("\n");
        sb.append("    defaultSortingField: ").append(CollectionSchema.toIndentedString(this.defaultSortingField)).append("\n");
        sb.append("    tokenSeparators: ").append(CollectionSchema.toIndentedString(this.tokenSeparators)).append("\n");
        sb.append("    enableNestedFields: ").append(CollectionSchema.toIndentedString(this.enableNestedFields)).append("\n");
        sb.append("    symbolsToIndex: ").append(CollectionSchema.toIndentedString(this.symbolsToIndex)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private static String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

