/*
 * Decompiled with CFR 0.152.
 */
package org.typesense.api;

import java.util.HashMap;
import java.util.Map;
import org.typesense.api.Alias;
import org.typesense.api.Aliases;
import org.typesense.api.ApiCall;
import org.typesense.api.Collection;
import org.typesense.api.Collections;
import org.typesense.api.Configuration;
import org.typesense.api.Debug;
import org.typesense.api.Health;
import org.typesense.api.Key;
import org.typesense.api.Keys;
import org.typesense.api.Metrics;
import org.typesense.api.MultiSearch;
import org.typesense.api.Operations;

public class Client {
    private Configuration configuration;
    private ApiCall apiCall;
    private Collections collections;
    private Map<String, Collection> individualCollections;
    private Aliases aliases;
    private Map<String, Alias> individualAliases;
    private Keys keys;
    private Map<Long, Key> individualKeys;
    public Health health;
    public Operations operations;
    public Metrics metrics;
    public Debug debug;
    public MultiSearch multiSearch;

    public Client(Configuration configuration) {
        this.configuration = configuration;
        this.apiCall = new ApiCall(configuration);
        this.collections = new Collections(this.apiCall);
        this.individualCollections = new HashMap<String, Collection>();
        this.aliases = new Aliases(this.apiCall);
        this.individualAliases = new HashMap<String, Alias>();
        this.keys = new Keys(this.apiCall);
        this.individualKeys = new HashMap<Long, Key>();
        this.health = new Health(this.apiCall);
        this.operations = new Operations(this.apiCall);
        this.metrics = new Metrics(this.apiCall);
        this.debug = new Debug(this.apiCall);
        this.multiSearch = new MultiSearch(this.apiCall);
    }

    public Collection collections(String name) {
        if (!this.individualCollections.containsKey(name)) {
            this.individualCollections.put(name, new Collection(name, this.apiCall, this.configuration));
        }
        Collection retVal = this.individualCollections.get(name);
        return retVal;
    }

    public Collections collections() {
        return this.collections;
    }

    public Aliases aliases() {
        return this.aliases;
    }

    public Alias aliases(String name) {
        if (!this.individualAliases.containsKey(name)) {
            this.individualAliases.put(name, new Alias(this.apiCall, name));
        }
        Alias retVal = this.individualAliases.get(name);
        return retVal;
    }

    public Keys keys() {
        return this.keys;
    }

    public Key keys(Long id) {
        if (!this.individualKeys.containsKey(id)) {
            this.individualKeys.put(id, new Key(id, this.apiCall));
        }
        Key retVal = this.individualKeys.get(id);
        return retVal;
    }
}

