/*
 * Decompiled with CFR 0.152.
 */
package org.typesense.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;

@Schema(description="Parameters for the multi search API. ")
public class MultiSearchParameters {
    @Schema(description="The query text to search for in the collection. Use * as the search string to return all documents. This is typically useful when used in conjunction with filter_by.")
    private String q = null;
    @Schema(description="A list of `string` fields that should be queried against. Multiple fields are separated with a comma.")
    private String queryBy = null;
    @Schema(description="The relative weight to give each `query_by` field when ranking results. This can be used to boost fields in priority, when looking for matches. Multiple fields are separated with a comma.")
    private String queryByWeights = null;
    @Schema(description="Boolean field to indicate that the last word in the query should be treated as a prefix, and not as a whole word. This is used for building autocomplete and instant search interfaces. Defaults to true.")
    private String prefix = null;
    @Schema(description="If infix index is enabled for this field, infix searching can be done on a per-field basis by sending a comma separated string parameter called infix to the search query. This parameter can have 3 values; `off` infix search is disabled, which is default `always` infix search is performed along with regular search `fallback` infix search is performed if regular search does not produce results")
    private String infix = null;
    @Schema(description="There are also 2 parameters that allow you to control the extent of infix searching max_extra_prefix and max_extra_suffix which specify the maximum number of symbols before or after the query that can be present in the token. For example query \"K2100\" has 2 extra symbols in \"6PK2100\". By default, any number of prefixes/suffixes can be present for a match.")
    private Integer maxExtraPrefix = null;
    @Schema(description="There are also 2 parameters that allow you to control the extent of infix searching max_extra_prefix and max_extra_suffix which specify the maximum number of symbols before or after the query that can be present in the token. For example query \"K2100\" has 2 extra symbols in \"6PK2100\". By default, any number of prefixes/suffixes can be present for a match.")
    private Integer maxExtraSuffix = null;
    @Schema(example="num_employees:>100 && country: [USA, UK]", description="Filter conditions for refining youropen api validator search results. Separate multiple conditions with &&.")
    private String filterBy = null;
    @Schema(description="A list of numerical fields and their corresponding sort orders that will be used for ordering your results. Up to 3 sort fields can be specified. The text similarity score is exposed as a special `_text_match` field that you can use in the list of sorting fields. If no `sort_by` parameter is specified, results are sorted by `_text_match:desc,default_sorting_field:desc`")
    private String sortBy = null;
    @Schema(description="A list of fields that will be used for faceting your results on. Separate multiple fields with a comma.")
    private String facetBy = null;
    @Schema(description="Maximum number of facet values to be returned.")
    private Integer maxFacetValues = null;
    @Schema(description="Facet values that are returned can now be filtered via this parameter. The matching facet text is also highlighted. For example, when faceting by `category`, you can set `facet_query=category:shoe` to return only facet values that contain the prefix \"shoe\".")
    private String facetQuery = null;
    @Schema(description="The number of typographical errors (1 or 2) that would be tolerated. Default: 2 ")
    private String numTypos = null;
    @Schema(description="Results from this specific page number would be fetched.")
    private Integer page = null;
    @Schema(description="Number of results to fetch per page. Default: 10")
    private Integer perPage = null;
    @Schema(description="You can aggregate search results into groups or buckets by specify one or more `group_by` fields. Separate multiple fields with a comma. To group on a particular field, it must be a faceted field.")
    private String groupBy = null;
    @Schema(description="Maximum number of hits to be returned for every group. If the `group_limit` is set as `K` then only the top K hits in each group are returned in the response. Default: 3 ")
    private Integer groupLimit = null;
    @Schema(description="List of fields from the document to include in the search result")
    private String includeFields = null;
    @Schema(description="List of fields from the document to exclude in the search result")
    private String excludeFields = null;
    @Schema(description="List of fields which should be highlighted fully without snippeting")
    private String highlightFullFields = null;
    @Schema(description="The number of tokens that should surround the highlighted text on each side. Default: 4 ")
    private Integer highlightAffixNumTokens = null;
    @Schema(description="The start tag used for the highlighted snippets. Default: `<mark>` ")
    private String highlightStartTag = null;
    @Schema(description="The end tag used for the highlighted snippets. Default: `</mark>` ")
    private String highlightEndTag = null;
    @Schema(description="Field values under this length will be fully highlighted, instead of showing a snippet of relevant portion. Default: 30 ")
    private Integer snippetThreshold = null;
    @Schema(description="If the number of results found for a specific query is less than this number, Typesense will attempt to drop the tokens in the query until enough results are found. Tokens that have the least individual hits are dropped first. Set to 0 to disable. Default: 10 ")
    private Integer dropTokensThreshold = null;
    @Schema(description="If the number of results found for a specific query is less than this number, Typesense will attempt to look for tokens with more typos until enough results are found. Default: 100 ")
    private Integer typoTokensThreshold = null;
    @Schema(description="A list of records to unconditionally include in the search results at specific positions. An example use case would be to feature or promote certain items on the top of search results. A list of `record_id:hit_position`. Eg: to include a record with ID 123 at Position 1 and another record with ID 456 at Position 5, you'd specify `123:1,456:5`. You could also use the Overrides feature to override search results based on rules. Overrides are applied first, followed by `pinned_hits` and  finally `hidden_hits`. ")
    private String pinnedHits = null;
    @Schema(description="A list of records to unconditionally hide from search results. A list of `record_id`s to hide. Eg: to hide records with IDs 123 and 456, you'd specify `123,456`. You could also use the Overrides feature to override search results based on rules. Overrides are applied first, followed by `pinned_hits` and finally `hidden_hits`. ")
    private String hiddenHits = null;
    @Schema(description="A list of custom fields that must be highlighted even if you don't query  for them ")
    private String highlightFields = null;
    @Schema(description="You can index content from any logographic language into Typesense if you are able to segment / split the text into space-separated words yourself  before indexing and querying. Set this parameter to true to do the same ")
    private Boolean preSegmentedQuery = null;
    @Schema(description="If you have some overrides defined but want to disable all of them during query time, you can do that by setting this parameter to false ")
    private Boolean enableOverrides = null;
    @Schema(description="Set this parameter to true to ensure that an exact match is ranked above the others ")
    private Boolean prioritizeExactMatch = null;
    @Schema(description="Setting this to true will make Typesense consider all prefixes and typo  corrections of the words in the query without stopping early when enough results are found  (drop_tokens_threshold and typo_tokens_threshold configurations are ignored). ")
    private Boolean exhaustiveSearch = null;
    @Schema(description="Typesense will attempt to return results early if the cutoff time has elapsed.  This is not a strict guarantee and facet computation is not bound by this parameter. ")
    private Integer searchCutoffMs = null;
    @Schema(description="Enable server side caching of search query results. By default, caching is disabled. ")
    private Boolean useCache = null;
    @Schema(description="The duration (in seconds) that determines how long the search query is cached.  This value can be set on a per-query basis. Default: 60. ")
    private Integer cacheTtl = null;
    @Schema(description="Minimum word length for 1-typo correction to be applied.  The value of num_typos is still treated as the maximum allowed typos. ")
    private Integer minLen1typo = null;
    @Schema(description="Minimum word length for 2-typo correction to be applied.  The value of num_typos is still treated as the maximum allowed typos. ")
    private Integer minLen2typo = null;
    @Schema(description="Vector query expression for fetching documents \"closest\" to a given query/document vector. ")
    private String vectorQuery = null;

    @JsonProperty(value="q")
    public String getQ() {
        return this.q;
    }

    public void setQ(String q) {
        this.q = q;
    }

    public MultiSearchParameters q(String q) {
        this.q = q;
        return this;
    }

    @JsonProperty(value="query_by")
    public String getQueryBy() {
        return this.queryBy;
    }

    public void setQueryBy(String queryBy) {
        this.queryBy = queryBy;
    }

    public MultiSearchParameters queryBy(String queryBy) {
        this.queryBy = queryBy;
        return this;
    }

    @JsonProperty(value="query_by_weights")
    public String getQueryByWeights() {
        return this.queryByWeights;
    }

    public void setQueryByWeights(String queryByWeights) {
        this.queryByWeights = queryByWeights;
    }

    public MultiSearchParameters queryByWeights(String queryByWeights) {
        this.queryByWeights = queryByWeights;
        return this;
    }

    @JsonProperty(value="prefix")
    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public MultiSearchParameters prefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    @JsonProperty(value="infix")
    public String getInfix() {
        return this.infix;
    }

    public void setInfix(String infix) {
        this.infix = infix;
    }

    public MultiSearchParameters infix(String infix) {
        this.infix = infix;
        return this;
    }

    @JsonProperty(value="max_extra_prefix")
    public Integer getMaxExtraPrefix() {
        return this.maxExtraPrefix;
    }

    public void setMaxExtraPrefix(Integer maxExtraPrefix) {
        this.maxExtraPrefix = maxExtraPrefix;
    }

    public MultiSearchParameters maxExtraPrefix(Integer maxExtraPrefix) {
        this.maxExtraPrefix = maxExtraPrefix;
        return this;
    }

    @JsonProperty(value="max_extra_suffix")
    public Integer getMaxExtraSuffix() {
        return this.maxExtraSuffix;
    }

    public void setMaxExtraSuffix(Integer maxExtraSuffix) {
        this.maxExtraSuffix = maxExtraSuffix;
    }

    public MultiSearchParameters maxExtraSuffix(Integer maxExtraSuffix) {
        this.maxExtraSuffix = maxExtraSuffix;
        return this;
    }

    @JsonProperty(value="filter_by")
    public String getFilterBy() {
        return this.filterBy;
    }

    public void setFilterBy(String filterBy) {
        this.filterBy = filterBy;
    }

    public MultiSearchParameters filterBy(String filterBy) {
        this.filterBy = filterBy;
        return this;
    }

    @JsonProperty(value="sort_by")
    public String getSortBy() {
        return this.sortBy;
    }

    public void setSortBy(String sortBy) {
        this.sortBy = sortBy;
    }

    public MultiSearchParameters sortBy(String sortBy) {
        this.sortBy = sortBy;
        return this;
    }

    @JsonProperty(value="facet_by")
    public String getFacetBy() {
        return this.facetBy;
    }

    public void setFacetBy(String facetBy) {
        this.facetBy = facetBy;
    }

    public MultiSearchParameters facetBy(String facetBy) {
        this.facetBy = facetBy;
        return this;
    }

    @JsonProperty(value="max_facet_values")
    public Integer getMaxFacetValues() {
        return this.maxFacetValues;
    }

    public void setMaxFacetValues(Integer maxFacetValues) {
        this.maxFacetValues = maxFacetValues;
    }

    public MultiSearchParameters maxFacetValues(Integer maxFacetValues) {
        this.maxFacetValues = maxFacetValues;
        return this;
    }

    @JsonProperty(value="facet_query")
    public String getFacetQuery() {
        return this.facetQuery;
    }

    public void setFacetQuery(String facetQuery) {
        this.facetQuery = facetQuery;
    }

    public MultiSearchParameters facetQuery(String facetQuery) {
        this.facetQuery = facetQuery;
        return this;
    }

    @JsonProperty(value="num_typos")
    public String getNumTypos() {
        return this.numTypos;
    }

    public void setNumTypos(String numTypos) {
        this.numTypos = numTypos;
    }

    public MultiSearchParameters numTypos(String numTypos) {
        this.numTypos = numTypos;
        return this;
    }

    @JsonProperty(value="page")
    public Integer getPage() {
        return this.page;
    }

    public void setPage(Integer page) {
        this.page = page;
    }

    public MultiSearchParameters page(Integer page) {
        this.page = page;
        return this;
    }

    @JsonProperty(value="per_page")
    public Integer getPerPage() {
        return this.perPage;
    }

    public void setPerPage(Integer perPage) {
        this.perPage = perPage;
    }

    public MultiSearchParameters perPage(Integer perPage) {
        this.perPage = perPage;
        return this;
    }

    @JsonProperty(value="group_by")
    public String getGroupBy() {
        return this.groupBy;
    }

    public void setGroupBy(String groupBy) {
        this.groupBy = groupBy;
    }

    public MultiSearchParameters groupBy(String groupBy) {
        this.groupBy = groupBy;
        return this;
    }

    @JsonProperty(value="group_limit")
    public Integer getGroupLimit() {
        return this.groupLimit;
    }

    public void setGroupLimit(Integer groupLimit) {
        this.groupLimit = groupLimit;
    }

    public MultiSearchParameters groupLimit(Integer groupLimit) {
        this.groupLimit = groupLimit;
        return this;
    }

    @JsonProperty(value="include_fields")
    public String getIncludeFields() {
        return this.includeFields;
    }

    public void setIncludeFields(String includeFields) {
        this.includeFields = includeFields;
    }

    public MultiSearchParameters includeFields(String includeFields) {
        this.includeFields = includeFields;
        return this;
    }

    @JsonProperty(value="exclude_fields")
    public String getExcludeFields() {
        return this.excludeFields;
    }

    public void setExcludeFields(String excludeFields) {
        this.excludeFields = excludeFields;
    }

    public MultiSearchParameters excludeFields(String excludeFields) {
        this.excludeFields = excludeFields;
        return this;
    }

    @JsonProperty(value="highlight_full_fields")
    public String getHighlightFullFields() {
        return this.highlightFullFields;
    }

    public void setHighlightFullFields(String highlightFullFields) {
        this.highlightFullFields = highlightFullFields;
    }

    public MultiSearchParameters highlightFullFields(String highlightFullFields) {
        this.highlightFullFields = highlightFullFields;
        return this;
    }

    @JsonProperty(value="highlight_affix_num_tokens")
    public Integer getHighlightAffixNumTokens() {
        return this.highlightAffixNumTokens;
    }

    public void setHighlightAffixNumTokens(Integer highlightAffixNumTokens) {
        this.highlightAffixNumTokens = highlightAffixNumTokens;
    }

    public MultiSearchParameters highlightAffixNumTokens(Integer highlightAffixNumTokens) {
        this.highlightAffixNumTokens = highlightAffixNumTokens;
        return this;
    }

    @JsonProperty(value="highlight_start_tag")
    public String getHighlightStartTag() {
        return this.highlightStartTag;
    }

    public void setHighlightStartTag(String highlightStartTag) {
        this.highlightStartTag = highlightStartTag;
    }

    public MultiSearchParameters highlightStartTag(String highlightStartTag) {
        this.highlightStartTag = highlightStartTag;
        return this;
    }

    @JsonProperty(value="highlight_end_tag")
    public String getHighlightEndTag() {
        return this.highlightEndTag;
    }

    public void setHighlightEndTag(String highlightEndTag) {
        this.highlightEndTag = highlightEndTag;
    }

    public MultiSearchParameters highlightEndTag(String highlightEndTag) {
        this.highlightEndTag = highlightEndTag;
        return this;
    }

    @JsonProperty(value="snippet_threshold")
    public Integer getSnippetThreshold() {
        return this.snippetThreshold;
    }

    public void setSnippetThreshold(Integer snippetThreshold) {
        this.snippetThreshold = snippetThreshold;
    }

    public MultiSearchParameters snippetThreshold(Integer snippetThreshold) {
        this.snippetThreshold = snippetThreshold;
        return this;
    }

    @JsonProperty(value="drop_tokens_threshold")
    public Integer getDropTokensThreshold() {
        return this.dropTokensThreshold;
    }

    public void setDropTokensThreshold(Integer dropTokensThreshold) {
        this.dropTokensThreshold = dropTokensThreshold;
    }

    public MultiSearchParameters dropTokensThreshold(Integer dropTokensThreshold) {
        this.dropTokensThreshold = dropTokensThreshold;
        return this;
    }

    @JsonProperty(value="typo_tokens_threshold")
    public Integer getTypoTokensThreshold() {
        return this.typoTokensThreshold;
    }

    public void setTypoTokensThreshold(Integer typoTokensThreshold) {
        this.typoTokensThreshold = typoTokensThreshold;
    }

    public MultiSearchParameters typoTokensThreshold(Integer typoTokensThreshold) {
        this.typoTokensThreshold = typoTokensThreshold;
        return this;
    }

    @JsonProperty(value="pinned_hits")
    public String getPinnedHits() {
        return this.pinnedHits;
    }

    public void setPinnedHits(String pinnedHits) {
        this.pinnedHits = pinnedHits;
    }

    public MultiSearchParameters pinnedHits(String pinnedHits) {
        this.pinnedHits = pinnedHits;
        return this;
    }

    @JsonProperty(value="hidden_hits")
    public String getHiddenHits() {
        return this.hiddenHits;
    }

    public void setHiddenHits(String hiddenHits) {
        this.hiddenHits = hiddenHits;
    }

    public MultiSearchParameters hiddenHits(String hiddenHits) {
        this.hiddenHits = hiddenHits;
        return this;
    }

    @JsonProperty(value="highlight_fields")
    public String getHighlightFields() {
        return this.highlightFields;
    }

    public void setHighlightFields(String highlightFields) {
        this.highlightFields = highlightFields;
    }

    public MultiSearchParameters highlightFields(String highlightFields) {
        this.highlightFields = highlightFields;
        return this;
    }

    @JsonProperty(value="pre_segmented_query")
    public Boolean isPreSegmentedQuery() {
        return this.preSegmentedQuery;
    }

    public void setPreSegmentedQuery(Boolean preSegmentedQuery) {
        this.preSegmentedQuery = preSegmentedQuery;
    }

    public MultiSearchParameters preSegmentedQuery(Boolean preSegmentedQuery) {
        this.preSegmentedQuery = preSegmentedQuery;
        return this;
    }

    @JsonProperty(value="enable_overrides")
    public Boolean isEnableOverrides() {
        return this.enableOverrides;
    }

    public void setEnableOverrides(Boolean enableOverrides) {
        this.enableOverrides = enableOverrides;
    }

    public MultiSearchParameters enableOverrides(Boolean enableOverrides) {
        this.enableOverrides = enableOverrides;
        return this;
    }

    @JsonProperty(value="prioritize_exact_match")
    public Boolean isPrioritizeExactMatch() {
        return this.prioritizeExactMatch;
    }

    public void setPrioritizeExactMatch(Boolean prioritizeExactMatch) {
        this.prioritizeExactMatch = prioritizeExactMatch;
    }

    public MultiSearchParameters prioritizeExactMatch(Boolean prioritizeExactMatch) {
        this.prioritizeExactMatch = prioritizeExactMatch;
        return this;
    }

    @JsonProperty(value="exhaustive_search")
    public Boolean isExhaustiveSearch() {
        return this.exhaustiveSearch;
    }

    public void setExhaustiveSearch(Boolean exhaustiveSearch) {
        this.exhaustiveSearch = exhaustiveSearch;
    }

    public MultiSearchParameters exhaustiveSearch(Boolean exhaustiveSearch) {
        this.exhaustiveSearch = exhaustiveSearch;
        return this;
    }

    @JsonProperty(value="search_cutoff_ms")
    public Integer getSearchCutoffMs() {
        return this.searchCutoffMs;
    }

    public void setSearchCutoffMs(Integer searchCutoffMs) {
        this.searchCutoffMs = searchCutoffMs;
    }

    public MultiSearchParameters searchCutoffMs(Integer searchCutoffMs) {
        this.searchCutoffMs = searchCutoffMs;
        return this;
    }

    @JsonProperty(value="use_cache")
    public Boolean isUseCache() {
        return this.useCache;
    }

    public void setUseCache(Boolean useCache) {
        this.useCache = useCache;
    }

    public MultiSearchParameters useCache(Boolean useCache) {
        this.useCache = useCache;
        return this;
    }

    @JsonProperty(value="cache_ttl")
    public Integer getCacheTtl() {
        return this.cacheTtl;
    }

    public void setCacheTtl(Integer cacheTtl) {
        this.cacheTtl = cacheTtl;
    }

    public MultiSearchParameters cacheTtl(Integer cacheTtl) {
        this.cacheTtl = cacheTtl;
        return this;
    }

    @JsonProperty(value="min_len_1typo")
    public Integer getMinLen1typo() {
        return this.minLen1typo;
    }

    public void setMinLen1typo(Integer minLen1typo) {
        this.minLen1typo = minLen1typo;
    }

    public MultiSearchParameters minLen1typo(Integer minLen1typo) {
        this.minLen1typo = minLen1typo;
        return this;
    }

    @JsonProperty(value="min_len_2typo")
    public Integer getMinLen2typo() {
        return this.minLen2typo;
    }

    public void setMinLen2typo(Integer minLen2typo) {
        this.minLen2typo = minLen2typo;
    }

    public MultiSearchParameters minLen2typo(Integer minLen2typo) {
        this.minLen2typo = minLen2typo;
        return this;
    }

    @JsonProperty(value="vector_query")
    public String getVectorQuery() {
        return this.vectorQuery;
    }

    public void setVectorQuery(String vectorQuery) {
        this.vectorQuery = vectorQuery;
    }

    public MultiSearchParameters vectorQuery(String vectorQuery) {
        this.vectorQuery = vectorQuery;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MultiSearchParameters {\n");
        sb.append("    q: ").append(MultiSearchParameters.toIndentedString(this.q)).append("\n");
        sb.append("    queryBy: ").append(MultiSearchParameters.toIndentedString(this.queryBy)).append("\n");
        sb.append("    queryByWeights: ").append(MultiSearchParameters.toIndentedString(this.queryByWeights)).append("\n");
        sb.append("    prefix: ").append(MultiSearchParameters.toIndentedString(this.prefix)).append("\n");
        sb.append("    infix: ").append(MultiSearchParameters.toIndentedString(this.infix)).append("\n");
        sb.append("    maxExtraPrefix: ").append(MultiSearchParameters.toIndentedString(this.maxExtraPrefix)).append("\n");
        sb.append("    maxExtraSuffix: ").append(MultiSearchParameters.toIndentedString(this.maxExtraSuffix)).append("\n");
        sb.append("    filterBy: ").append(MultiSearchParameters.toIndentedString(this.filterBy)).append("\n");
        sb.append("    sortBy: ").append(MultiSearchParameters.toIndentedString(this.sortBy)).append("\n");
        sb.append("    facetBy: ").append(MultiSearchParameters.toIndentedString(this.facetBy)).append("\n");
        sb.append("    maxFacetValues: ").append(MultiSearchParameters.toIndentedString(this.maxFacetValues)).append("\n");
        sb.append("    facetQuery: ").append(MultiSearchParameters.toIndentedString(this.facetQuery)).append("\n");
        sb.append("    numTypos: ").append(MultiSearchParameters.toIndentedString(this.numTypos)).append("\n");
        sb.append("    page: ").append(MultiSearchParameters.toIndentedString(this.page)).append("\n");
        sb.append("    perPage: ").append(MultiSearchParameters.toIndentedString(this.perPage)).append("\n");
        sb.append("    groupBy: ").append(MultiSearchParameters.toIndentedString(this.groupBy)).append("\n");
        sb.append("    groupLimit: ").append(MultiSearchParameters.toIndentedString(this.groupLimit)).append("\n");
        sb.append("    includeFields: ").append(MultiSearchParameters.toIndentedString(this.includeFields)).append("\n");
        sb.append("    excludeFields: ").append(MultiSearchParameters.toIndentedString(this.excludeFields)).append("\n");
        sb.append("    highlightFullFields: ").append(MultiSearchParameters.toIndentedString(this.highlightFullFields)).append("\n");
        sb.append("    highlightAffixNumTokens: ").append(MultiSearchParameters.toIndentedString(this.highlightAffixNumTokens)).append("\n");
        sb.append("    highlightStartTag: ").append(MultiSearchParameters.toIndentedString(this.highlightStartTag)).append("\n");
        sb.append("    highlightEndTag: ").append(MultiSearchParameters.toIndentedString(this.highlightEndTag)).append("\n");
        sb.append("    snippetThreshold: ").append(MultiSearchParameters.toIndentedString(this.snippetThreshold)).append("\n");
        sb.append("    dropTokensThreshold: ").append(MultiSearchParameters.toIndentedString(this.dropTokensThreshold)).append("\n");
        sb.append("    typoTokensThreshold: ").append(MultiSearchParameters.toIndentedString(this.typoTokensThreshold)).append("\n");
        sb.append("    pinnedHits: ").append(MultiSearchParameters.toIndentedString(this.pinnedHits)).append("\n");
        sb.append("    hiddenHits: ").append(MultiSearchParameters.toIndentedString(this.hiddenHits)).append("\n");
        sb.append("    highlightFields: ").append(MultiSearchParameters.toIndentedString(this.highlightFields)).append("\n");
        sb.append("    preSegmentedQuery: ").append(MultiSearchParameters.toIndentedString(this.preSegmentedQuery)).append("\n");
        sb.append("    enableOverrides: ").append(MultiSearchParameters.toIndentedString(this.enableOverrides)).append("\n");
        sb.append("    prioritizeExactMatch: ").append(MultiSearchParameters.toIndentedString(this.prioritizeExactMatch)).append("\n");
        sb.append("    exhaustiveSearch: ").append(MultiSearchParameters.toIndentedString(this.exhaustiveSearch)).append("\n");
        sb.append("    searchCutoffMs: ").append(MultiSearchParameters.toIndentedString(this.searchCutoffMs)).append("\n");
        sb.append("    useCache: ").append(MultiSearchParameters.toIndentedString(this.useCache)).append("\n");
        sb.append("    cacheTtl: ").append(MultiSearchParameters.toIndentedString(this.cacheTtl)).append("\n");
        sb.append("    minLen1typo: ").append(MultiSearchParameters.toIndentedString(this.minLen1typo)).append("\n");
        sb.append("    minLen2typo: ").append(MultiSearchParameters.toIndentedString(this.minLen2typo)).append("\n");
        sb.append("    vectorQuery: ").append(MultiSearchParameters.toIndentedString(this.vectorQuery)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private static String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

