/*
 * Decompiled with CFR 0.152.
 */
package org.typesense.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

public class ConversationModelUpdateSchema {
    @JsonProperty(value="id")
    private String id = null;
    @JsonProperty(value="model_name")
    private String modelName = null;
    @JsonProperty(value="api_key")
    private String apiKey = null;
    @JsonProperty(value="history_collection")
    private String historyCollection = null;
    @JsonProperty(value="account_id")
    private String accountId = null;
    @JsonProperty(value="system_prompt")
    private String systemPrompt = null;
    @JsonProperty(value="ttl")
    private Integer ttl = null;
    @JsonProperty(value="max_bytes")
    private Integer maxBytes = null;
    @JsonProperty(value="vllm_url")
    private String vllmUrl = null;

    public ConversationModelUpdateSchema id(String id) {
        this.id = id;
        return this;
    }

    @Schema(description="An explicit id for the model, otherwise the API will return a response with an auto-generated conversation model id.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public ConversationModelUpdateSchema modelName(String modelName) {
        this.modelName = modelName;
        return this;
    }

    @Schema(description="Name of the LLM model offered by OpenAI, Cloudflare or vLLM")
    public String getModelName() {
        return this.modelName;
    }

    public void setModelName(String modelName) {
        this.modelName = modelName;
    }

    public ConversationModelUpdateSchema apiKey(String apiKey) {
        this.apiKey = apiKey;
        return this;
    }

    @Schema(description="The LLM service's API Key")
    public String getApiKey() {
        return this.apiKey;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public ConversationModelUpdateSchema historyCollection(String historyCollection) {
        this.historyCollection = historyCollection;
        return this;
    }

    @Schema(description="Typesense collection that stores the historical conversations")
    public String getHistoryCollection() {
        return this.historyCollection;
    }

    public void setHistoryCollection(String historyCollection) {
        this.historyCollection = historyCollection;
    }

    public ConversationModelUpdateSchema accountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    @Schema(description="LLM service's account ID (only applicable for Cloudflare)")
    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public ConversationModelUpdateSchema systemPrompt(String systemPrompt) {
        this.systemPrompt = systemPrompt;
        return this;
    }

    @Schema(description="The system prompt that contains special instructions to the LLM")
    public String getSystemPrompt() {
        return this.systemPrompt;
    }

    public void setSystemPrompt(String systemPrompt) {
        this.systemPrompt = systemPrompt;
    }

    public ConversationModelUpdateSchema ttl(Integer ttl) {
        this.ttl = ttl;
        return this;
    }

    @Schema(description="Time interval in seconds after which the messages would be deleted. Default: 86400 (24 hours) ")
    public Integer getTtl() {
        return this.ttl;
    }

    public void setTtl(Integer ttl) {
        this.ttl = ttl;
    }

    public ConversationModelUpdateSchema maxBytes(Integer maxBytes) {
        this.maxBytes = maxBytes;
        return this;
    }

    @Schema(description="The maximum number of bytes to send to the LLM in every API call. Consult the LLM's documentation on the number of bytes supported in the context window. ")
    public Integer getMaxBytes() {
        return this.maxBytes;
    }

    public void setMaxBytes(Integer maxBytes) {
        this.maxBytes = maxBytes;
    }

    public ConversationModelUpdateSchema vllmUrl(String vllmUrl) {
        this.vllmUrl = vllmUrl;
        return this;
    }

    @Schema(description="URL of vLLM service")
    public String getVllmUrl() {
        return this.vllmUrl;
    }

    public void setVllmUrl(String vllmUrl) {
        this.vllmUrl = vllmUrl;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConversationModelUpdateSchema conversationModelUpdateSchema = (ConversationModelUpdateSchema)o;
        return Objects.equals(this.id, conversationModelUpdateSchema.id) && Objects.equals(this.modelName, conversationModelUpdateSchema.modelName) && Objects.equals(this.apiKey, conversationModelUpdateSchema.apiKey) && Objects.equals(this.historyCollection, conversationModelUpdateSchema.historyCollection) && Objects.equals(this.accountId, conversationModelUpdateSchema.accountId) && Objects.equals(this.systemPrompt, conversationModelUpdateSchema.systemPrompt) && Objects.equals(this.ttl, conversationModelUpdateSchema.ttl) && Objects.equals(this.maxBytes, conversationModelUpdateSchema.maxBytes) && Objects.equals(this.vllmUrl, conversationModelUpdateSchema.vllmUrl);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.modelName, this.apiKey, this.historyCollection, this.accountId, this.systemPrompt, this.ttl, this.maxBytes, this.vllmUrl);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ConversationModelUpdateSchema {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    modelName: ").append(this.toIndentedString(this.modelName)).append("\n");
        sb.append("    apiKey: ").append(this.toIndentedString(this.apiKey)).append("\n");
        sb.append("    historyCollection: ").append(this.toIndentedString(this.historyCollection)).append("\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    systemPrompt: ").append(this.toIndentedString(this.systemPrompt)).append("\n");
        sb.append("    ttl: ").append(this.toIndentedString(this.ttl)).append("\n");
        sb.append("    maxBytes: ").append(this.toIndentedString(this.maxBytes)).append("\n");
        sb.append("    vllmUrl: ").append(this.toIndentedString(this.vllmUrl)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

