/*
 * Decompiled with CFR 0.152.
 */
package org.typesense.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.typesense.model.SearchOverrideExclude;
import org.typesense.model.SearchOverrideInclude;
import org.typesense.model.SearchOverrideRule;

public class SearchOverrideSchema {
    @JsonProperty(value="rule")
    private SearchOverrideRule rule = null;
    @JsonProperty(value="includes")
    private List<SearchOverrideInclude> includes = null;
    @JsonProperty(value="excludes")
    private List<SearchOverrideExclude> excludes = null;
    @JsonProperty(value="filter_by")
    private String filterBy = null;
    @JsonProperty(value="remove_matched_tokens")
    private Boolean removeMatchedTokens = null;
    @JsonProperty(value="metadata")
    private Object metadata = null;
    @JsonProperty(value="sort_by")
    private String sortBy = null;
    @JsonProperty(value="replace_query")
    private String replaceQuery = null;
    @JsonProperty(value="filter_curated_hits")
    private Boolean filterCuratedHits = null;
    @JsonProperty(value="effective_from_ts")
    private Integer effectiveFromTs = null;
    @JsonProperty(value="effective_to_ts")
    private Integer effectiveToTs = null;
    @JsonProperty(value="stop_processing")
    private Boolean stopProcessing = null;

    public SearchOverrideSchema rule(SearchOverrideRule rule) {
        this.rule = rule;
        return this;
    }

    @Schema(required=true, description="")
    public SearchOverrideRule getRule() {
        return this.rule;
    }

    public void setRule(SearchOverrideRule rule) {
        this.rule = rule;
    }

    public SearchOverrideSchema includes(List<SearchOverrideInclude> includes) {
        this.includes = includes;
        return this;
    }

    public SearchOverrideSchema addIncludesItem(SearchOverrideInclude includesItem) {
        if (this.includes == null) {
            this.includes = new ArrayList<SearchOverrideInclude>();
        }
        this.includes.add(includesItem);
        return this;
    }

    @Schema(description="List of document `id`s that should be included in the search results with their corresponding `position`s.")
    public List<SearchOverrideInclude> getIncludes() {
        return this.includes;
    }

    public void setIncludes(List<SearchOverrideInclude> includes) {
        this.includes = includes;
    }

    public SearchOverrideSchema excludes(List<SearchOverrideExclude> excludes) {
        this.excludes = excludes;
        return this;
    }

    public SearchOverrideSchema addExcludesItem(SearchOverrideExclude excludesItem) {
        if (this.excludes == null) {
            this.excludes = new ArrayList<SearchOverrideExclude>();
        }
        this.excludes.add(excludesItem);
        return this;
    }

    @Schema(description="List of document `id`s that should be excluded from the search results.")
    public List<SearchOverrideExclude> getExcludes() {
        return this.excludes;
    }

    public void setExcludes(List<SearchOverrideExclude> excludes) {
        this.excludes = excludes;
    }

    public SearchOverrideSchema filterBy(String filterBy) {
        this.filterBy = filterBy;
        return this;
    }

    @Schema(description="A filter by clause that is applied to any search query that matches the override rule. ")
    public String getFilterBy() {
        return this.filterBy;
    }

    public void setFilterBy(String filterBy) {
        this.filterBy = filterBy;
    }

    public SearchOverrideSchema removeMatchedTokens(Boolean removeMatchedTokens) {
        this.removeMatchedTokens = removeMatchedTokens;
        return this;
    }

    @Schema(description="Indicates whether search query tokens that exist in the override's rule should be removed from the search query. ")
    public Boolean isRemoveMatchedTokens() {
        return this.removeMatchedTokens;
    }

    public void setRemoveMatchedTokens(Boolean removeMatchedTokens) {
        this.removeMatchedTokens = removeMatchedTokens;
    }

    public SearchOverrideSchema metadata(Object metadata) {
        this.metadata = metadata;
        return this;
    }

    @Schema(description="Return a custom JSON object in the Search API response, when this rule is triggered. This can can be used to display a pre-defined message (eg: a promotion banner) on the front-end when a particular rule is triggered. ")
    public Object getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Object metadata) {
        this.metadata = metadata;
    }

    public SearchOverrideSchema sortBy(String sortBy) {
        this.sortBy = sortBy;
        return this;
    }

    @Schema(description="A sort by clause that is applied to any search query that matches the override rule. ")
    public String getSortBy() {
        return this.sortBy;
    }

    public void setSortBy(String sortBy) {
        this.sortBy = sortBy;
    }

    public SearchOverrideSchema replaceQuery(String replaceQuery) {
        this.replaceQuery = replaceQuery;
        return this;
    }

    @Schema(description="Replaces the current search query with this value, when the search query matches the override rule. ")
    public String getReplaceQuery() {
        return this.replaceQuery;
    }

    public void setReplaceQuery(String replaceQuery) {
        this.replaceQuery = replaceQuery;
    }

    public SearchOverrideSchema filterCuratedHits(Boolean filterCuratedHits) {
        this.filterCuratedHits = filterCuratedHits;
        return this;
    }

    @Schema(description="When set to true, the filter conditions of the query is applied to the curated records as well. Default: false. ")
    public Boolean isFilterCuratedHits() {
        return this.filterCuratedHits;
    }

    public void setFilterCuratedHits(Boolean filterCuratedHits) {
        this.filterCuratedHits = filterCuratedHits;
    }

    public SearchOverrideSchema effectiveFromTs(Integer effectiveFromTs) {
        this.effectiveFromTs = effectiveFromTs;
        return this;
    }

    @Schema(description="A Unix timestamp that indicates the date/time from which the override will be active. You can use this to create override rules that start applying from a future point in time. ")
    public Integer getEffectiveFromTs() {
        return this.effectiveFromTs;
    }

    public void setEffectiveFromTs(Integer effectiveFromTs) {
        this.effectiveFromTs = effectiveFromTs;
    }

    public SearchOverrideSchema effectiveToTs(Integer effectiveToTs) {
        this.effectiveToTs = effectiveToTs;
        return this;
    }

    @Schema(description="A Unix timestamp that indicates the date/time until which the override will be active. You can use this to create override rules that stop applying after a period of time. ")
    public Integer getEffectiveToTs() {
        return this.effectiveToTs;
    }

    public void setEffectiveToTs(Integer effectiveToTs) {
        this.effectiveToTs = effectiveToTs;
    }

    public SearchOverrideSchema stopProcessing(Boolean stopProcessing) {
        this.stopProcessing = stopProcessing;
        return this;
    }

    @Schema(description="When set to true, override processing will stop at the first matching rule. When set to false override processing will continue and multiple override actions will be triggered in sequence. Overrides are processed in the lexical sort order of their id field. Default: true. ")
    public Boolean isStopProcessing() {
        return this.stopProcessing;
    }

    public void setStopProcessing(Boolean stopProcessing) {
        this.stopProcessing = stopProcessing;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SearchOverrideSchema searchOverrideSchema = (SearchOverrideSchema)o;
        return Objects.equals(this.rule, searchOverrideSchema.rule) && Objects.equals(this.includes, searchOverrideSchema.includes) && Objects.equals(this.excludes, searchOverrideSchema.excludes) && Objects.equals(this.filterBy, searchOverrideSchema.filterBy) && Objects.equals(this.removeMatchedTokens, searchOverrideSchema.removeMatchedTokens) && Objects.equals(this.metadata, searchOverrideSchema.metadata) && Objects.equals(this.sortBy, searchOverrideSchema.sortBy) && Objects.equals(this.replaceQuery, searchOverrideSchema.replaceQuery) && Objects.equals(this.filterCuratedHits, searchOverrideSchema.filterCuratedHits) && Objects.equals(this.effectiveFromTs, searchOverrideSchema.effectiveFromTs) && Objects.equals(this.effectiveToTs, searchOverrideSchema.effectiveToTs) && Objects.equals(this.stopProcessing, searchOverrideSchema.stopProcessing);
    }

    public int hashCode() {
        return Objects.hash(this.rule, this.includes, this.excludes, this.filterBy, this.removeMatchedTokens, this.metadata, this.sortBy, this.replaceQuery, this.filterCuratedHits, this.effectiveFromTs, this.effectiveToTs, this.stopProcessing);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SearchOverrideSchema {\n");
        sb.append("    rule: ").append(this.toIndentedString(this.rule)).append("\n");
        sb.append("    includes: ").append(this.toIndentedString(this.includes)).append("\n");
        sb.append("    excludes: ").append(this.toIndentedString(this.excludes)).append("\n");
        sb.append("    filterBy: ").append(this.toIndentedString(this.filterBy)).append("\n");
        sb.append("    removeMatchedTokens: ").append(this.toIndentedString(this.removeMatchedTokens)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    sortBy: ").append(this.toIndentedString(this.sortBy)).append("\n");
        sb.append("    replaceQuery: ").append(this.toIndentedString(this.replaceQuery)).append("\n");
        sb.append("    filterCuratedHits: ").append(this.toIndentedString(this.filterCuratedHits)).append("\n");
        sb.append("    effectiveFromTs: ").append(this.toIndentedString(this.effectiveFromTs)).append("\n");
        sb.append("    effectiveToTs: ").append(this.toIndentedString(this.effectiveToTs)).append("\n");
        sb.append("    stopProcessing: ").append(this.toIndentedString(this.stopProcessing)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

