/*
 * Decompiled with CFR 0.152.
 */
package org.typesense.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.typesense.model.DropTokensMode;
import org.typesense.model.OneOfPresetUpsertSchemaValue;

public class SearchParameters
implements OneOfPresetUpsertSchemaValue {
    @JsonProperty(value="q")
    private String q = null;
    @JsonProperty(value="query_by")
    private String queryBy = null;
    @JsonProperty(value="query_by_weights")
    private String queryByWeights = null;
    @JsonProperty(value="text_match_type")
    private String textMatchType = null;
    @JsonProperty(value="prefix")
    private String prefix = null;
    @JsonProperty(value="infix")
    private String infix = null;
    @JsonProperty(value="max_extra_prefix")
    private Integer maxExtraPrefix = null;
    @JsonProperty(value="max_extra_suffix")
    private Integer maxExtraSuffix = null;
    @JsonProperty(value="filter_by")
    private String filterBy = null;
    @JsonProperty(value="sort_by")
    private String sortBy = null;
    @JsonProperty(value="facet_by")
    private String facetBy = null;
    @JsonProperty(value="max_facet_values")
    private Integer maxFacetValues = null;
    @JsonProperty(value="facet_query")
    private String facetQuery = null;
    @JsonProperty(value="num_typos")
    private String numTypos = null;
    @JsonProperty(value="page")
    private Integer page = null;
    @JsonProperty(value="per_page")
    private Integer perPage = null;
    @JsonProperty(value="limit")
    private Integer limit = null;
    @JsonProperty(value="offset")
    private Integer offset = null;
    @JsonProperty(value="group_by")
    private String groupBy = null;
    @JsonProperty(value="group_limit")
    private Integer groupLimit = null;
    @JsonProperty(value="group_missing_values")
    private Boolean groupMissingValues = null;
    @JsonProperty(value="include_fields")
    private String includeFields = null;
    @JsonProperty(value="exclude_fields")
    private String excludeFields = null;
    @JsonProperty(value="highlight_full_fields")
    private String highlightFullFields = null;
    @JsonProperty(value="highlight_affix_num_tokens")
    private Integer highlightAffixNumTokens = null;
    @JsonProperty(value="highlight_start_tag")
    private String highlightStartTag = null;
    @JsonProperty(value="highlight_end_tag")
    private String highlightEndTag = null;
    @JsonProperty(value="enable_highlight_v1")
    private Boolean enableHighlightV1 = true;
    @JsonProperty(value="snippet_threshold")
    private Integer snippetThreshold = null;
    @JsonProperty(value="drop_tokens_threshold")
    private Integer dropTokensThreshold = null;
    @JsonProperty(value="drop_tokens_mode")
    private DropTokensMode dropTokensMode = null;
    @JsonProperty(value="typo_tokens_threshold")
    private Integer typoTokensThreshold = null;
    @JsonProperty(value="enable_typos_for_alpha_numerical_tokens")
    private Boolean enableTyposForAlphaNumericalTokens = null;
    @JsonProperty(value="filter_curated_hits")
    private Boolean filterCuratedHits = null;
    @JsonProperty(value="enable_synonyms")
    private Boolean enableSynonyms = null;
    @JsonProperty(value="synonym_prefix")
    private Boolean synonymPrefix = null;
    @JsonProperty(value="synonym_num_typos")
    private Integer synonymNumTypos = null;
    @JsonProperty(value="pinned_hits")
    private String pinnedHits = null;
    @JsonProperty(value="hidden_hits")
    private String hiddenHits = null;
    @JsonProperty(value="override_tags")
    private String overrideTags = null;
    @JsonProperty(value="highlight_fields")
    private String highlightFields = null;
    @JsonProperty(value="split_join_tokens")
    private String splitJoinTokens = null;
    @JsonProperty(value="pre_segmented_query")
    private Boolean preSegmentedQuery = null;
    @JsonProperty(value="preset")
    private String preset = null;
    @JsonProperty(value="enable_overrides")
    private Boolean enableOverrides = false;
    @JsonProperty(value="prioritize_exact_match")
    private Boolean prioritizeExactMatch = true;
    @JsonProperty(value="max_candidates")
    private Integer maxCandidates = null;
    @JsonProperty(value="prioritize_token_position")
    private Boolean prioritizeTokenPosition = false;
    @JsonProperty(value="prioritize_num_matching_fields")
    private Boolean prioritizeNumMatchingFields = true;
    @JsonProperty(value="enable_typos_for_numerical_tokens")
    private Boolean enableTyposForNumericalTokens = true;
    @JsonProperty(value="exhaustive_search")
    private Boolean exhaustiveSearch = null;
    @JsonProperty(value="search_cutoff_ms")
    private Integer searchCutoffMs = null;
    @JsonProperty(value="use_cache")
    private Boolean useCache = null;
    @JsonProperty(value="cache_ttl")
    private Integer cacheTtl = null;
    @JsonProperty(value="min_len_1typo")
    private Integer minLen1typo = null;
    @JsonProperty(value="min_len_2typo")
    private Integer minLen2typo = null;
    @JsonProperty(value="vector_query")
    private String vectorQuery = null;
    @JsonProperty(value="remote_embedding_timeout_ms")
    private Integer remoteEmbeddingTimeoutMs = null;
    @JsonProperty(value="remote_embedding_num_tries")
    private Integer remoteEmbeddingNumTries = null;
    @JsonProperty(value="facet_strategy")
    private String facetStrategy = null;
    @JsonProperty(value="stopwords")
    private String stopwords = null;
    @JsonProperty(value="facet_return_parent")
    private String facetReturnParent = null;
    @JsonProperty(value="voice_query")
    private String voiceQuery = null;
    @JsonProperty(value="conversation")
    private Boolean conversation = null;
    @JsonProperty(value="conversation_model_id")
    private String conversationModelId = null;
    @JsonProperty(value="conversation_id")
    private String conversationId = null;

    public SearchParameters q(String q) {
        this.q = q;
        return this;
    }

    @Schema(required=true, description="The query text to search for in the collection. Use * as the search string to return all documents. This is typically useful when used in conjunction with filter_by.")
    public String getQ() {
        return this.q;
    }

    public void setQ(String q) {
        this.q = q;
    }

    public SearchParameters queryBy(String queryBy) {
        this.queryBy = queryBy;
        return this;
    }

    @Schema(required=true, description="A list of `string` fields that should be queried against. Multiple fields are separated with a comma.")
    public String getQueryBy() {
        return this.queryBy;
    }

    public void setQueryBy(String queryBy) {
        this.queryBy = queryBy;
    }

    public SearchParameters queryByWeights(String queryByWeights) {
        this.queryByWeights = queryByWeights;
        return this;
    }

    @Schema(description="The relative weight to give each `query_by` field when ranking results. This can be used to boost fields in priority, when looking for matches. Multiple fields are separated with a comma.")
    public String getQueryByWeights() {
        return this.queryByWeights;
    }

    public void setQueryByWeights(String queryByWeights) {
        this.queryByWeights = queryByWeights;
    }

    public SearchParameters textMatchType(String textMatchType) {
        this.textMatchType = textMatchType;
        return this;
    }

    @Schema(description="In a multi-field matching context, this parameter determines how the representative text match score of a record is calculated. Possible values are max_score (default) or max_weight.")
    public String getTextMatchType() {
        return this.textMatchType;
    }

    public void setTextMatchType(String textMatchType) {
        this.textMatchType = textMatchType;
    }

    public SearchParameters prefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    @Schema(description="Boolean field to indicate that the last word in the query should be treated as a prefix, and not as a whole word. This is used for building autocomplete and instant search interfaces. Defaults to true.")
    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public SearchParameters infix(String infix) {
        this.infix = infix;
        return this;
    }

    @Schema(description="If infix index is enabled for this field, infix searching can be done on a per-field basis by sending a comma separated string parameter called infix to the search query. This parameter can have 3 values; `off` infix search is disabled, which is default `always` infix search is performed along with regular search `fallback` infix search is performed if regular search does not produce results")
    public String getInfix() {
        return this.infix;
    }

    public void setInfix(String infix) {
        this.infix = infix;
    }

    public SearchParameters maxExtraPrefix(Integer maxExtraPrefix) {
        this.maxExtraPrefix = maxExtraPrefix;
        return this;
    }

    @Schema(description="There are also 2 parameters that allow you to control the extent of infix searching max_extra_prefix and max_extra_suffix which specify the maximum number of symbols before or after the query that can be present in the token. For example query \"K2100\" has 2 extra symbols in \"6PK2100\". By default, any number of prefixes/suffixes can be present for a match.")
    public Integer getMaxExtraPrefix() {
        return this.maxExtraPrefix;
    }

    public void setMaxExtraPrefix(Integer maxExtraPrefix) {
        this.maxExtraPrefix = maxExtraPrefix;
    }

    public SearchParameters maxExtraSuffix(Integer maxExtraSuffix) {
        this.maxExtraSuffix = maxExtraSuffix;
        return this;
    }

    @Schema(description="There are also 2 parameters that allow you to control the extent of infix searching max_extra_prefix and max_extra_suffix which specify the maximum number of symbols before or after the query that can be present in the token. For example query \"K2100\" has 2 extra symbols in \"6PK2100\". By default, any number of prefixes/suffixes can be present for a match.")
    public Integer getMaxExtraSuffix() {
        return this.maxExtraSuffix;
    }

    public void setMaxExtraSuffix(Integer maxExtraSuffix) {
        this.maxExtraSuffix = maxExtraSuffix;
    }

    public SearchParameters filterBy(String filterBy) {
        this.filterBy = filterBy;
        return this;
    }

    @Schema(example="num_employees:>100 && country: [USA, UK]", description="Filter conditions for refining youropen api validator search results. Separate multiple conditions with &&.")
    public String getFilterBy() {
        return this.filterBy;
    }

    public void setFilterBy(String filterBy) {
        this.filterBy = filterBy;
    }

    public SearchParameters sortBy(String sortBy) {
        this.sortBy = sortBy;
        return this;
    }

    @Schema(example="num_employees:desc", description="A list of numerical fields and their corresponding sort orders that will be used for ordering your results. Up to 3 sort fields can be specified. The text similarity score is exposed as a special `_text_match` field that you can use in the list of sorting fields. If no `sort_by` parameter is specified, results are sorted by `_text_match:desc,default_sorting_field:desc`")
    public String getSortBy() {
        return this.sortBy;
    }

    public void setSortBy(String sortBy) {
        this.sortBy = sortBy;
    }

    public SearchParameters facetBy(String facetBy) {
        this.facetBy = facetBy;
        return this;
    }

    @Schema(description="A list of fields that will be used for faceting your results on. Separate multiple fields with a comma.")
    public String getFacetBy() {
        return this.facetBy;
    }

    public void setFacetBy(String facetBy) {
        this.facetBy = facetBy;
    }

    public SearchParameters maxFacetValues(Integer maxFacetValues) {
        this.maxFacetValues = maxFacetValues;
        return this;
    }

    @Schema(description="Maximum number of facet values to be returned.")
    public Integer getMaxFacetValues() {
        return this.maxFacetValues;
    }

    public void setMaxFacetValues(Integer maxFacetValues) {
        this.maxFacetValues = maxFacetValues;
    }

    public SearchParameters facetQuery(String facetQuery) {
        this.facetQuery = facetQuery;
        return this;
    }

    @Schema(description="Facet values that are returned can now be filtered via this parameter. The matching facet text is also highlighted. For example, when faceting by `category`, you can set `facet_query=category:shoe` to return only facet values that contain the prefix \"shoe\".")
    public String getFacetQuery() {
        return this.facetQuery;
    }

    public void setFacetQuery(String facetQuery) {
        this.facetQuery = facetQuery;
    }

    public SearchParameters numTypos(String numTypos) {
        this.numTypos = numTypos;
        return this;
    }

    @Schema(description="The number of typographical errors (1 or 2) that would be tolerated. Default: 2 ")
    public String getNumTypos() {
        return this.numTypos;
    }

    public void setNumTypos(String numTypos) {
        this.numTypos = numTypos;
    }

    public SearchParameters page(Integer page) {
        this.page = page;
        return this;
    }

    @Schema(description="Results from this specific page number would be fetched.")
    public Integer getPage() {
        return this.page;
    }

    public void setPage(Integer page) {
        this.page = page;
    }

    public SearchParameters perPage(Integer perPage) {
        this.perPage = perPage;
        return this;
    }

    @Schema(description="Number of results to fetch per page. Default: 10")
    public Integer getPerPage() {
        return this.perPage;
    }

    public void setPerPage(Integer perPage) {
        this.perPage = perPage;
    }

    public SearchParameters limit(Integer limit) {
        this.limit = limit;
        return this;
    }

    @Schema(description="Number of hits to fetch. Can be used as an alternative to the per_page parameter. Default: 10. ")
    public Integer getLimit() {
        return this.limit;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public SearchParameters offset(Integer offset) {
        this.offset = offset;
        return this;
    }

    @Schema(description="Identifies the starting point to return hits from a result set. Can be used as an alternative to the page parameter.")
    public Integer getOffset() {
        return this.offset;
    }

    public void setOffset(Integer offset) {
        this.offset = offset;
    }

    public SearchParameters groupBy(String groupBy) {
        this.groupBy = groupBy;
        return this;
    }

    @Schema(description="You can aggregate search results into groups or buckets by specify one or more `group_by` fields. Separate multiple fields with a comma. To group on a particular field, it must be a faceted field.")
    public String getGroupBy() {
        return this.groupBy;
    }

    public void setGroupBy(String groupBy) {
        this.groupBy = groupBy;
    }

    public SearchParameters groupLimit(Integer groupLimit) {
        this.groupLimit = groupLimit;
        return this;
    }

    @Schema(description="Maximum number of hits to be returned for every group. If the `group_limit` is set as `K` then only the top K hits in each group are returned in the response. Default: 3 ")
    public Integer getGroupLimit() {
        return this.groupLimit;
    }

    public void setGroupLimit(Integer groupLimit) {
        this.groupLimit = groupLimit;
    }

    public SearchParameters groupMissingValues(Boolean groupMissingValues) {
        this.groupMissingValues = groupMissingValues;
        return this;
    }

    @Schema(description="Setting this parameter to true will place all documents that have a null value in the group_by field, into a single group. Setting this parameter to false, will cause each document with a null value in the group_by field to not be grouped with other documents. Default: true ")
    public Boolean isGroupMissingValues() {
        return this.groupMissingValues;
    }

    public void setGroupMissingValues(Boolean groupMissingValues) {
        this.groupMissingValues = groupMissingValues;
    }

    public SearchParameters includeFields(String includeFields) {
        this.includeFields = includeFields;
        return this;
    }

    @Schema(description="List of fields from the document to include in the search result")
    public String getIncludeFields() {
        return this.includeFields;
    }

    public void setIncludeFields(String includeFields) {
        this.includeFields = includeFields;
    }

    public SearchParameters excludeFields(String excludeFields) {
        this.excludeFields = excludeFields;
        return this;
    }

    @Schema(description="List of fields from the document to exclude in the search result")
    public String getExcludeFields() {
        return this.excludeFields;
    }

    public void setExcludeFields(String excludeFields) {
        this.excludeFields = excludeFields;
    }

    public SearchParameters highlightFullFields(String highlightFullFields) {
        this.highlightFullFields = highlightFullFields;
        return this;
    }

    @Schema(description="List of fields which should be highlighted fully without snippeting")
    public String getHighlightFullFields() {
        return this.highlightFullFields;
    }

    public void setHighlightFullFields(String highlightFullFields) {
        this.highlightFullFields = highlightFullFields;
    }

    public SearchParameters highlightAffixNumTokens(Integer highlightAffixNumTokens) {
        this.highlightAffixNumTokens = highlightAffixNumTokens;
        return this;
    }

    @Schema(description="The number of tokens that should surround the highlighted text on each side. Default: 4 ")
    public Integer getHighlightAffixNumTokens() {
        return this.highlightAffixNumTokens;
    }

    public void setHighlightAffixNumTokens(Integer highlightAffixNumTokens) {
        this.highlightAffixNumTokens = highlightAffixNumTokens;
    }

    public SearchParameters highlightStartTag(String highlightStartTag) {
        this.highlightStartTag = highlightStartTag;
        return this;
    }

    @Schema(description="The start tag used for the highlighted snippets. Default: `<mark>` ")
    public String getHighlightStartTag() {
        return this.highlightStartTag;
    }

    public void setHighlightStartTag(String highlightStartTag) {
        this.highlightStartTag = highlightStartTag;
    }

    public SearchParameters highlightEndTag(String highlightEndTag) {
        this.highlightEndTag = highlightEndTag;
        return this;
    }

    @Schema(description="The end tag used for the highlighted snippets. Default: `</mark>` ")
    public String getHighlightEndTag() {
        return this.highlightEndTag;
    }

    public void setHighlightEndTag(String highlightEndTag) {
        this.highlightEndTag = highlightEndTag;
    }

    public SearchParameters enableHighlightV1(Boolean enableHighlightV1) {
        this.enableHighlightV1 = enableHighlightV1;
        return this;
    }

    @Schema(description="Flag for enabling/disabling the deprecated, old highlight structure in the response. Default: true ")
    public Boolean isEnableHighlightV1() {
        return this.enableHighlightV1;
    }

    public void setEnableHighlightV1(Boolean enableHighlightV1) {
        this.enableHighlightV1 = enableHighlightV1;
    }

    public SearchParameters snippetThreshold(Integer snippetThreshold) {
        this.snippetThreshold = snippetThreshold;
        return this;
    }

    @Schema(description="Field values under this length will be fully highlighted, instead of showing a snippet of relevant portion. Default: 30 ")
    public Integer getSnippetThreshold() {
        return this.snippetThreshold;
    }

    public void setSnippetThreshold(Integer snippetThreshold) {
        this.snippetThreshold = snippetThreshold;
    }

    public SearchParameters dropTokensThreshold(Integer dropTokensThreshold) {
        this.dropTokensThreshold = dropTokensThreshold;
        return this;
    }

    @Schema(description="If the number of results found for a specific query is less than this number, Typesense will attempt to drop the tokens in the query until enough results are found. Tokens that have the least individual hits are dropped first. Set to 0 to disable. Default: 10 ")
    public Integer getDropTokensThreshold() {
        return this.dropTokensThreshold;
    }

    public void setDropTokensThreshold(Integer dropTokensThreshold) {
        this.dropTokensThreshold = dropTokensThreshold;
    }

    public SearchParameters dropTokensMode(DropTokensMode dropTokensMode) {
        this.dropTokensMode = dropTokensMode;
        return this;
    }

    @Schema(description="")
    public DropTokensMode getDropTokensMode() {
        return this.dropTokensMode;
    }

    public void setDropTokensMode(DropTokensMode dropTokensMode) {
        this.dropTokensMode = dropTokensMode;
    }

    public SearchParameters typoTokensThreshold(Integer typoTokensThreshold) {
        this.typoTokensThreshold = typoTokensThreshold;
        return this;
    }

    @Schema(description="If the number of results found for a specific query is less than this number, Typesense will attempt to look for tokens with more typos until enough results are found. Default: 100 ")
    public Integer getTypoTokensThreshold() {
        return this.typoTokensThreshold;
    }

    public void setTypoTokensThreshold(Integer typoTokensThreshold) {
        this.typoTokensThreshold = typoTokensThreshold;
    }

    public SearchParameters enableTyposForAlphaNumericalTokens(Boolean enableTyposForAlphaNumericalTokens) {
        this.enableTyposForAlphaNumericalTokens = enableTyposForAlphaNumericalTokens;
        return this;
    }

    @Schema(description="Set this parameter to false to disable typos on alphanumerical query tokens. Default: true. ")
    public Boolean isEnableTyposForAlphaNumericalTokens() {
        return this.enableTyposForAlphaNumericalTokens;
    }

    public void setEnableTyposForAlphaNumericalTokens(Boolean enableTyposForAlphaNumericalTokens) {
        this.enableTyposForAlphaNumericalTokens = enableTyposForAlphaNumericalTokens;
    }

    public SearchParameters filterCuratedHits(Boolean filterCuratedHits) {
        this.filterCuratedHits = filterCuratedHits;
        return this;
    }

    @Schema(description="Whether the filter_by condition of the search query should be applicable to curated results (override definitions, pinned hits, hidden hits, etc.). Default: false ")
    public Boolean isFilterCuratedHits() {
        return this.filterCuratedHits;
    }

    public void setFilterCuratedHits(Boolean filterCuratedHits) {
        this.filterCuratedHits = filterCuratedHits;
    }

    public SearchParameters enableSynonyms(Boolean enableSynonyms) {
        this.enableSynonyms = enableSynonyms;
        return this;
    }

    @Schema(description="If you have some synonyms defined but want to disable all of them for a particular search query, set enable_synonyms to false. Default: true ")
    public Boolean isEnableSynonyms() {
        return this.enableSynonyms;
    }

    public void setEnableSynonyms(Boolean enableSynonyms) {
        this.enableSynonyms = enableSynonyms;
    }

    public SearchParameters synonymPrefix(Boolean synonymPrefix) {
        this.synonymPrefix = synonymPrefix;
        return this;
    }

    @Schema(description="Allow synonym resolution on word prefixes in the query. Default: false ")
    public Boolean isSynonymPrefix() {
        return this.synonymPrefix;
    }

    public void setSynonymPrefix(Boolean synonymPrefix) {
        this.synonymPrefix = synonymPrefix;
    }

    public SearchParameters synonymNumTypos(Integer synonymNumTypos) {
        this.synonymNumTypos = synonymNumTypos;
        return this;
    }

    @Schema(description="Allow synonym resolution on typo-corrected words in the query. Default: 0 ")
    public Integer getSynonymNumTypos() {
        return this.synonymNumTypos;
    }

    public void setSynonymNumTypos(Integer synonymNumTypos) {
        this.synonymNumTypos = synonymNumTypos;
    }

    public SearchParameters pinnedHits(String pinnedHits) {
        this.pinnedHits = pinnedHits;
        return this;
    }

    @Schema(description="A list of records to unconditionally include in the search results at specific positions. An example use case would be to feature or promote certain items on the top of search results. A list of `record_id:hit_position`. Eg: to include a record with ID 123 at Position 1 and another record with ID 456 at Position 5, you'd specify `123:1,456:5`. You could also use the Overrides feature to override search results based on rules. Overrides are applied first, followed by `pinned_hits` and finally `hidden_hits`. ")
    public String getPinnedHits() {
        return this.pinnedHits;
    }

    public void setPinnedHits(String pinnedHits) {
        this.pinnedHits = pinnedHits;
    }

    public SearchParameters hiddenHits(String hiddenHits) {
        this.hiddenHits = hiddenHits;
        return this;
    }

    @Schema(description="A list of records to unconditionally hide from search results. A list of `record_id`s to hide. Eg: to hide records with IDs 123 and 456, you'd specify `123,456`. You could also use the Overrides feature to override search results based on rules. Overrides are applied first, followed by `pinned_hits` and finally `hidden_hits`. ")
    public String getHiddenHits() {
        return this.hiddenHits;
    }

    public void setHiddenHits(String hiddenHits) {
        this.hiddenHits = hiddenHits;
    }

    public SearchParameters overrideTags(String overrideTags) {
        this.overrideTags = overrideTags;
        return this;
    }

    @Schema(description="Comma separated list of tags to trigger the curations rules that match the tags.")
    public String getOverrideTags() {
        return this.overrideTags;
    }

    public void setOverrideTags(String overrideTags) {
        this.overrideTags = overrideTags;
    }

    public SearchParameters highlightFields(String highlightFields) {
        this.highlightFields = highlightFields;
        return this;
    }

    @Schema(description="A list of custom fields that must be highlighted even if you don't query for them ")
    public String getHighlightFields() {
        return this.highlightFields;
    }

    public void setHighlightFields(String highlightFields) {
        this.highlightFields = highlightFields;
    }

    public SearchParameters splitJoinTokens(String splitJoinTokens) {
        this.splitJoinTokens = splitJoinTokens;
        return this;
    }

    @Schema(description="Treat space as typo: search for q=basket ball if q=basketball is not found or vice-versa. Splitting/joining of tokens will only be attempted if the original query produces no results. To always trigger this behavior, set value to `always``. To disable, set value to `off`. Default is `fallback`. ")
    public String getSplitJoinTokens() {
        return this.splitJoinTokens;
    }

    public void setSplitJoinTokens(String splitJoinTokens) {
        this.splitJoinTokens = splitJoinTokens;
    }

    public SearchParameters preSegmentedQuery(Boolean preSegmentedQuery) {
        this.preSegmentedQuery = preSegmentedQuery;
        return this;
    }

    @Schema(description="You can index content from any logographic language into Typesense if you are able to segment / split the text into space-separated words yourself before indexing and querying. Set this parameter to true to do the same ")
    public Boolean isPreSegmentedQuery() {
        return this.preSegmentedQuery;
    }

    public void setPreSegmentedQuery(Boolean preSegmentedQuery) {
        this.preSegmentedQuery = preSegmentedQuery;
    }

    public SearchParameters preset(String preset) {
        this.preset = preset;
        return this;
    }

    @Schema(description="Search using a bunch of search parameters by setting this parameter to the name of the existing Preset. ")
    public String getPreset() {
        return this.preset;
    }

    public void setPreset(String preset) {
        this.preset = preset;
    }

    public SearchParameters enableOverrides(Boolean enableOverrides) {
        this.enableOverrides = enableOverrides;
        return this;
    }

    @Schema(description="If you have some overrides defined but want to disable all of them during query time, you can do that by setting this parameter to false ")
    public Boolean isEnableOverrides() {
        return this.enableOverrides;
    }

    public void setEnableOverrides(Boolean enableOverrides) {
        this.enableOverrides = enableOverrides;
    }

    public SearchParameters prioritizeExactMatch(Boolean prioritizeExactMatch) {
        this.prioritizeExactMatch = prioritizeExactMatch;
        return this;
    }

    @Schema(description="Set this parameter to true to ensure that an exact match is ranked above the others ")
    public Boolean isPrioritizeExactMatch() {
        return this.prioritizeExactMatch;
    }

    public void setPrioritizeExactMatch(Boolean prioritizeExactMatch) {
        this.prioritizeExactMatch = prioritizeExactMatch;
    }

    public SearchParameters maxCandidates(Integer maxCandidates) {
        this.maxCandidates = maxCandidates;
        return this;
    }

    @Schema(description="Control the number of words that Typesense considers for typo and prefix searching. ")
    public Integer getMaxCandidates() {
        return this.maxCandidates;
    }

    public void setMaxCandidates(Integer maxCandidates) {
        this.maxCandidates = maxCandidates;
    }

    public SearchParameters prioritizeTokenPosition(Boolean prioritizeTokenPosition) {
        this.prioritizeTokenPosition = prioritizeTokenPosition;
        return this;
    }

    @Schema(description="Make Typesense prioritize documents where the query words appear earlier in the text. ")
    public Boolean isPrioritizeTokenPosition() {
        return this.prioritizeTokenPosition;
    }

    public void setPrioritizeTokenPosition(Boolean prioritizeTokenPosition) {
        this.prioritizeTokenPosition = prioritizeTokenPosition;
    }

    public SearchParameters prioritizeNumMatchingFields(Boolean prioritizeNumMatchingFields) {
        this.prioritizeNumMatchingFields = prioritizeNumMatchingFields;
        return this;
    }

    @Schema(description="Make Typesense prioritize documents where the query words appear in more number of fields. ")
    public Boolean isPrioritizeNumMatchingFields() {
        return this.prioritizeNumMatchingFields;
    }

    public void setPrioritizeNumMatchingFields(Boolean prioritizeNumMatchingFields) {
        this.prioritizeNumMatchingFields = prioritizeNumMatchingFields;
    }

    public SearchParameters enableTyposForNumericalTokens(Boolean enableTyposForNumericalTokens) {
        this.enableTyposForNumericalTokens = enableTyposForNumericalTokens;
        return this;
    }

    @Schema(description="Make Typesense disable typos for numerical tokens. ")
    public Boolean isEnableTyposForNumericalTokens() {
        return this.enableTyposForNumericalTokens;
    }

    public void setEnableTyposForNumericalTokens(Boolean enableTyposForNumericalTokens) {
        this.enableTyposForNumericalTokens = enableTyposForNumericalTokens;
    }

    public SearchParameters exhaustiveSearch(Boolean exhaustiveSearch) {
        this.exhaustiveSearch = exhaustiveSearch;
        return this;
    }

    @Schema(description="Setting this to true will make Typesense consider all prefixes and typo corrections of the words in the query without stopping early when enough results are found (drop_tokens_threshold and typo_tokens_threshold configurations are ignored). ")
    public Boolean isExhaustiveSearch() {
        return this.exhaustiveSearch;
    }

    public void setExhaustiveSearch(Boolean exhaustiveSearch) {
        this.exhaustiveSearch = exhaustiveSearch;
    }

    public SearchParameters searchCutoffMs(Integer searchCutoffMs) {
        this.searchCutoffMs = searchCutoffMs;
        return this;
    }

    @Schema(description="Typesense will attempt to return results early if the cutoff time has elapsed. This is not a strict guarantee and facet computation is not bound by this parameter. ")
    public Integer getSearchCutoffMs() {
        return this.searchCutoffMs;
    }

    public void setSearchCutoffMs(Integer searchCutoffMs) {
        this.searchCutoffMs = searchCutoffMs;
    }

    public SearchParameters useCache(Boolean useCache) {
        this.useCache = useCache;
        return this;
    }

    @Schema(description="Enable server side caching of search query results. By default, caching is disabled. ")
    public Boolean isUseCache() {
        return this.useCache;
    }

    public void setUseCache(Boolean useCache) {
        this.useCache = useCache;
    }

    public SearchParameters cacheTtl(Integer cacheTtl) {
        this.cacheTtl = cacheTtl;
        return this;
    }

    @Schema(description="The duration (in seconds) that determines how long the search query is cached. This value can be set on a per-query basis. Default: 60. ")
    public Integer getCacheTtl() {
        return this.cacheTtl;
    }

    public void setCacheTtl(Integer cacheTtl) {
        this.cacheTtl = cacheTtl;
    }

    public SearchParameters minLen1typo(Integer minLen1typo) {
        this.minLen1typo = minLen1typo;
        return this;
    }

    @Schema(description="Minimum word length for 1-typo correction to be applied. The value of num_typos is still treated as the maximum allowed typos. ")
    public Integer getMinLen1typo() {
        return this.minLen1typo;
    }

    public void setMinLen1typo(Integer minLen1typo) {
        this.minLen1typo = minLen1typo;
    }

    public SearchParameters minLen2typo(Integer minLen2typo) {
        this.minLen2typo = minLen2typo;
        return this;
    }

    @Schema(description="Minimum word length for 2-typo correction to be applied. The value of num_typos is still treated as the maximum allowed typos. ")
    public Integer getMinLen2typo() {
        return this.minLen2typo;
    }

    public void setMinLen2typo(Integer minLen2typo) {
        this.minLen2typo = minLen2typo;
    }

    public SearchParameters vectorQuery(String vectorQuery) {
        this.vectorQuery = vectorQuery;
        return this;
    }

    @Schema(description="Vector query expression for fetching documents \"closest\" to a given query/document vector. ")
    public String getVectorQuery() {
        return this.vectorQuery;
    }

    public void setVectorQuery(String vectorQuery) {
        this.vectorQuery = vectorQuery;
    }

    public SearchParameters remoteEmbeddingTimeoutMs(Integer remoteEmbeddingTimeoutMs) {
        this.remoteEmbeddingTimeoutMs = remoteEmbeddingTimeoutMs;
        return this;
    }

    @Schema(description="Timeout (in milliseconds) for fetching remote embeddings. ")
    public Integer getRemoteEmbeddingTimeoutMs() {
        return this.remoteEmbeddingTimeoutMs;
    }

    public void setRemoteEmbeddingTimeoutMs(Integer remoteEmbeddingTimeoutMs) {
        this.remoteEmbeddingTimeoutMs = remoteEmbeddingTimeoutMs;
    }

    public SearchParameters remoteEmbeddingNumTries(Integer remoteEmbeddingNumTries) {
        this.remoteEmbeddingNumTries = remoteEmbeddingNumTries;
        return this;
    }

    @Schema(description="Number of times to retry fetching remote embeddings. ")
    public Integer getRemoteEmbeddingNumTries() {
        return this.remoteEmbeddingNumTries;
    }

    public void setRemoteEmbeddingNumTries(Integer remoteEmbeddingNumTries) {
        this.remoteEmbeddingNumTries = remoteEmbeddingNumTries;
    }

    public SearchParameters facetStrategy(String facetStrategy) {
        this.facetStrategy = facetStrategy;
        return this;
    }

    @Schema(description="Choose the underlying faceting strategy used. Comma separated string of allows values: exhaustive, top_values or automatic (default). ")
    public String getFacetStrategy() {
        return this.facetStrategy;
    }

    public void setFacetStrategy(String facetStrategy) {
        this.facetStrategy = facetStrategy;
    }

    public SearchParameters stopwords(String stopwords) {
        this.stopwords = stopwords;
        return this;
    }

    @Schema(description="Name of the stopwords set to apply for this search, the keywords present in the set will be removed from the search query. ")
    public String getStopwords() {
        return this.stopwords;
    }

    public void setStopwords(String stopwords) {
        this.stopwords = stopwords;
    }

    public SearchParameters facetReturnParent(String facetReturnParent) {
        this.facetReturnParent = facetReturnParent;
        return this;
    }

    @Schema(description="Comma separated string of nested facet fields whose parent object should be returned in facet response. ")
    public String getFacetReturnParent() {
        return this.facetReturnParent;
    }

    public void setFacetReturnParent(String facetReturnParent) {
        this.facetReturnParent = facetReturnParent;
    }

    public SearchParameters voiceQuery(String voiceQuery) {
        this.voiceQuery = voiceQuery;
        return this;
    }

    @Schema(description="The base64 encoded audio file in 16 khz 16-bit WAV format. ")
    public String getVoiceQuery() {
        return this.voiceQuery;
    }

    public void setVoiceQuery(String voiceQuery) {
        this.voiceQuery = voiceQuery;
    }

    public SearchParameters conversation(Boolean conversation) {
        this.conversation = conversation;
        return this;
    }

    @Schema(description="Enable conversational search. ")
    public Boolean isConversation() {
        return this.conversation;
    }

    public void setConversation(Boolean conversation) {
        this.conversation = conversation;
    }

    public SearchParameters conversationModelId(String conversationModelId) {
        this.conversationModelId = conversationModelId;
        return this;
    }

    @Schema(description="The Id of Conversation Model to be used. ")
    public String getConversationModelId() {
        return this.conversationModelId;
    }

    public void setConversationModelId(String conversationModelId) {
        this.conversationModelId = conversationModelId;
    }

    public SearchParameters conversationId(String conversationId) {
        this.conversationId = conversationId;
        return this;
    }

    @Schema(description="The Id of a previous conversation to continue, this tells Typesense to include prior context when communicating with the LLM. ")
    public String getConversationId() {
        return this.conversationId;
    }

    public void setConversationId(String conversationId) {
        this.conversationId = conversationId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SearchParameters searchParameters = (SearchParameters)o;
        return Objects.equals(this.q, searchParameters.q) && Objects.equals(this.queryBy, searchParameters.queryBy) && Objects.equals(this.queryByWeights, searchParameters.queryByWeights) && Objects.equals(this.textMatchType, searchParameters.textMatchType) && Objects.equals(this.prefix, searchParameters.prefix) && Objects.equals(this.infix, searchParameters.infix) && Objects.equals(this.maxExtraPrefix, searchParameters.maxExtraPrefix) && Objects.equals(this.maxExtraSuffix, searchParameters.maxExtraSuffix) && Objects.equals(this.filterBy, searchParameters.filterBy) && Objects.equals(this.sortBy, searchParameters.sortBy) && Objects.equals(this.facetBy, searchParameters.facetBy) && Objects.equals(this.maxFacetValues, searchParameters.maxFacetValues) && Objects.equals(this.facetQuery, searchParameters.facetQuery) && Objects.equals(this.numTypos, searchParameters.numTypos) && Objects.equals(this.page, searchParameters.page) && Objects.equals(this.perPage, searchParameters.perPage) && Objects.equals(this.limit, searchParameters.limit) && Objects.equals(this.offset, searchParameters.offset) && Objects.equals(this.groupBy, searchParameters.groupBy) && Objects.equals(this.groupLimit, searchParameters.groupLimit) && Objects.equals(this.groupMissingValues, searchParameters.groupMissingValues) && Objects.equals(this.includeFields, searchParameters.includeFields) && Objects.equals(this.excludeFields, searchParameters.excludeFields) && Objects.equals(this.highlightFullFields, searchParameters.highlightFullFields) && Objects.equals(this.highlightAffixNumTokens, searchParameters.highlightAffixNumTokens) && Objects.equals(this.highlightStartTag, searchParameters.highlightStartTag) && Objects.equals(this.highlightEndTag, searchParameters.highlightEndTag) && Objects.equals(this.enableHighlightV1, searchParameters.enableHighlightV1) && Objects.equals(this.snippetThreshold, searchParameters.snippetThreshold) && Objects.equals(this.dropTokensThreshold, searchParameters.dropTokensThreshold) && Objects.equals((Object)this.dropTokensMode, (Object)searchParameters.dropTokensMode) && Objects.equals(this.typoTokensThreshold, searchParameters.typoTokensThreshold) && Objects.equals(this.enableTyposForAlphaNumericalTokens, searchParameters.enableTyposForAlphaNumericalTokens) && Objects.equals(this.filterCuratedHits, searchParameters.filterCuratedHits) && Objects.equals(this.enableSynonyms, searchParameters.enableSynonyms) && Objects.equals(this.synonymPrefix, searchParameters.synonymPrefix) && Objects.equals(this.synonymNumTypos, searchParameters.synonymNumTypos) && Objects.equals(this.pinnedHits, searchParameters.pinnedHits) && Objects.equals(this.hiddenHits, searchParameters.hiddenHits) && Objects.equals(this.overrideTags, searchParameters.overrideTags) && Objects.equals(this.highlightFields, searchParameters.highlightFields) && Objects.equals(this.splitJoinTokens, searchParameters.splitJoinTokens) && Objects.equals(this.preSegmentedQuery, searchParameters.preSegmentedQuery) && Objects.equals(this.preset, searchParameters.preset) && Objects.equals(this.enableOverrides, searchParameters.enableOverrides) && Objects.equals(this.prioritizeExactMatch, searchParameters.prioritizeExactMatch) && Objects.equals(this.maxCandidates, searchParameters.maxCandidates) && Objects.equals(this.prioritizeTokenPosition, searchParameters.prioritizeTokenPosition) && Objects.equals(this.prioritizeNumMatchingFields, searchParameters.prioritizeNumMatchingFields) && Objects.equals(this.enableTyposForNumericalTokens, searchParameters.enableTyposForNumericalTokens) && Objects.equals(this.exhaustiveSearch, searchParameters.exhaustiveSearch) && Objects.equals(this.searchCutoffMs, searchParameters.searchCutoffMs) && Objects.equals(this.useCache, searchParameters.useCache) && Objects.equals(this.cacheTtl, searchParameters.cacheTtl) && Objects.equals(this.minLen1typo, searchParameters.minLen1typo) && Objects.equals(this.minLen2typo, searchParameters.minLen2typo) && Objects.equals(this.vectorQuery, searchParameters.vectorQuery) && Objects.equals(this.remoteEmbeddingTimeoutMs, searchParameters.remoteEmbeddingTimeoutMs) && Objects.equals(this.remoteEmbeddingNumTries, searchParameters.remoteEmbeddingNumTries) && Objects.equals(this.facetStrategy, searchParameters.facetStrategy) && Objects.equals(this.stopwords, searchParameters.stopwords) && Objects.equals(this.facetReturnParent, searchParameters.facetReturnParent) && Objects.equals(this.voiceQuery, searchParameters.voiceQuery) && Objects.equals(this.conversation, searchParameters.conversation) && Objects.equals(this.conversationModelId, searchParameters.conversationModelId) && Objects.equals(this.conversationId, searchParameters.conversationId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.q, this.queryBy, this.queryByWeights, this.textMatchType, this.prefix, this.infix, this.maxExtraPrefix, this.maxExtraSuffix, this.filterBy, this.sortBy, this.facetBy, this.maxFacetValues, this.facetQuery, this.numTypos, this.page, this.perPage, this.limit, this.offset, this.groupBy, this.groupLimit, this.groupMissingValues, this.includeFields, this.excludeFields, this.highlightFullFields, this.highlightAffixNumTokens, this.highlightStartTag, this.highlightEndTag, this.enableHighlightV1, this.snippetThreshold, this.dropTokensThreshold, this.dropTokensMode, this.typoTokensThreshold, this.enableTyposForAlphaNumericalTokens, this.filterCuratedHits, this.enableSynonyms, this.synonymPrefix, this.synonymNumTypos, this.pinnedHits, this.hiddenHits, this.overrideTags, this.highlightFields, this.splitJoinTokens, this.preSegmentedQuery, this.preset, this.enableOverrides, this.prioritizeExactMatch, this.maxCandidates, this.prioritizeTokenPosition, this.prioritizeNumMatchingFields, this.enableTyposForNumericalTokens, this.exhaustiveSearch, this.searchCutoffMs, this.useCache, this.cacheTtl, this.minLen1typo, this.minLen2typo, this.vectorQuery, this.remoteEmbeddingTimeoutMs, this.remoteEmbeddingNumTries, this.facetStrategy, this.stopwords, this.facetReturnParent, this.voiceQuery, this.conversation, this.conversationModelId, this.conversationId});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SearchParameters {\n");
        sb.append("    q: ").append(this.toIndentedString(this.q)).append("\n");
        sb.append("    queryBy: ").append(this.toIndentedString(this.queryBy)).append("\n");
        sb.append("    queryByWeights: ").append(this.toIndentedString(this.queryByWeights)).append("\n");
        sb.append("    textMatchType: ").append(this.toIndentedString(this.textMatchType)).append("\n");
        sb.append("    prefix: ").append(this.toIndentedString(this.prefix)).append("\n");
        sb.append("    infix: ").append(this.toIndentedString(this.infix)).append("\n");
        sb.append("    maxExtraPrefix: ").append(this.toIndentedString(this.maxExtraPrefix)).append("\n");
        sb.append("    maxExtraSuffix: ").append(this.toIndentedString(this.maxExtraSuffix)).append("\n");
        sb.append("    filterBy: ").append(this.toIndentedString(this.filterBy)).append("\n");
        sb.append("    sortBy: ").append(this.toIndentedString(this.sortBy)).append("\n");
        sb.append("    facetBy: ").append(this.toIndentedString(this.facetBy)).append("\n");
        sb.append("    maxFacetValues: ").append(this.toIndentedString(this.maxFacetValues)).append("\n");
        sb.append("    facetQuery: ").append(this.toIndentedString(this.facetQuery)).append("\n");
        sb.append("    numTypos: ").append(this.toIndentedString(this.numTypos)).append("\n");
        sb.append("    page: ").append(this.toIndentedString(this.page)).append("\n");
        sb.append("    perPage: ").append(this.toIndentedString(this.perPage)).append("\n");
        sb.append("    limit: ").append(this.toIndentedString(this.limit)).append("\n");
        sb.append("    offset: ").append(this.toIndentedString(this.offset)).append("\n");
        sb.append("    groupBy: ").append(this.toIndentedString(this.groupBy)).append("\n");
        sb.append("    groupLimit: ").append(this.toIndentedString(this.groupLimit)).append("\n");
        sb.append("    groupMissingValues: ").append(this.toIndentedString(this.groupMissingValues)).append("\n");
        sb.append("    includeFields: ").append(this.toIndentedString(this.includeFields)).append("\n");
        sb.append("    excludeFields: ").append(this.toIndentedString(this.excludeFields)).append("\n");
        sb.append("    highlightFullFields: ").append(this.toIndentedString(this.highlightFullFields)).append("\n");
        sb.append("    highlightAffixNumTokens: ").append(this.toIndentedString(this.highlightAffixNumTokens)).append("\n");
        sb.append("    highlightStartTag: ").append(this.toIndentedString(this.highlightStartTag)).append("\n");
        sb.append("    highlightEndTag: ").append(this.toIndentedString(this.highlightEndTag)).append("\n");
        sb.append("    enableHighlightV1: ").append(this.toIndentedString(this.enableHighlightV1)).append("\n");
        sb.append("    snippetThreshold: ").append(this.toIndentedString(this.snippetThreshold)).append("\n");
        sb.append("    dropTokensThreshold: ").append(this.toIndentedString(this.dropTokensThreshold)).append("\n");
        sb.append("    dropTokensMode: ").append(this.toIndentedString((Object)this.dropTokensMode)).append("\n");
        sb.append("    typoTokensThreshold: ").append(this.toIndentedString(this.typoTokensThreshold)).append("\n");
        sb.append("    enableTyposForAlphaNumericalTokens: ").append(this.toIndentedString(this.enableTyposForAlphaNumericalTokens)).append("\n");
        sb.append("    filterCuratedHits: ").append(this.toIndentedString(this.filterCuratedHits)).append("\n");
        sb.append("    enableSynonyms: ").append(this.toIndentedString(this.enableSynonyms)).append("\n");
        sb.append("    synonymPrefix: ").append(this.toIndentedString(this.synonymPrefix)).append("\n");
        sb.append("    synonymNumTypos: ").append(this.toIndentedString(this.synonymNumTypos)).append("\n");
        sb.append("    pinnedHits: ").append(this.toIndentedString(this.pinnedHits)).append("\n");
        sb.append("    hiddenHits: ").append(this.toIndentedString(this.hiddenHits)).append("\n");
        sb.append("    overrideTags: ").append(this.toIndentedString(this.overrideTags)).append("\n");
        sb.append("    highlightFields: ").append(this.toIndentedString(this.highlightFields)).append("\n");
        sb.append("    splitJoinTokens: ").append(this.toIndentedString(this.splitJoinTokens)).append("\n");
        sb.append("    preSegmentedQuery: ").append(this.toIndentedString(this.preSegmentedQuery)).append("\n");
        sb.append("    preset: ").append(this.toIndentedString(this.preset)).append("\n");
        sb.append("    enableOverrides: ").append(this.toIndentedString(this.enableOverrides)).append("\n");
        sb.append("    prioritizeExactMatch: ").append(this.toIndentedString(this.prioritizeExactMatch)).append("\n");
        sb.append("    maxCandidates: ").append(this.toIndentedString(this.maxCandidates)).append("\n");
        sb.append("    prioritizeTokenPosition: ").append(this.toIndentedString(this.prioritizeTokenPosition)).append("\n");
        sb.append("    prioritizeNumMatchingFields: ").append(this.toIndentedString(this.prioritizeNumMatchingFields)).append("\n");
        sb.append("    enableTyposForNumericalTokens: ").append(this.toIndentedString(this.enableTyposForNumericalTokens)).append("\n");
        sb.append("    exhaustiveSearch: ").append(this.toIndentedString(this.exhaustiveSearch)).append("\n");
        sb.append("    searchCutoffMs: ").append(this.toIndentedString(this.searchCutoffMs)).append("\n");
        sb.append("    useCache: ").append(this.toIndentedString(this.useCache)).append("\n");
        sb.append("    cacheTtl: ").append(this.toIndentedString(this.cacheTtl)).append("\n");
        sb.append("    minLen1typo: ").append(this.toIndentedString(this.minLen1typo)).append("\n");
        sb.append("    minLen2typo: ").append(this.toIndentedString(this.minLen2typo)).append("\n");
        sb.append("    vectorQuery: ").append(this.toIndentedString(this.vectorQuery)).append("\n");
        sb.append("    remoteEmbeddingTimeoutMs: ").append(this.toIndentedString(this.remoteEmbeddingTimeoutMs)).append("\n");
        sb.append("    remoteEmbeddingNumTries: ").append(this.toIndentedString(this.remoteEmbeddingNumTries)).append("\n");
        sb.append("    facetStrategy: ").append(this.toIndentedString(this.facetStrategy)).append("\n");
        sb.append("    stopwords: ").append(this.toIndentedString(this.stopwords)).append("\n");
        sb.append("    facetReturnParent: ").append(this.toIndentedString(this.facetReturnParent)).append("\n");
        sb.append("    voiceQuery: ").append(this.toIndentedString(this.voiceQuery)).append("\n");
        sb.append("    conversation: ").append(this.toIndentedString(this.conversation)).append("\n");
        sb.append("    conversationModelId: ").append(this.toIndentedString(this.conversationModelId)).append("\n");
        sb.append("    conversationId: ").append(this.toIndentedString(this.conversationId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

