/*
 * Decompiled with CFR 0.152.
 */
package org.typesense.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.typesense.model.FacetCounts;
import org.typesense.model.SearchGroupedHit;
import org.typesense.model.SearchResultConversation;
import org.typesense.model.SearchResultHit;
import org.typesense.model.SearchResultRequestParams;

public class SearchResult {
    @JsonProperty(value="facet_counts")
    private List<FacetCounts> facetCounts = null;
    @JsonProperty(value="found")
    private Integer found = null;
    @JsonProperty(value="found_docs")
    private Integer foundDocs = null;
    @JsonProperty(value="search_time_ms")
    private Integer searchTimeMs = null;
    @JsonProperty(value="out_of")
    private Integer outOf = null;
    @JsonProperty(value="search_cutoff")
    private Boolean searchCutoff = null;
    @JsonProperty(value="page")
    private Integer page = null;
    @JsonProperty(value="grouped_hits")
    private List<SearchGroupedHit> groupedHits = null;
    @JsonProperty(value="hits")
    private List<SearchResultHit> hits = null;
    @JsonProperty(value="request_params")
    private SearchResultRequestParams requestParams = null;
    @JsonProperty(value="conversation")
    private SearchResultConversation conversation = null;

    public SearchResult facetCounts(List<FacetCounts> facetCounts) {
        this.facetCounts = facetCounts;
        return this;
    }

    public SearchResult addFacetCountsItem(FacetCounts facetCountsItem) {
        if (this.facetCounts == null) {
            this.facetCounts = new ArrayList<FacetCounts>();
        }
        this.facetCounts.add(facetCountsItem);
        return this;
    }

    @Schema(description="")
    public List<FacetCounts> getFacetCounts() {
        return this.facetCounts;
    }

    public void setFacetCounts(List<FacetCounts> facetCounts) {
        this.facetCounts = facetCounts;
    }

    public SearchResult found(Integer found) {
        this.found = found;
        return this;
    }

    @Schema(description="The number of documents found")
    public Integer getFound() {
        return this.found;
    }

    public void setFound(Integer found) {
        this.found = found;
    }

    public SearchResult foundDocs(Integer foundDocs) {
        this.foundDocs = foundDocs;
        return this;
    }

    @Schema(description="")
    public Integer getFoundDocs() {
        return this.foundDocs;
    }

    public void setFoundDocs(Integer foundDocs) {
        this.foundDocs = foundDocs;
    }

    public SearchResult searchTimeMs(Integer searchTimeMs) {
        this.searchTimeMs = searchTimeMs;
        return this;
    }

    @Schema(description="The number of milliseconds the search took")
    public Integer getSearchTimeMs() {
        return this.searchTimeMs;
    }

    public void setSearchTimeMs(Integer searchTimeMs) {
        this.searchTimeMs = searchTimeMs;
    }

    public SearchResult outOf(Integer outOf) {
        this.outOf = outOf;
        return this;
    }

    @Schema(description="The total number of documents in the collection")
    public Integer getOutOf() {
        return this.outOf;
    }

    public void setOutOf(Integer outOf) {
        this.outOf = outOf;
    }

    public SearchResult searchCutoff(Boolean searchCutoff) {
        this.searchCutoff = searchCutoff;
        return this;
    }

    @Schema(description="Whether the search was cut off")
    public Boolean isSearchCutoff() {
        return this.searchCutoff;
    }

    public void setSearchCutoff(Boolean searchCutoff) {
        this.searchCutoff = searchCutoff;
    }

    public SearchResult page(Integer page) {
        this.page = page;
        return this;
    }

    @Schema(description="The search result page number")
    public Integer getPage() {
        return this.page;
    }

    public void setPage(Integer page) {
        this.page = page;
    }

    public SearchResult groupedHits(List<SearchGroupedHit> groupedHits) {
        this.groupedHits = groupedHits;
        return this;
    }

    public SearchResult addGroupedHitsItem(SearchGroupedHit groupedHitsItem) {
        if (this.groupedHits == null) {
            this.groupedHits = new ArrayList<SearchGroupedHit>();
        }
        this.groupedHits.add(groupedHitsItem);
        return this;
    }

    @Schema(description="")
    public List<SearchGroupedHit> getGroupedHits() {
        return this.groupedHits;
    }

    public void setGroupedHits(List<SearchGroupedHit> groupedHits) {
        this.groupedHits = groupedHits;
    }

    public SearchResult hits(List<SearchResultHit> hits) {
        this.hits = hits;
        return this;
    }

    public SearchResult addHitsItem(SearchResultHit hitsItem) {
        if (this.hits == null) {
            this.hits = new ArrayList<SearchResultHit>();
        }
        this.hits.add(hitsItem);
        return this;
    }

    @Schema(description="The documents that matched the search query")
    public List<SearchResultHit> getHits() {
        return this.hits;
    }

    public void setHits(List<SearchResultHit> hits) {
        this.hits = hits;
    }

    public SearchResult requestParams(SearchResultRequestParams requestParams) {
        this.requestParams = requestParams;
        return this;
    }

    @Schema(description="")
    public SearchResultRequestParams getRequestParams() {
        return this.requestParams;
    }

    public void setRequestParams(SearchResultRequestParams requestParams) {
        this.requestParams = requestParams;
    }

    public SearchResult conversation(SearchResultConversation conversation) {
        this.conversation = conversation;
        return this;
    }

    @Schema(description="")
    public SearchResultConversation getConversation() {
        return this.conversation;
    }

    public void setConversation(SearchResultConversation conversation) {
        this.conversation = conversation;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SearchResult searchResult = (SearchResult)o;
        return Objects.equals(this.facetCounts, searchResult.facetCounts) && Objects.equals(this.found, searchResult.found) && Objects.equals(this.foundDocs, searchResult.foundDocs) && Objects.equals(this.searchTimeMs, searchResult.searchTimeMs) && Objects.equals(this.outOf, searchResult.outOf) && Objects.equals(this.searchCutoff, searchResult.searchCutoff) && Objects.equals(this.page, searchResult.page) && Objects.equals(this.groupedHits, searchResult.groupedHits) && Objects.equals(this.hits, searchResult.hits) && Objects.equals(this.requestParams, searchResult.requestParams) && Objects.equals(this.conversation, searchResult.conversation);
    }

    public int hashCode() {
        return Objects.hash(this.facetCounts, this.found, this.foundDocs, this.searchTimeMs, this.outOf, this.searchCutoff, this.page, this.groupedHits, this.hits, this.requestParams, this.conversation);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SearchResult {\n");
        sb.append("    facetCounts: ").append(this.toIndentedString(this.facetCounts)).append("\n");
        sb.append("    found: ").append(this.toIndentedString(this.found)).append("\n");
        sb.append("    foundDocs: ").append(this.toIndentedString(this.foundDocs)).append("\n");
        sb.append("    searchTimeMs: ").append(this.toIndentedString(this.searchTimeMs)).append("\n");
        sb.append("    outOf: ").append(this.toIndentedString(this.outOf)).append("\n");
        sb.append("    searchCutoff: ").append(this.toIndentedString(this.searchCutoff)).append("\n");
        sb.append("    page: ").append(this.toIndentedString(this.page)).append("\n");
        sb.append("    groupedHits: ").append(this.toIndentedString(this.groupedHits)).append("\n");
        sb.append("    hits: ").append(this.toIndentedString(this.hits)).append("\n");
        sb.append("    requestParams: ").append(this.toIndentedString(this.requestParams)).append("\n");
        sb.append("    conversation: ").append(this.toIndentedString(this.conversation)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

