/*
 * Decompiled with CFR 0.152.
 */
package org.typesense.api;

import org.typesense.api.ApiCall;
import org.typesense.api.utils.URLEncoding;
import org.typesense.model.StopwordsSetSchema;
import org.typesense.model.StopwordsSetUpsertSchema;
import org.typesense.model.StopwordsSetsRetrieveAllSchema;

public class Stopwords {
    public static final String RESOURCEPATH = "/stopwords";
    private final ApiCall apiCall;

    public Stopwords(ApiCall apiCall) {
        this.apiCall = apiCall;
    }

    public StopwordsSetSchema upsert(String stopwordSetId, StopwordsSetUpsertSchema stopwordSet) throws Exception {
        return this.apiCall.put(this.getEndpoint(stopwordSetId), stopwordSet, null, StopwordsSetSchema.class);
    }

    public StopwordsSetsRetrieveAllSchema retrieve() throws Exception {
        return this.apiCall.get(RESOURCEPATH, null, StopwordsSetsRetrieveAllSchema.class);
    }

    private String getEndpoint(String stopwordSetId) {
        return "/stopwords/" + URLEncoding.encodeURIComponent(stopwordSetId);
    }
}

