/*
 * Decompiled with CFR 0.152.
 */
package org.typesense.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.typesense.model.SearchHighlight;
import org.typesense.model.SearchResultHitTextMatchInfo;

public class SearchResultHit {
    @JsonProperty(value="highlights")
    private List<SearchHighlight> highlights = null;
    @JsonProperty(value="highlight")
    private Map<String, Object> highlight = null;
    @JsonProperty(value="document")
    private Map<String, Object> document = null;
    @JsonProperty(value="text_match")
    private Long textMatch = null;
    @JsonProperty(value="text_match_info")
    private SearchResultHitTextMatchInfo textMatchInfo = null;
    @JsonProperty(value="geo_distance_meters")
    private Map<String, Integer> geoDistanceMeters = null;
    @JsonProperty(value="vector_distance")
    private Float vectorDistance = null;

    public SearchResultHit highlights(List<SearchHighlight> highlights) {
        this.highlights = highlights;
        return this;
    }

    public SearchResultHit addHighlightsItem(SearchHighlight highlightsItem) {
        if (this.highlights == null) {
            this.highlights = new ArrayList<SearchHighlight>();
        }
        this.highlights.add(highlightsItem);
        return this;
    }

    @Schema(description="(Deprecated) Contains highlighted portions of the search fields")
    public List<SearchHighlight> getHighlights() {
        return this.highlights;
    }

    public void setHighlights(List<SearchHighlight> highlights) {
        this.highlights = highlights;
    }

    public SearchResultHit highlight(Map<String, Object> highlight) {
        this.highlight = highlight;
        return this;
    }

    public SearchResultHit putHighlightItem(String key, Object highlightItem) {
        if (this.highlight == null) {
            this.highlight = new HashMap<String, Object>();
        }
        this.highlight.put(key, highlightItem);
        return this;
    }

    @Schema(description="Highlighted version of the matching document")
    public Map<String, Object> getHighlight() {
        return this.highlight;
    }

    public void setHighlight(Map<String, Object> highlight) {
        this.highlight = highlight;
    }

    public SearchResultHit document(Map<String, Object> document) {
        this.document = document;
        return this;
    }

    public SearchResultHit putDocumentItem(String key, Object documentItem) {
        if (this.document == null) {
            this.document = new HashMap<String, Object>();
        }
        this.document.put(key, documentItem);
        return this;
    }

    @Schema(description="Can be any key-value pair")
    public Map<String, Object> getDocument() {
        return this.document;
    }

    public void setDocument(Map<String, Object> document) {
        this.document = document;
    }

    public SearchResultHit textMatch(Long textMatch) {
        this.textMatch = textMatch;
        return this;
    }

    @Schema(description="")
    public Long getTextMatch() {
        return this.textMatch;
    }

    public void setTextMatch(Long textMatch) {
        this.textMatch = textMatch;
    }

    public SearchResultHit textMatchInfo(SearchResultHitTextMatchInfo textMatchInfo) {
        this.textMatchInfo = textMatchInfo;
        return this;
    }

    @Schema(description="")
    public SearchResultHitTextMatchInfo getTextMatchInfo() {
        return this.textMatchInfo;
    }

    public void setTextMatchInfo(SearchResultHitTextMatchInfo textMatchInfo) {
        this.textMatchInfo = textMatchInfo;
    }

    public SearchResultHit geoDistanceMeters(Map<String, Integer> geoDistanceMeters) {
        this.geoDistanceMeters = geoDistanceMeters;
        return this;
    }

    public SearchResultHit putGeoDistanceMetersItem(String key, Integer geoDistanceMetersItem) {
        if (this.geoDistanceMeters == null) {
            this.geoDistanceMeters = new HashMap<String, Integer>();
        }
        this.geoDistanceMeters.put(key, geoDistanceMetersItem);
        return this;
    }

    @Schema(description="Can be any key-value pair")
    public Map<String, Integer> getGeoDistanceMeters() {
        return this.geoDistanceMeters;
    }

    public void setGeoDistanceMeters(Map<String, Integer> geoDistanceMeters) {
        this.geoDistanceMeters = geoDistanceMeters;
    }

    public SearchResultHit vectorDistance(Float vectorDistance) {
        this.vectorDistance = vectorDistance;
        return this;
    }

    @Schema(description="Distance between the query vector and matching document's vector value")
    public Float getVectorDistance() {
        return this.vectorDistance;
    }

    public void setVectorDistance(Float vectorDistance) {
        this.vectorDistance = vectorDistance;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SearchResultHit searchResultHit = (SearchResultHit)o;
        return Objects.equals(this.highlights, searchResultHit.highlights) && Objects.equals(this.highlight, searchResultHit.highlight) && Objects.equals(this.document, searchResultHit.document) && Objects.equals(this.textMatch, searchResultHit.textMatch) && Objects.equals(this.textMatchInfo, searchResultHit.textMatchInfo) && Objects.equals(this.geoDistanceMeters, searchResultHit.geoDistanceMeters) && Objects.equals(this.vectorDistance, searchResultHit.vectorDistance);
    }

    public int hashCode() {
        return Objects.hash(this.highlights, this.highlight, this.document, this.textMatch, this.textMatchInfo, this.geoDistanceMeters, this.vectorDistance);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SearchResultHit {\n");
        sb.append("    highlights: ").append(this.toIndentedString(this.highlights)).append("\n");
        sb.append("    highlight: ").append(this.toIndentedString(this.highlight)).append("\n");
        sb.append("    document: ").append(this.toIndentedString(this.document)).append("\n");
        sb.append("    textMatch: ").append(this.toIndentedString(this.textMatch)).append("\n");
        sb.append("    textMatchInfo: ").append(this.toIndentedString(this.textMatchInfo)).append("\n");
        sb.append("    geoDistanceMeters: ").append(this.toIndentedString(this.geoDistanceMeters)).append("\n");
        sb.append("    vectorDistance: ").append(this.toIndentedString(this.vectorDistance)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

