/*
 * Decompiled with CFR 0.152.
 */
package org.typesense.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.typesense.model.Field;
import org.typesense.model.VoiceQueryModelCollectionConfig;

public class CollectionSchema {
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="fields")
    private List<Field> fields = new ArrayList<Field>();
    @JsonProperty(value="default_sorting_field")
    private String defaultSortingField = "";
    @JsonProperty(value="token_separators")
    private List<String> tokenSeparators = null;
    @JsonProperty(value="enable_nested_fields")
    private Boolean enableNestedFields = false;
    @JsonProperty(value="symbols_to_index")
    private List<String> symbolsToIndex = null;
    @JsonProperty(value="voice_query_model")
    private VoiceQueryModelCollectionConfig voiceQueryModel = null;

    public CollectionSchema name(String name) {
        this.name = name;
        return this;
    }

    @Schema(example="companies", required=true, description="Name of the collection")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public CollectionSchema fields(List<Field> fields) {
        this.fields = fields;
        return this;
    }

    public CollectionSchema addFieldsItem(Field fieldsItem) {
        this.fields.add(fieldsItem);
        return this;
    }

    @Schema(example="[{\"name\":\"num_employees\",\"type\":\"int32\",\"facet\":false},{\"name\":\"company_name\",\"type\":\"string\",\"facet\":false},{\"name\":\"country\",\"type\":\"string\",\"facet\":true}]", required=true, description="A list of fields for querying, filtering and faceting")
    public List<Field> getFields() {
        return this.fields;
    }

    public void setFields(List<Field> fields) {
        this.fields = fields;
    }

    public CollectionSchema defaultSortingField(String defaultSortingField) {
        this.defaultSortingField = defaultSortingField;
        return this;
    }

    @Schema(example="num_employees", description="The name of an int32 / float field that determines the order in which the search results are ranked when a sort_by clause is not provided during searching. This field must indicate some kind of popularity.")
    public String getDefaultSortingField() {
        return this.defaultSortingField;
    }

    public void setDefaultSortingField(String defaultSortingField) {
        this.defaultSortingField = defaultSortingField;
    }

    public CollectionSchema tokenSeparators(List<String> tokenSeparators) {
        this.tokenSeparators = tokenSeparators;
        return this;
    }

    public CollectionSchema addTokenSeparatorsItem(String tokenSeparatorsItem) {
        if (this.tokenSeparators == null) {
            this.tokenSeparators = new ArrayList<String>();
        }
        this.tokenSeparators.add(tokenSeparatorsItem);
        return this;
    }

    @Schema(description="List of symbols or special characters to be used for splitting the text into individual words in addition to space and new-line characters. ")
    public List<String> getTokenSeparators() {
        return this.tokenSeparators;
    }

    public void setTokenSeparators(List<String> tokenSeparators) {
        this.tokenSeparators = tokenSeparators;
    }

    public CollectionSchema enableNestedFields(Boolean enableNestedFields) {
        this.enableNestedFields = enableNestedFields;
        return this;
    }

    @Schema(example="true", description="Enables experimental support at a collection level for nested object or object array fields. This field is only available if the Typesense server is version `0.24.0.rcn34` or later.")
    public Boolean isEnableNestedFields() {
        return this.enableNestedFields;
    }

    public void setEnableNestedFields(Boolean enableNestedFields) {
        this.enableNestedFields = enableNestedFields;
    }

    public CollectionSchema symbolsToIndex(List<String> symbolsToIndex) {
        this.symbolsToIndex = symbolsToIndex;
        return this;
    }

    public CollectionSchema addSymbolsToIndexItem(String symbolsToIndexItem) {
        if (this.symbolsToIndex == null) {
            this.symbolsToIndex = new ArrayList<String>();
        }
        this.symbolsToIndex.add(symbolsToIndexItem);
        return this;
    }

    @Schema(description="List of symbols or special characters to be indexed. ")
    public List<String> getSymbolsToIndex() {
        return this.symbolsToIndex;
    }

    public void setSymbolsToIndex(List<String> symbolsToIndex) {
        this.symbolsToIndex = symbolsToIndex;
    }

    public CollectionSchema voiceQueryModel(VoiceQueryModelCollectionConfig voiceQueryModel) {
        this.voiceQueryModel = voiceQueryModel;
        return this;
    }

    @Schema(description="")
    public VoiceQueryModelCollectionConfig getVoiceQueryModel() {
        return this.voiceQueryModel;
    }

    public void setVoiceQueryModel(VoiceQueryModelCollectionConfig voiceQueryModel) {
        this.voiceQueryModel = voiceQueryModel;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CollectionSchema collectionSchema = (CollectionSchema)o;
        return Objects.equals(this.name, collectionSchema.name) && Objects.equals(this.fields, collectionSchema.fields) && Objects.equals(this.defaultSortingField, collectionSchema.defaultSortingField) && Objects.equals(this.tokenSeparators, collectionSchema.tokenSeparators) && Objects.equals(this.enableNestedFields, collectionSchema.enableNestedFields) && Objects.equals(this.symbolsToIndex, collectionSchema.symbolsToIndex) && Objects.equals(this.voiceQueryModel, collectionSchema.voiceQueryModel);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.fields, this.defaultSortingField, this.tokenSeparators, this.enableNestedFields, this.symbolsToIndex, this.voiceQueryModel);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CollectionSchema {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    fields: ").append(this.toIndentedString(this.fields)).append("\n");
        sb.append("    defaultSortingField: ").append(this.toIndentedString(this.defaultSortingField)).append("\n");
        sb.append("    tokenSeparators: ").append(this.toIndentedString(this.tokenSeparators)).append("\n");
        sb.append("    enableNestedFields: ").append(this.toIndentedString(this.enableNestedFields)).append("\n");
        sb.append("    symbolsToIndex: ").append(this.toIndentedString(this.symbolsToIndex)).append("\n");
        sb.append("    voiceQueryModel: ").append(this.toIndentedString(this.voiceQueryModel)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

