/*
 * Decompiled with CFR 0.152.
 */
package org.typesense.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class SearchOverrideRule {
    @JsonProperty(value="tags")
    private List<String> tags = null;
    @JsonProperty(value="query")
    private String query = null;
    @JsonProperty(value="match")
    private MatchEnum match = null;
    @JsonProperty(value="filter_by")
    private String filterBy = null;

    public SearchOverrideRule tags(List<String> tags) {
        this.tags = tags;
        return this;
    }

    public SearchOverrideRule addTagsItem(String tagsItem) {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        this.tags.add(tagsItem);
        return this;
    }

    @Schema(description="List of tag values to associate with this override rule.")
    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public SearchOverrideRule query(String query) {
        this.query = query;
        return this;
    }

    @Schema(description="Indicates what search queries should be overridden")
    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public SearchOverrideRule match(MatchEnum match) {
        this.match = match;
        return this;
    }

    @Schema(description="Indicates whether the match on the query term should be `exact` or `contains`. If we want to match all queries that contained the word `apple`, we will use the `contains` match instead. ")
    public MatchEnum getMatch() {
        return this.match;
    }

    public void setMatch(MatchEnum match) {
        this.match = match;
    }

    public SearchOverrideRule filterBy(String filterBy) {
        this.filterBy = filterBy;
        return this;
    }

    @Schema(description="Indicates that the override should apply when the filter_by parameter in a search query exactly matches the string specified here (including backticks, spaces, brackets, etc). ")
    public String getFilterBy() {
        return this.filterBy;
    }

    public void setFilterBy(String filterBy) {
        this.filterBy = filterBy;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SearchOverrideRule searchOverrideRule = (SearchOverrideRule)o;
        return Objects.equals(this.tags, searchOverrideRule.tags) && Objects.equals(this.query, searchOverrideRule.query) && Objects.equals((Object)this.match, (Object)searchOverrideRule.match) && Objects.equals(this.filterBy, searchOverrideRule.filterBy);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.tags, this.query, this.match, this.filterBy});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SearchOverrideRule {\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("    query: ").append(this.toIndentedString(this.query)).append("\n");
        sb.append("    match: ").append(this.toIndentedString((Object)this.match)).append("\n");
        sb.append("    filterBy: ").append(this.toIndentedString(this.filterBy)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum MatchEnum {
        EXACT("exact"),
        CONTAINS("contains");

        private String value;

        private MatchEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static MatchEnum fromValue(String input) {
            for (MatchEnum b : MatchEnum.values()) {
                if (!b.value.equals(input)) continue;
                return b;
            }
            return null;
        }
    }
}

