/*
 * Decompiled with CFR 0.152.
 */
package org.typesense.api;

import java.util.List;
import org.typesense.api.AnalyticsRuleSerializer;
import org.typesense.api.ApiCall;
import org.typesense.model.AnalyticsRule;
import org.typesense.model.AnalyticsRuleCreate;

public class AnalyticsRules {
    private final ApiCall apiCall;
    private final AnalyticsRuleSerializer serializer;
    public static final String RESOURCE_PATH = "/analytics/rules";

    public AnalyticsRules(ApiCall apiCall) {
        this.apiCall = apiCall;
        this.serializer = new AnalyticsRuleSerializer();
    }

    public AnalyticsRules(ApiCall apiCall, AnalyticsRuleSerializer serializer) {
        this.apiCall = apiCall;
        this.serializer = serializer;
    }

    public AnalyticsRulesResponse create(List<AnalyticsRuleCreate> rules) throws Exception {
        String response = this.apiCall.post(RESOURCE_PATH, rules, null, String.class);
        return this.parseCreateResponse(response);
    }

    public List<AnalyticsRule> retrieve() throws Exception {
        String response = this.apiCall.get(RESOURCE_PATH, null, String.class);
        return this.parseRetrieveResponse(response);
    }

    private AnalyticsRulesResponse parseCreateResponse(String jsonResponse) throws Exception {
        List<AnalyticsRule> rules = this.serializer.parseListFromJson(jsonResponse);
        for (AnalyticsRule rule : rules) {
            if (rule.getName() != null) continue;
            throw new RuntimeException("Analytics rule creation failed: rule name is null");
        }
        return new AnalyticsRulesResponse(rules);
    }

    private List<AnalyticsRule> parseRetrieveResponse(String jsonResponse) throws Exception {
        List<AnalyticsRule> rules = this.serializer.parseListFromJson(jsonResponse);
        return rules;
    }

    public static class AnalyticsRulesResponse {
        private final List<AnalyticsRule> rules;

        public AnalyticsRulesResponse(List<AnalyticsRule> rules) {
            this.rules = rules;
        }

        public List<AnalyticsRule> getRules() {
            return this.rules;
        }

        public AnalyticsRule getFirstRule() {
            return this.rules.isEmpty() ? null : this.rules.get(0);
        }

        public int getCount() {
            return this.rules.size();
        }

        public boolean isEmpty() {
            return this.rules.isEmpty();
        }
    }
}

