/*
 * Decompiled with CFR 0.152.
 */
package org.typesense.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.typesense.model.AnalyticsEventData;

public class AnalyticsEvent {
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="event_type")
    private String eventType = null;
    @JsonProperty(value="data")
    private AnalyticsEventData data = null;

    public AnalyticsEvent name(String name) {
        this.name = name;
        return this;
    }

    @Schema(required=true, description="Name of the analytics rule this event corresponds to")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public AnalyticsEvent eventType(String eventType) {
        this.eventType = eventType;
        return this;
    }

    @Schema(required=true, description="Type of event (e.g., click, conversion, query, visit)")
    public String getEventType() {
        return this.eventType;
    }

    public void setEventType(String eventType) {
        this.eventType = eventType;
    }

    public AnalyticsEvent data(AnalyticsEventData data) {
        this.data = data;
        return this;
    }

    @Schema(required=true, description="")
    public AnalyticsEventData getData() {
        return this.data;
    }

    public void setData(AnalyticsEventData data) {
        this.data = data;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AnalyticsEvent analyticsEvent = (AnalyticsEvent)o;
        return Objects.equals(this.name, analyticsEvent.name) && Objects.equals(this.eventType, analyticsEvent.eventType) && Objects.equals(this.data, analyticsEvent.data);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.eventType, this.data);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AnalyticsEvent {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    eventType: ").append(this.toIndentedString(this.eventType)).append("\n");
        sb.append("    data: ").append(this.toIndentedString(this.data)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

