/*
 * Decompiled with CFR 0.152.
 */
package org.typesense.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.typesense.model.CurationExclude;
import org.typesense.model.CurationInclude;
import org.typesense.model.CurationRule;

public class CurationItemCreateSchema {
    @JsonProperty(value="rule")
    private CurationRule rule = null;
    @JsonProperty(value="includes")
    private List<CurationInclude> includes = null;
    @JsonProperty(value="excludes")
    private List<CurationExclude> excludes = null;
    @JsonProperty(value="filter_by")
    private String filterBy = null;
    @JsonProperty(value="remove_matched_tokens")
    private Boolean removeMatchedTokens = null;
    @JsonProperty(value="metadata")
    private Object metadata = null;
    @JsonProperty(value="sort_by")
    private String sortBy = null;
    @JsonProperty(value="replace_query")
    private String replaceQuery = null;
    @JsonProperty(value="filter_curated_hits")
    private Boolean filterCuratedHits = null;
    @JsonProperty(value="effective_from_ts")
    private Integer effectiveFromTs = null;
    @JsonProperty(value="effective_to_ts")
    private Integer effectiveToTs = null;
    @JsonProperty(value="stop_processing")
    private Boolean stopProcessing = null;
    @JsonProperty(value="id")
    private String id = null;

    public CurationItemCreateSchema rule(CurationRule rule) {
        this.rule = rule;
        return this;
    }

    @Schema(required=true, description="")
    public CurationRule getRule() {
        return this.rule;
    }

    public void setRule(CurationRule rule) {
        this.rule = rule;
    }

    public CurationItemCreateSchema includes(List<CurationInclude> includes) {
        this.includes = includes;
        return this;
    }

    public CurationItemCreateSchema addIncludesItem(CurationInclude includesItem) {
        if (this.includes == null) {
            this.includes = new ArrayList<CurationInclude>();
        }
        this.includes.add(includesItem);
        return this;
    }

    @Schema(description="List of document `id`s that should be included in the search results with their corresponding `position`s.")
    public List<CurationInclude> getIncludes() {
        return this.includes;
    }

    public void setIncludes(List<CurationInclude> includes) {
        this.includes = includes;
    }

    public CurationItemCreateSchema excludes(List<CurationExclude> excludes) {
        this.excludes = excludes;
        return this;
    }

    public CurationItemCreateSchema addExcludesItem(CurationExclude excludesItem) {
        if (this.excludes == null) {
            this.excludes = new ArrayList<CurationExclude>();
        }
        this.excludes.add(excludesItem);
        return this;
    }

    @Schema(description="List of document `id`s that should be excluded from the search results.")
    public List<CurationExclude> getExcludes() {
        return this.excludes;
    }

    public void setExcludes(List<CurationExclude> excludes) {
        this.excludes = excludes;
    }

    public CurationItemCreateSchema filterBy(String filterBy) {
        this.filterBy = filterBy;
        return this;
    }

    @Schema(description="A filter by clause that is applied to any search query that matches the curation rule. ")
    public String getFilterBy() {
        return this.filterBy;
    }

    public void setFilterBy(String filterBy) {
        this.filterBy = filterBy;
    }

    public CurationItemCreateSchema removeMatchedTokens(Boolean removeMatchedTokens) {
        this.removeMatchedTokens = removeMatchedTokens;
        return this;
    }

    @Schema(description="Indicates whether search query tokens that exist in the curation's rule should be removed from the search query. ")
    public Boolean isRemoveMatchedTokens() {
        return this.removeMatchedTokens;
    }

    public void setRemoveMatchedTokens(Boolean removeMatchedTokens) {
        this.removeMatchedTokens = removeMatchedTokens;
    }

    public CurationItemCreateSchema metadata(Object metadata) {
        this.metadata = metadata;
        return this;
    }

    @Schema(description="Return a custom JSON object in the Search API response, when this rule is triggered. This can can be used to display a pre-defined message (eg: a promotion banner) on the front-end when a particular rule is triggered. ")
    public Object getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Object metadata) {
        this.metadata = metadata;
    }

    public CurationItemCreateSchema sortBy(String sortBy) {
        this.sortBy = sortBy;
        return this;
    }

    @Schema(description="A sort by clause that is applied to any search query that matches the curation rule. ")
    public String getSortBy() {
        return this.sortBy;
    }

    public void setSortBy(String sortBy) {
        this.sortBy = sortBy;
    }

    public CurationItemCreateSchema replaceQuery(String replaceQuery) {
        this.replaceQuery = replaceQuery;
        return this;
    }

    @Schema(description="Replaces the current search query with this value, when the search query matches the curation rule. ")
    public String getReplaceQuery() {
        return this.replaceQuery;
    }

    public void setReplaceQuery(String replaceQuery) {
        this.replaceQuery = replaceQuery;
    }

    public CurationItemCreateSchema filterCuratedHits(Boolean filterCuratedHits) {
        this.filterCuratedHits = filterCuratedHits;
        return this;
    }

    @Schema(description="When set to true, the filter conditions of the query is applied to the curated records as well. Default: false. ")
    public Boolean isFilterCuratedHits() {
        return this.filterCuratedHits;
    }

    public void setFilterCuratedHits(Boolean filterCuratedHits) {
        this.filterCuratedHits = filterCuratedHits;
    }

    public CurationItemCreateSchema effectiveFromTs(Integer effectiveFromTs) {
        this.effectiveFromTs = effectiveFromTs;
        return this;
    }

    @Schema(description="A Unix timestamp that indicates the date/time from which the curation will be active. You can use this to create rules that start applying from a future point in time. ")
    public Integer getEffectiveFromTs() {
        return this.effectiveFromTs;
    }

    public void setEffectiveFromTs(Integer effectiveFromTs) {
        this.effectiveFromTs = effectiveFromTs;
    }

    public CurationItemCreateSchema effectiveToTs(Integer effectiveToTs) {
        this.effectiveToTs = effectiveToTs;
        return this;
    }

    @Schema(description="A Unix timestamp that indicates the date/time until which the curation will be active. You can use this to create rules that stop applying after a period of time. ")
    public Integer getEffectiveToTs() {
        return this.effectiveToTs;
    }

    public void setEffectiveToTs(Integer effectiveToTs) {
        this.effectiveToTs = effectiveToTs;
    }

    public CurationItemCreateSchema stopProcessing(Boolean stopProcessing) {
        this.stopProcessing = stopProcessing;
        return this;
    }

    @Schema(description="When set to true, curation processing will stop at the first matching rule. When set to false curation processing will continue and multiple curation actions will be triggered in sequence. Curations are processed in the lexical sort order of their id field. ")
    public Boolean isStopProcessing() {
        return this.stopProcessing;
    }

    public void setStopProcessing(Boolean stopProcessing) {
        this.stopProcessing = stopProcessing;
    }

    public CurationItemCreateSchema id(String id) {
        this.id = id;
        return this;
    }

    @Schema(description="ID of the curation item")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CurationItemCreateSchema curationItemCreateSchema = (CurationItemCreateSchema)o;
        return Objects.equals(this.rule, curationItemCreateSchema.rule) && Objects.equals(this.includes, curationItemCreateSchema.includes) && Objects.equals(this.excludes, curationItemCreateSchema.excludes) && Objects.equals(this.filterBy, curationItemCreateSchema.filterBy) && Objects.equals(this.removeMatchedTokens, curationItemCreateSchema.removeMatchedTokens) && Objects.equals(this.metadata, curationItemCreateSchema.metadata) && Objects.equals(this.sortBy, curationItemCreateSchema.sortBy) && Objects.equals(this.replaceQuery, curationItemCreateSchema.replaceQuery) && Objects.equals(this.filterCuratedHits, curationItemCreateSchema.filterCuratedHits) && Objects.equals(this.effectiveFromTs, curationItemCreateSchema.effectiveFromTs) && Objects.equals(this.effectiveToTs, curationItemCreateSchema.effectiveToTs) && Objects.equals(this.stopProcessing, curationItemCreateSchema.stopProcessing) && Objects.equals(this.id, curationItemCreateSchema.id);
    }

    public int hashCode() {
        return Objects.hash(this.rule, this.includes, this.excludes, this.filterBy, this.removeMatchedTokens, this.metadata, this.sortBy, this.replaceQuery, this.filterCuratedHits, this.effectiveFromTs, this.effectiveToTs, this.stopProcessing, this.id);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CurationItemCreateSchema {\n");
        sb.append("    rule: ").append(this.toIndentedString(this.rule)).append("\n");
        sb.append("    includes: ").append(this.toIndentedString(this.includes)).append("\n");
        sb.append("    excludes: ").append(this.toIndentedString(this.excludes)).append("\n");
        sb.append("    filterBy: ").append(this.toIndentedString(this.filterBy)).append("\n");
        sb.append("    removeMatchedTokens: ").append(this.toIndentedString(this.removeMatchedTokens)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    sortBy: ").append(this.toIndentedString(this.sortBy)).append("\n");
        sb.append("    replaceQuery: ").append(this.toIndentedString(this.replaceQuery)).append("\n");
        sb.append("    filterCuratedHits: ").append(this.toIndentedString(this.filterCuratedHits)).append("\n");
        sb.append("    effectiveFromTs: ").append(this.toIndentedString(this.effectiveFromTs)).append("\n");
        sb.append("    effectiveToTs: ").append(this.toIndentedString(this.effectiveToTs)).append("\n");
        sb.append("    stopProcessing: ").append(this.toIndentedString(this.stopProcessing)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

