/*
 * Decompiled with CFR 0.152.
 */
package org.typesense.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.typesense.model.Field;

public class CollectionUpdateSchema {
    @JsonProperty(value="fields")
    private List<Field> fields = new ArrayList<Field>();
    @JsonProperty(value="synonym_sets")
    private List<String> synonymSets = null;
    @JsonProperty(value="metadata")
    private Object metadata = null;

    public CollectionUpdateSchema fields(List<Field> fields) {
        this.fields = fields;
        return this;
    }

    public CollectionUpdateSchema addFieldsItem(Field fieldsItem) {
        this.fields.add(fieldsItem);
        return this;
    }

    @Schema(example="[{\"name\":\"company_name\",\"type\":\"string\",\"facet\":false},{\"name\":\"num_employees\",\"type\":\"int32\",\"facet\":false},{\"name\":\"country\",\"type\":\"string\",\"facet\":true}]", required=true, description="A list of fields for querying, filtering and faceting")
    public List<Field> getFields() {
        return this.fields;
    }

    public void setFields(List<Field> fields) {
        this.fields = fields;
    }

    public CollectionUpdateSchema synonymSets(List<String> synonymSets) {
        this.synonymSets = synonymSets;
        return this;
    }

    public CollectionUpdateSchema addSynonymSetsItem(String synonymSetsItem) {
        if (this.synonymSets == null) {
            this.synonymSets = new ArrayList<String>();
        }
        this.synonymSets.add(synonymSetsItem);
        return this;
    }

    @Schema(description="List of synonym set names to associate with this collection")
    public List<String> getSynonymSets() {
        return this.synonymSets;
    }

    public void setSynonymSets(List<String> synonymSets) {
        this.synonymSets = synonymSets;
    }

    public CollectionUpdateSchema metadata(Object metadata) {
        this.metadata = metadata;
        return this;
    }

    @Schema(description="Optional details about the collection, e.g., when it was created, who created it etc. ")
    public Object getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Object metadata) {
        this.metadata = metadata;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CollectionUpdateSchema collectionUpdateSchema = (CollectionUpdateSchema)o;
        return Objects.equals(this.fields, collectionUpdateSchema.fields) && Objects.equals(this.synonymSets, collectionUpdateSchema.synonymSets) && Objects.equals(this.metadata, collectionUpdateSchema.metadata);
    }

    public int hashCode() {
        return Objects.hash(this.fields, this.synonymSets, this.metadata);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CollectionUpdateSchema {\n");
        sb.append("    fields: ").append(this.toIndentedString(this.fields)).append("\n");
        sb.append("    synonymSets: ").append(this.toIndentedString(this.synonymSets)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

