/*
 * Decompiled with CFR 0.152.
 */
package org.typesense.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class SynonymItemSchema {
    @JsonProperty(value="id")
    private String id = null;
    @JsonProperty(value="synonyms")
    private List<String> synonyms = new ArrayList<String>();
    @JsonProperty(value="root")
    private String root = null;
    @JsonProperty(value="locale")
    private String locale = null;
    @JsonProperty(value="symbols_to_index")
    private List<String> symbolsToIndex = null;

    public SynonymItemSchema id(String id) {
        this.id = id;
        return this;
    }

    @Schema(required=true, description="Unique identifier for the synonym item")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public SynonymItemSchema synonyms(List<String> synonyms) {
        this.synonyms = synonyms;
        return this;
    }

    public SynonymItemSchema addSynonymsItem(String synonymsItem) {
        this.synonyms.add(synonymsItem);
        return this;
    }

    @Schema(required=true, description="Array of words that should be considered as synonyms")
    public List<String> getSynonyms() {
        return this.synonyms;
    }

    public void setSynonyms(List<String> synonyms) {
        this.synonyms = synonyms;
    }

    public SynonymItemSchema root(String root) {
        this.root = root;
        return this;
    }

    @Schema(description="For 1-way synonyms, indicates the root word that words in the synonyms parameter map to")
    public String getRoot() {
        return this.root;
    }

    public void setRoot(String root) {
        this.root = root;
    }

    public SynonymItemSchema locale(String locale) {
        this.locale = locale;
        return this;
    }

    @Schema(description="Locale for the synonym, leave blank to use the standard tokenizer")
    public String getLocale() {
        return this.locale;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    public SynonymItemSchema symbolsToIndex(List<String> symbolsToIndex) {
        this.symbolsToIndex = symbolsToIndex;
        return this;
    }

    public SynonymItemSchema addSymbolsToIndexItem(String symbolsToIndexItem) {
        if (this.symbolsToIndex == null) {
            this.symbolsToIndex = new ArrayList<String>();
        }
        this.symbolsToIndex.add(symbolsToIndexItem);
        return this;
    }

    @Schema(description="By default, special characters are dropped from synonyms. Use this attribute to specify which special characters should be indexed as is")
    public List<String> getSymbolsToIndex() {
        return this.symbolsToIndex;
    }

    public void setSymbolsToIndex(List<String> symbolsToIndex) {
        this.symbolsToIndex = symbolsToIndex;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SynonymItemSchema synonymItemSchema = (SynonymItemSchema)o;
        return Objects.equals(this.id, synonymItemSchema.id) && Objects.equals(this.synonyms, synonymItemSchema.synonyms) && Objects.equals(this.root, synonymItemSchema.root) && Objects.equals(this.locale, synonymItemSchema.locale) && Objects.equals(this.symbolsToIndex, synonymItemSchema.symbolsToIndex);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.synonyms, this.root, this.locale, this.symbolsToIndex);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SynonymItemSchema {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    synonyms: ").append(this.toIndentedString(this.synonyms)).append("\n");
        sb.append("    root: ").append(this.toIndentedString(this.root)).append("\n");
        sb.append("    locale: ").append(this.toIndentedString(this.locale)).append("\n");
        sb.append("    symbolsToIndex: ").append(this.toIndentedString(this.symbolsToIndex)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

