/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.utils;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.web3j.exceptions.MessageDecodingException;
import org.web3j.exceptions.MessageEncodingException;
import org.web3j.utils.Numeric;

public class NumericTest {
    private static final byte[] HEX_RANGE_ARRAY = new byte[]{Numeric.asByte((int)0, (int)1), Numeric.asByte((int)2, (int)3), Numeric.asByte((int)4, (int)5), Numeric.asByte((int)6, (int)7), Numeric.asByte((int)8, (int)9), Numeric.asByte((int)10, (int)11), Numeric.asByte((int)12, (int)13), Numeric.asByte((int)14, (int)15)};
    private static final String HEX_RANGE_STRING = "0x0123456789abcdef";

    @Test
    public void testQuantityEncodeLeadingZero() {
        Assertions.assertEquals((Object)Numeric.toHexStringWithPrefixSafe((BigInteger)BigInteger.valueOf(0L)), (Object)"0x00");
        Assertions.assertEquals((Object)Numeric.toHexStringWithPrefixSafe((BigInteger)BigInteger.valueOf(1024L)), (Object)"0x400");
        Assertions.assertEquals((Object)Numeric.toHexStringWithPrefixSafe((BigInteger)BigInteger.valueOf(Long.MAX_VALUE)), (Object)"0x7fffffffffffffff");
        Assertions.assertEquals((Object)Numeric.toHexStringWithPrefixSafe((BigInteger)new BigInteger("204516877000845695339750056077105398031")), (Object)"0x99dc848b94efc27edfad28def049810f");
    }

    @Test
    public void testQuantityDecode() {
        Assertions.assertEquals((Object)Numeric.decodeQuantity((String)"0x0"), (Object)BigInteger.valueOf(0L));
        Assertions.assertEquals((Object)Numeric.decodeQuantity((String)"0x400"), (Object)BigInteger.valueOf(1024L));
        Assertions.assertEquals((Object)Numeric.decodeQuantity((String)"0x0"), (Object)BigInteger.valueOf(0L));
        Assertions.assertEquals((Object)Numeric.decodeQuantity((String)"0x7fffffffffffffff"), (Object)BigInteger.valueOf(Long.MAX_VALUE));
        Assertions.assertEquals((Object)Numeric.decodeQuantity((String)"0x99dc848b94efc27edfad28def049810f"), (Object)new BigInteger("204516877000845695339750056077105398031"));
    }

    @Test
    public void testQuantityDecodeLeadingZero() {
        Assertions.assertEquals((Object)Numeric.decodeQuantity((String)"0x0400"), (Object)BigInteger.valueOf(1024L));
        Assertions.assertEquals((Object)Numeric.decodeQuantity((String)"0x001"), (Object)BigInteger.valueOf(1L));
    }

    @Disabled
    @Test
    public void testQuantityDecodeLeadingZeroException() {
        Assertions.assertThrows(MessageDecodingException.class, () -> Numeric.decodeQuantity((String)"0x0400"));
    }

    @Test
    public void testQuantityDecodeMissingPrefix() {
        Assertions.assertThrows(MessageDecodingException.class, () -> Numeric.decodeQuantity((String)"ff"));
    }

    @Test
    public void testQuantityDecodeLong() {
        Assertions.assertEquals((Object)Numeric.decodeQuantity((String)"1234"), (Object)BigInteger.valueOf(1234L));
    }

    @Test
    public void testQuantityDecodeMissingValue() {
        Assertions.assertThrows(MessageDecodingException.class, () -> Numeric.decodeQuantity((String)"0x"));
    }

    @Test
    public void testQuantityEncode() {
        Assertions.assertEquals((Object)Numeric.encodeQuantity((BigInteger)BigInteger.valueOf(0L)), (Object)"0x0");
        Assertions.assertEquals((Object)Numeric.encodeQuantity((BigInteger)BigInteger.valueOf(1L)), (Object)"0x1");
        Assertions.assertEquals((Object)Numeric.encodeQuantity((BigInteger)BigInteger.valueOf(1024L)), (Object)"0x400");
        Assertions.assertEquals((Object)Numeric.encodeQuantity((BigInteger)BigInteger.valueOf(Long.MAX_VALUE)), (Object)"0x7fffffffffffffff");
        Assertions.assertEquals((Object)Numeric.encodeQuantity((BigInteger)new BigInteger("204516877000845695339750056077105398031")), (Object)"0x99dc848b94efc27edfad28def049810f");
    }

    @Test
    public void testQuantityEncodeNegative() {
        Assertions.assertThrows(MessageEncodingException.class, () -> Numeric.encodeQuantity((BigInteger)BigInteger.valueOf(-1L)));
    }

    @Test
    public void testCleanHexPrefix() {
        Assertions.assertEquals((Object)Numeric.cleanHexPrefix((String)""), (Object)"");
        Assertions.assertEquals((Object)Numeric.cleanHexPrefix((String)"0123456789abcdef"), (Object)"0123456789abcdef");
        Assertions.assertEquals((Object)Numeric.cleanHexPrefix((String)"0x"), (Object)"");
        Assertions.assertEquals((Object)Numeric.cleanHexPrefix((String)HEX_RANGE_STRING), (Object)"0123456789abcdef");
    }

    @Test
    public void testPrependHexPrefix() {
        Assertions.assertEquals((Object)Numeric.prependHexPrefix((String)""), (Object)"0x");
        Assertions.assertEquals((Object)Numeric.prependHexPrefix((String)HEX_RANGE_STRING), (Object)HEX_RANGE_STRING);
        Assertions.assertEquals((Object)Numeric.prependHexPrefix((String)"0x"), (Object)"0x");
        Assertions.assertEquals((Object)Numeric.prependHexPrefix((String)"0123456789abcdef"), (Object)HEX_RANGE_STRING);
    }

    @Test
    public void testToHexStringWithPrefix() {
        Assertions.assertEquals((Object)Numeric.toHexStringWithPrefix((BigInteger)BigInteger.TEN), (Object)"0xa");
    }

    @Test
    public void testToHexStringNoPrefix() {
        Assertions.assertEquals((Object)Numeric.toHexStringNoPrefix((BigInteger)BigInteger.TEN), (Object)"a");
    }

    @Test
    public void testToBytesPadded() {
        Assertions.assertArrayEquals((byte[])Numeric.toBytesPadded((BigInteger)BigInteger.TEN, (int)1), (byte[])new byte[]{10});
        Assertions.assertArrayEquals((byte[])Numeric.toBytesPadded((BigInteger)BigInteger.TEN, (int)8), (byte[])new byte[]{0, 0, 0, 0, 0, 0, 0, 10});
        Assertions.assertArrayEquals((byte[])Numeric.toBytesPadded((BigInteger)BigInteger.valueOf(Integer.MAX_VALUE), (int)4), (byte[])new byte[]{127, -1, -1, -1});
    }

    @Test
    public void testToBytesPaddedInvalid() {
        Assertions.assertThrows(RuntimeException.class, () -> Numeric.toBytesPadded((BigInteger)BigInteger.valueOf(Long.MAX_VALUE), (int)7));
    }

    @Test
    public void testHexStringToByteArray() {
        Assertions.assertArrayEquals((byte[])Numeric.hexStringToByteArray((String)""), (byte[])new byte[0]);
        Assertions.assertArrayEquals((byte[])Numeric.hexStringToByteArray((String)"0"), (byte[])new byte[]{0});
        Assertions.assertArrayEquals((byte[])Numeric.hexStringToByteArray((String)"1"), (byte[])new byte[]{1});
        Assertions.assertArrayEquals((byte[])Numeric.hexStringToByteArray((String)HEX_RANGE_STRING), (byte[])HEX_RANGE_ARRAY);
        Assertions.assertArrayEquals((byte[])Numeric.hexStringToByteArray((String)"0x123"), (byte[])new byte[]{1, 35});
    }

    @Test
    public void testToHexString() {
        Assertions.assertEquals((Object)Numeric.toHexString((byte[])new byte[0]), (Object)"0x");
        Assertions.assertEquals((Object)Numeric.toHexString((byte[])new byte[]{1}), (Object)"0x01");
        Assertions.assertEquals((Object)Numeric.toHexString((byte[])HEX_RANGE_ARRAY), (Object)HEX_RANGE_STRING);
    }

    @Test
    public void testToHexStringNoPrefixZeroPadded() {
        Assertions.assertEquals((Object)Numeric.toHexStringNoPrefixZeroPadded((BigInteger)BigInteger.ZERO, (int)5), (Object)"00000");
        Assertions.assertEquals((Object)Numeric.toHexStringNoPrefixZeroPadded((BigInteger)new BigInteger("11c52b08330e05d731e38c856c1043288f7d9744", 16), (int)40), (Object)"11c52b08330e05d731e38c856c1043288f7d9744");
        Assertions.assertEquals((Object)Numeric.toHexStringNoPrefixZeroPadded((BigInteger)new BigInteger("01c52b08330e05d731e38c856c1043288f7d9744", 16), (int)40), (Object)"01c52b08330e05d731e38c856c1043288f7d9744");
    }

    @Test
    public void testToHexStringWithPrefixZeroPadded() {
        Assertions.assertEquals((Object)Numeric.toHexStringWithPrefixZeroPadded((BigInteger)BigInteger.ZERO, (int)5), (Object)"0x00000");
        Assertions.assertEquals((Object)Numeric.toHexStringWithPrefixZeroPadded((BigInteger)new BigInteger("01c52b08330e05d731e38c856c1043288f7d9744", 16), (int)40), (Object)"0x01c52b08330e05d731e38c856c1043288f7d9744");
        Assertions.assertEquals((Object)Numeric.toHexStringWithPrefixZeroPadded((BigInteger)new BigInteger("01c52b08330e05d731e38c856c1043288f7d9744", 16), (int)40), (Object)"0x01c52b08330e05d731e38c856c1043288f7d9744");
    }

    @Test
    public void testToHexStringZeroPaddedNegative() {
        Assertions.assertThrows(UnsupportedOperationException.class, () -> Numeric.toHexStringNoPrefixZeroPadded((BigInteger)BigInteger.valueOf(-1L), (int)20));
    }

    @Test
    public void testToHexStringZeroPaddedTooLargs() {
        Assertions.assertThrows(UnsupportedOperationException.class, () -> Numeric.toHexStringNoPrefixZeroPadded((BigInteger)BigInteger.valueOf(-1L), (int)5));
    }

    @Test
    public void testIsIntegerValue() {
        Assertions.assertTrue((boolean)Numeric.isIntegerValue((BigDecimal)BigDecimal.ZERO));
        Assertions.assertTrue((boolean)Numeric.isIntegerValue((BigDecimal)BigDecimal.ZERO));
        Assertions.assertTrue((boolean)Numeric.isIntegerValue((BigDecimal)BigDecimal.valueOf(Long.MAX_VALUE)));
        Assertions.assertTrue((boolean)Numeric.isIntegerValue((BigDecimal)BigDecimal.valueOf(Long.MIN_VALUE)));
        Assertions.assertTrue((boolean)Numeric.isIntegerValue((BigDecimal)new BigDecimal("9999999999999999999999999999999999999999999999999999999999999999.0")));
        Assertions.assertTrue((boolean)Numeric.isIntegerValue((BigDecimal)new BigDecimal("-9999999999999999999999999999999999999999999999999999999999999999.0")));
        Assertions.assertFalse((boolean)Numeric.isIntegerValue((BigDecimal)BigDecimal.valueOf(0.1)));
        Assertions.assertFalse((boolean)Numeric.isIntegerValue((BigDecimal)BigDecimal.valueOf(-0.1)));
        Assertions.assertFalse((boolean)Numeric.isIntegerValue((BigDecimal)BigDecimal.valueOf(1.1)));
        Assertions.assertFalse((boolean)Numeric.isIntegerValue((BigDecimal)BigDecimal.valueOf(-1.1)));
    }

    @Test
    public void testHandleNPE() {
        Assertions.assertFalse((boolean)Numeric.containsHexPrefix(null));
        Assertions.assertFalse((boolean)Numeric.containsHexPrefix((String)""));
    }
}

