/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.utils;

import java.util.Arrays;
import java.util.Collections;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.web3j.utils.Strings;

public class StringsTest {
    @Test
    public void testToCsv() {
        Assertions.assertEquals((Object)Strings.toCsv(Collections.emptyList()), (Object)"");
        Assertions.assertEquals((Object)Strings.toCsv(Collections.singletonList("a")), (Object)"a");
        Assertions.assertEquals((Object)Strings.toCsv(Arrays.asList("a", "b", "c")), (Object)"a, b, c");
    }

    @Test
    public void testJoin() {
        Assertions.assertEquals((Object)Strings.join(Arrays.asList("a", "b"), (String)"|"), (Object)"a|b");
        Assertions.assertNull((Object)Strings.join(null, (String)"|"));
        Assertions.assertEquals((Object)Strings.join(Collections.singletonList("a"), (String)"|"), (Object)"a");
    }

    @Test
    public void testCapitaliseFirstLetter() {
        Assertions.assertEquals((Object)Strings.capitaliseFirstLetter((String)""), (Object)"");
        Assertions.assertEquals((Object)Strings.capitaliseFirstLetter((String)"a"), (Object)"A");
        Assertions.assertEquals((Object)Strings.capitaliseFirstLetter((String)"aa"), (Object)"Aa");
        Assertions.assertEquals((Object)Strings.capitaliseFirstLetter((String)"A"), (Object)"A");
        Assertions.assertEquals((Object)Strings.capitaliseFirstLetter((String)"Ab"), (Object)"Ab");
    }

    @Test
    public void testLowercaseFirstLetter() {
        Assertions.assertEquals((Object)Strings.lowercaseFirstLetter((String)""), (Object)"");
        Assertions.assertEquals((Object)Strings.lowercaseFirstLetter((String)"A"), (Object)"a");
        Assertions.assertEquals((Object)Strings.lowercaseFirstLetter((String)"AA"), (Object)"aA");
        Assertions.assertEquals((Object)Strings.lowercaseFirstLetter((String)"a"), (Object)"a");
        Assertions.assertEquals((Object)Strings.lowercaseFirstLetter((String)"aB"), (Object)"aB");
    }

    @Test
    public void testRepeat() {
        Assertions.assertEquals((Object)Strings.repeat((char)'0', (int)0), (Object)"");
        Assertions.assertEquals((Object)Strings.repeat((char)'1', (int)3), (Object)"111");
    }

    @Test
    public void testZeros() {
        Assertions.assertEquals((Object)Strings.zeros((int)0), (Object)"");
        Assertions.assertEquals((Object)Strings.zeros((int)3), (Object)"000");
    }

    @Test
    public void testEmptyString() {
        Assertions.assertTrue((boolean)Strings.isEmpty(null));
        Assertions.assertTrue((boolean)Strings.isEmpty((String)""));
        Assertions.assertFalse((boolean)Strings.isEmpty((String)"hello world"));
    }
}

