/*
 * Decompiled with CFR 0.152.
 */
package org.wickedsource.diffparser.unified;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wickedsource.diffparser.unified.ParseWindow;

public enum ParserState {
    INITIAL{

        @Override
        public ParserState nextState(ParseWindow window) {
            String line = window.getFocusLine();
            if (this.matchesFromFilePattern(line)) {
                this.logTransition(line, INITIAL, FROM_FILE);
                return FROM_FILE;
            }
            this.logTransition(line, INITIAL, HEADER);
            return HEADER;
        }
    }
    ,
    HEADER{

        @Override
        public ParserState nextState(ParseWindow window) {
            String line = window.getFocusLine();
            if (this.matchesFromFilePattern(line)) {
                this.logTransition(line, HEADER, FROM_FILE);
                return FROM_FILE;
            }
            this.logTransition(line, HEADER, HEADER);
            return HEADER;
        }
    }
    ,
    FROM_FILE{

        @Override
        public ParserState nextState(ParseWindow window) {
            String line = window.getFocusLine();
            if (this.matchesToFilePattern(line)) {
                this.logTransition(line, FROM_FILE, TO_FILE);
                return TO_FILE;
            }
            throw new IllegalStateException("A FROM_FILE line ('---') must be directly followed by a TO_FILE line ('+++')!");
        }
    }
    ,
    TO_FILE{

        @Override
        public ParserState nextState(ParseWindow window) {
            String line = window.getFocusLine();
            if (this.matchesHunkStartPattern(line)) {
                this.logTransition(line, TO_FILE, HUNK_START);
                return HUNK_START;
            }
            throw new IllegalStateException("A TO_FILE line ('+++') must be directly followed by a HUNK_START line ('@@')!");
        }
    }
    ,
    HUNK_START{

        @Override
        public ParserState nextState(ParseWindow window) {
            String line = window.getFocusLine();
            if (this.matchesFromLinePattern(line)) {
                this.logTransition(line, HUNK_START, FROM_LINE);
                return FROM_LINE;
            }
            if (this.matchesToLinePattern(line)) {
                this.logTransition(line, HUNK_START, TO_LINE);
                return TO_LINE;
            }
            this.logTransition(line, HUNK_START, NEUTRAL_LINE);
            return NEUTRAL_LINE;
        }
    }
    ,
    FROM_LINE{

        @Override
        public ParserState nextState(ParseWindow window) {
            String line = window.getFocusLine();
            if (this.matchesFromLinePattern(line)) {
                this.logTransition(line, FROM_LINE, FROM_LINE);
                return FROM_LINE;
            }
            if (this.matchesToLinePattern(line)) {
                this.logTransition(line, FROM_LINE, TO_LINE);
                return TO_LINE;
            }
            if (this.matchesEndPattern(line, window)) {
                this.logTransition(line, FROM_LINE, END);
                return END;
            }
            if (this.matchesHunkStartPattern(line)) {
                this.logTransition(line, FROM_LINE, HUNK_START);
                return HUNK_START;
            }
            this.logTransition(line, FROM_LINE, NEUTRAL_LINE);
            return NEUTRAL_LINE;
        }
    }
    ,
    TO_LINE{

        @Override
        public ParserState nextState(ParseWindow window) {
            String line = window.getFocusLine();
            if (this.matchesFromLinePattern(line)) {
                this.logTransition(line, TO_LINE, FROM_LINE);
                return FROM_LINE;
            }
            if (this.matchesToLinePattern(line)) {
                this.logTransition(line, TO_LINE, TO_LINE);
                return TO_LINE;
            }
            if (this.matchesEndPattern(line, window)) {
                this.logTransition(line, TO_LINE, END);
                return END;
            }
            if (this.matchesHunkStartPattern(line)) {
                this.logTransition(line, TO_LINE, HUNK_START);
                return HUNK_START;
            }
            this.logTransition(line, TO_LINE, NEUTRAL_LINE);
            return NEUTRAL_LINE;
        }
    }
    ,
    NEUTRAL_LINE{

        @Override
        public ParserState nextState(ParseWindow window) {
            String line = window.getFocusLine();
            if (this.matchesFromLinePattern(line)) {
                this.logTransition(line, NEUTRAL_LINE, FROM_LINE);
                return FROM_LINE;
            }
            if (this.matchesToLinePattern(line)) {
                this.logTransition(line, NEUTRAL_LINE, TO_LINE);
                return TO_LINE;
            }
            if (this.matchesEndPattern(line, window)) {
                this.logTransition(line, NEUTRAL_LINE, END);
                return END;
            }
            if (this.matchesHunkStartPattern(line)) {
                this.logTransition(line, NEUTRAL_LINE, HUNK_START);
                return HUNK_START;
            }
            this.logTransition(line, NEUTRAL_LINE, NEUTRAL_LINE);
            return NEUTRAL_LINE;
        }
    }
    ,
    END{

        @Override
        public ParserState nextState(ParseWindow window) {
            String line = window.getFocusLine();
            this.logTransition(line, END, INITIAL);
            return INITIAL;
        }
    };

    protected static Logger logger;

    public abstract ParserState nextState(ParseWindow var1);

    protected void logTransition(String currentLine, ParserState fromState, ParserState toState) {
        logger.debug(String.format("%12s -> %12s: %s", new Object[]{fromState, toState, currentLine}));
    }

    protected boolean matchesFromFilePattern(String line) {
        return line.startsWith("---");
    }

    protected boolean matchesToFilePattern(String line) {
        return line.startsWith("+++");
    }

    protected boolean matchesFromLinePattern(String line) {
        return line.startsWith("-");
    }

    protected boolean matchesToLinePattern(String line) {
        return line.startsWith("+");
    }

    protected boolean matchesHunkStartPattern(String line) {
        return line.startsWith("@@") && line.endsWith("@@");
    }

    protected boolean matchesEndPattern(String line, ParseWindow window) {
        if ("".equals(line.trim())) {
            String futureLine;
            int i = 1;
            while ((futureLine = window.getFutureLine(i)) != null) {
                if (this.matchesFromFilePattern(futureLine)) {
                    return true;
                }
                if ("".equals(futureLine.trim())) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    static {
        logger = LoggerFactory.getLogger(ParserState.class);
    }
}

