/*
 * Decompiled with CFR 0.152.
 */
package org.wickedsource.diffparser.unified;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.wickedsource.diffparser.unified.ParseWindow;

public class ResizingParseWindow
implements ParseWindow {
    private BufferedReader reader;
    private LinkedList<String> lineQueue = new LinkedList();
    private int lineNumber = 0;
    private List<Pattern> ignorePatterns = new ArrayList<Pattern>();

    public ResizingParseWindow(InputStream in) {
        InputStreamReader unbufferedReader = new InputStreamReader(in);
        this.reader = new BufferedReader(unbufferedReader);
    }

    public void addIgnorePattern(String ignorePattern) {
        this.ignorePatterns.add(Pattern.compile(ignorePattern));
    }

    @Override
    public String getFutureLine(int distance) {
        try {
            this.resizeWindowIfNecessary(distance + 1);
            return this.lineQueue.get(distance);
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    private void resizeWindowIfNecessary(int newSize) {
        try {
            int numberOfLinesToLoad = newSize - this.lineQueue.size();
            for (int i = 0; i < numberOfLinesToLoad; ++i) {
                String nextLine = this.getNextLine();
                if (nextLine == null) {
                    throw new IndexOutOfBoundsException("End of stream has been reached!");
                }
                this.lineQueue.addLast(nextLine);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String slideForward() {
        try {
            this.lineQueue.pollFirst();
            ++this.lineNumber;
            if (this.lineQueue.isEmpty()) {
                String nextLine = this.getNextLine();
                if (nextLine != null) {
                    this.lineQueue.addLast(nextLine);
                }
                return nextLine;
            }
            return this.lineQueue.peekFirst();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String getNextLine() throws IOException {
        String nextLine = this.reader.readLine();
        while (this.matchesIgnorePattern(nextLine)) {
            nextLine = this.reader.readLine();
        }
        return nextLine;
    }

    private boolean matchesIgnorePattern(String line) {
        if (line == null) {
            return false;
        }
        for (Pattern pattern : this.ignorePatterns) {
            Matcher matcher = pattern.matcher(line);
            if (!matcher.matches()) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getFocusLine() {
        return this.lineQueue.element();
    }

    @Override
    public int getFocusLineNumber() {
        return this.lineNumber;
    }
}

