/*
 * Decompiled with CFR 0.152.
 */
package org.osiam;

import com.google.common.collect.ImmutableMap;
import com.ryantenney.metrics.spring.config.annotation.EnableMetrics;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import org.osiam.OsiamHome;
import org.osiam.cli.InitHome;
import org.osiam.cli.MigrateDb;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.boot.context.web.SpringBootServletInitializer;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.context.annotation.FilterType;
import org.springframework.security.authentication.encoding.ShaPasswordEncoder;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;

/*
 * Exception performing whole class analysis ignored.
 */
@SpringBootApplication
@EnableWebSecurity
@EnableMetrics
@EnableAspectJAutoProxy(proxyTargetClass=true)
@ComponentScan(excludeFilters={@ComponentScan.Filter(type=FilterType.REGEX, pattern={"org\\.osiam\\.cli.*"})})
public class Osiam
extends SpringBootServletInitializer {
    private static final Map<String, Object> DEFAULT_PROPERTIES = ImmutableMap.of((Object)"spring.config.location", (Object)"file:${osiam.home}/config/osiam.yaml");

    public static void main(String[] args) {
        SpringApplication application = new SpringApplication(new Object[0]);
        String command = Osiam.extractCommand((String[])args);
        OsiamHome osiamHome = new OsiamHome();
        if ("initHome".equals(command)) {
            application.setSources(Collections.singleton(InitHome.class));
            application.setWebEnvironment(false);
        } else if ("migrateDb".equals(command)) {
            application.setSources(Collections.singleton(MigrateDb.class));
            application.setWebEnvironment(false);
            osiamHome.shouldInitializeHome(false);
        } else {
            application.setSources(Collections.singleton(Osiam.class));
        }
        application.addListeners(new ApplicationListener[]{osiamHome});
        application.setDefaultProperties(DEFAULT_PROPERTIES);
        application.run(args);
    }

    private static String extractCommand(String[] arguments) {
        return Arrays.stream(arguments).map(String::trim).filter(argument -> !argument.startsWith("-")).filter(argument -> !argument.startsWith("--")).findFirst().orElse("server");
    }

    protected SpringApplicationBuilder configure(SpringApplicationBuilder applicationBuilder) {
        applicationBuilder.application().setDefaultProperties(DEFAULT_PROPERTIES);
        applicationBuilder.application().addListeners(new ApplicationListener[]{new OsiamHome()});
        return applicationBuilder;
    }

    @Bean
    public ShaPasswordEncoder shaPasswordEncoder() {
        ShaPasswordEncoder shaPasswordEncoder = new ShaPasswordEncoder(512);
        shaPasswordEncoder.setIterations(1000);
        return shaPasswordEncoder;
    }

    @Bean
    public BCryptPasswordEncoder bCryptPasswordEncoder() {
        return new BCryptPasswordEncoder(13);
    }
}

