/*
 * Decompiled with CFR 0.152.
 */
package org.osiam.auth.login;

import com.google.common.base.Strings;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osiam.auth.exception.LdapAuthenticationProcessException;
import org.springframework.security.authentication.LockedException;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.authentication.SimpleUrlAuthenticationFailureHandler;

public class OsiamCachingAuthenticationFailureHandler
extends SimpleUrlAuthenticationFailureHandler {
    private static final String LAST_USERNAME_KEY = "LAST_USERNAME";
    private static final String LAST_PROVIDER_KEY = "LAST_PROVIDER";
    private static final String ERROR_KEY = "ERROR_KEY";
    private static final String IS_LOCKED = "IS_LOCKED";

    public OsiamCachingAuthenticationFailureHandler(String defaultFailureUrl) {
        super(defaultFailureUrl);
    }

    public void onAuthenticationFailure(HttpServletRequest request, HttpServletResponse response, AuthenticationException exception) throws IOException, ServletException {
        super.onAuthenticationFailure(request, response, exception);
        if (request.getSession(false) == null && !this.isAllowSessionCreation()) {
            return;
        }
        request.getSession().setAttribute(LAST_USERNAME_KEY, (Object)request.getParameter("username"));
        request.getSession().setAttribute(LAST_PROVIDER_KEY, (Object)(Strings.isNullOrEmpty((String)request.getParameter("provider")) ? "internal" : request.getParameter("provider")));
        request.getSession().setAttribute(IS_LOCKED, (Object)false);
        if (exception instanceof LdapAuthenticationProcessException) {
            request.getSession().setAttribute(ERROR_KEY, (Object)"login.ldap.internal.user.exists");
        } else if (exception instanceof LockedException) {
            request.getSession().setAttribute(IS_LOCKED, (Object)true);
        }
    }
}

