/*
 * Decompiled with CFR 0.152.
 */
package org.osiam.resources.converter;

import java.util.HashSet;
import org.osiam.resources.converter.Converter;
import org.osiam.resources.converter.MetaConverter;
import org.osiam.resources.scim.Group;
import org.osiam.resources.scim.MemberRef;
import org.osiam.storage.dao.ResourceDao;
import org.osiam.storage.entities.GroupEntity;
import org.osiam.storage.entities.ResourceEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GroupConverter
implements Converter<Group, GroupEntity> {
    private final ResourceDao resourceDao;
    private final MetaConverter metaConverter;

    @Autowired
    public GroupConverter(ResourceDao resourceDao, MetaConverter metaConverter) {
        this.resourceDao = resourceDao;
        this.metaConverter = metaConverter;
    }

    public GroupEntity fromScim(Group group) {
        if (group == null) {
            return null;
        }
        GroupEntity groupEntity = new GroupEntity();
        groupEntity.setDisplayName(group.getDisplayName());
        groupEntity.setExternalId(group.getExternalId());
        for (MemberRef member : group.getMembers()) {
            this.addMember(member, groupEntity);
        }
        return groupEntity;
    }

    private void addMember(MemberRef member, GroupEntity groupEntity) {
        String uuid = member.getValue();
        ResourceEntity resource = this.resourceDao.getById(uuid, ResourceEntity.class);
        groupEntity.addMember(resource);
    }

    public Group toScim(GroupEntity group) {
        if (group == null) {
            return null;
        }
        Group.Builder groupBuilder = new Group.Builder(group.getDisplayName()).setId(group.getId().toString()).setMeta(this.metaConverter.toScim(group.getMeta())).setExternalId(group.getExternalId());
        HashSet<MemberRef> members = new HashSet<MemberRef>();
        for (ResourceEntity member : group.getMembers()) {
            MemberRef memberRef = new MemberRef.Builder().setValue(member.getId().toString()).setReference(member.getMeta().getLocation()).setDisplay(member.getDisplayName() != null ? member.getDisplayName() : null).setType(member.getType()).build();
            members.add(memberRef);
        }
        groupBuilder.setMembers(members);
        return groupBuilder.build();
    }
}

