/*
 * Decompiled with CFR 0.152.
 */
package org.osiam.resources.provisioning;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.osiam.resources.exception.NoSuchElementException;
import org.osiam.resources.exception.OsiamBackendFailureException;
import org.osiam.resources.provisioning.model.ExtensionDefinition;
import org.osiam.resources.scim.Extension;
import org.osiam.resources.scim.ExtensionFieldType;
import org.osiam.storage.ExtensionRepository;
import org.osiam.storage.entities.ExtensionEntity;
import org.osiam.storage.entities.ExtensionFieldEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class SCIMExtensionProvisioning {
    private static final Logger logger = LoggerFactory.getLogger(SCIMExtensionProvisioning.class);
    private final ExtensionRepository repository;

    @Autowired
    public SCIMExtensionProvisioning(ExtensionRepository repository) {
        this.repository = repository;
    }

    public List<ExtensionDefinition> getAllExtensionDefinitions() {
        List extensions = this.fromEntity(this.repository.findAll());
        ArrayList<ExtensionDefinition> extensionDefinitions = new ArrayList<ExtensionDefinition>();
        for (Extension extension : extensions) {
            ExtensionDefinition extensionDefinition = new ExtensionDefinition(extension.getUrn());
            for (Map.Entry fieldEntry : extension.getFields().entrySet()) {
                String field = (String)fieldEntry.getKey();
                ExtensionFieldType type = ((Extension.Field)fieldEntry.getValue()).getType();
                extensionDefinition.addPair(field, type);
            }
            extensionDefinitions.add(extensionDefinition);
        }
        return extensionDefinitions;
    }

    private List<Extension> fromEntity(List<ExtensionEntity> entities) {
        ArrayList<Extension> result = new ArrayList<Extension>();
        for (ExtensionEntity entity : entities) {
            Extension.Builder builder = new Extension.Builder(entity.getUrn());
            this.setField(entity, builder);
            result.add(builder.build());
        }
        return result;
    }

    private void setField(ExtensionEntity entity, Extension.Builder builder) {
        for (ExtensionFieldEntity fieldEntity : entity.getFields()) {
            switch (fieldEntity.getType().getName()) {
                case "STRING": {
                    builder.setField(fieldEntity.getName(), "null");
                    break;
                }
                case "INTEGER": {
                    builder.setField(fieldEntity.getName(), BigInteger.ZERO);
                    break;
                }
                case "DECIMAL": {
                    builder.setField(fieldEntity.getName(), BigDecimal.ZERO);
                    break;
                }
                case "BOOLEAN": {
                    builder.setField(fieldEntity.getName(), Boolean.valueOf(false));
                    break;
                }
                case "DATE_TIME": {
                    builder.setField(fieldEntity.getName(), new Date(0L));
                    break;
                }
                case "BINARY": {
                    builder.setField(fieldEntity.getName(), ByteBuffer.wrap(new byte[0]));
                    break;
                }
                case "REFERENCE": {
                    try {
                        builder.setField(fieldEntity.getName(), new URI("http://www.osiam.org"));
                        break;
                    }
                    catch (URISyntaxException e) {
                        logger.warn("Unable to contruct URI for http://www.osiam.org This should never happen!", (Throwable)e);
                        throw new OsiamBackendFailureException();
                    }
                }
                default: {
                    throw new NoSuchElementException("Type '" + fieldEntity.getType().getName() + "' does not exist");
                }
            }
        }
    }
}

