/*
 * Decompiled with CFR 0.152.
 */
package org.osiam.resources.provisioning.update;

import com.google.common.base.Strings;
import java.util.List;
import java.util.Set;
import org.osiam.resources.converter.AddressConverter;
import org.osiam.resources.scim.Address;
import org.osiam.storage.entities.AddressEntity;
import org.osiam.storage.entities.UserEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
class AddressUpdater {
    private final AddressConverter addressConverter;

    @Autowired
    public AddressUpdater(AddressConverter addressConverter) {
        this.addressConverter = addressConverter;
    }

    void update(List<Address> address, UserEntity userEntity, Set<String> attributes) {
        if (attributes.contains("addresses")) {
            userEntity.removeAllAddresses();
        }
        if (address != null) {
            for (Address scimAddress : address) {
                AddressEntity addressEntity = this.addressConverter.fromScim(scimAddress);
                userEntity.removeAddress(addressEntity);
                if (!Strings.isNullOrEmpty((String)scimAddress.getOperation()) && scimAddress.getOperation().equalsIgnoreCase("delete")) continue;
                this.ensureOnlyOnePrimaryAddressExists(addressEntity, userEntity.getAddresses());
                userEntity.addAddress(addressEntity);
            }
        }
    }

    private void ensureOnlyOnePrimaryAddressExists(AddressEntity newAddress, Set<AddressEntity> addresss) {
        if (newAddress.isPrimary()) {
            for (AddressEntity exisitngAddressEntity : addresss) {
                if (!exisitngAddressEntity.isPrimary()) continue;
                exisitngAddressEntity.setPrimary(false);
            }
        }
    }
}

