/*
 * Decompiled with CFR 0.152.
 */
package org.osiam.resources.provisioning.update;

import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.osiam.resources.exception.NoSuchElementException;
import org.osiam.resources.scim.Extension;
import org.osiam.resources.scim.ExtensionFieldType;
import org.osiam.storage.ExtensionRepository;
import org.osiam.storage.entities.ExtensionEntity;
import org.osiam.storage.entities.ExtensionFieldEntity;
import org.osiam.storage.entities.ExtensionFieldValueEntity;
import org.osiam.storage.entities.UserEntity;
import org.osiam.storage.helper.NumberPadder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
class ExtensionUpdater {
    private static final Logger logger = LoggerFactory.getLogger(ExtensionUpdater.class);
    private final ExtensionRepository extensionRepository;
    private final NumberPadder numberPadder;

    @Autowired
    public ExtensionUpdater(ExtensionRepository extensionRepository) {
        this.extensionRepository = extensionRepository;
        this.numberPadder = new NumberPadder();
    }

    void update(Map<String, Extension> extensions, UserEntity userEntity, Set<String> attributes) {
        for (String string : attributes) {
            Optional urn = this.getUrn(string);
            if (!urn.isPresent()) continue;
            Optional fieldName = this.getFieldName(string);
            if (fieldName.isPresent()) {
                this.removeExtensionFieldValue(userEntity, (String)urn.get(), (String)fieldName.get());
                continue;
            }
            userEntity.removeAllExtensionFieldValues((String)urn.get());
        }
        if (extensions != null) {
            for (Map.Entry entry : extensions.entrySet()) {
                this.updateExtensionField(entry, userEntity);
            }
        }
    }

    private void removeExtensionFieldValue(UserEntity userEntity, String urn, String fieldName) {
        ImmutableSet extensionEntities = ImmutableSet.copyOf((Collection)userEntity.getExtensionFieldValues());
        for (ExtensionFieldValueEntity extensionFieldValue : extensionEntities) {
            ExtensionFieldEntity extensionField = extensionFieldValue.getExtensionField();
            if (!extensionField.getExtension().getUrn().equalsIgnoreCase(urn) || !extensionField.getName().equalsIgnoreCase(fieldName)) continue;
            userEntity.removeExtensionFieldValue(extensionFieldValue);
        }
    }

    private void updateExtensionField(Map.Entry<String, Extension> extensionEntry, UserEntity userEntity) {
        String urn = extensionEntry.getKey();
        Extension updatedScimExtension = extensionEntry.getValue();
        ExtensionEntity extensionEntity = this.extensionRepository.findByUrn(urn);
        for (String fieldName : updatedScimExtension.getFields().keySet()) {
            String newValue;
            ExtensionFieldEntity extensionEntitiyField;
            try {
                extensionEntitiyField = extensionEntity.getFieldForName(fieldName, true);
            }
            catch (NoSuchElementException e) {
                logger.warn("Update Extension failed: ", (Object)e.getMessage());
                throw e;
            }
            ExtensionFieldValueEntity extensionFieldValue = this.findExtensionFieldValue(extensionEntitiyField, userEntity);
            if (extensionFieldValue == null) {
                extensionFieldValue = new ExtensionFieldValueEntity();
            }
            if (Strings.isNullOrEmpty((String)(newValue = this.getNewExtensionValue(extensionEntitiyField, updatedScimExtension, fieldName)))) continue;
            extensionFieldValue.setValue(newValue);
            extensionFieldValue.setExtensionField(extensionEntitiyField);
            userEntity.addOrUpdateExtensionValue(extensionFieldValue);
        }
    }

    private String getNewExtensionValue(ExtensionFieldEntity extensionField, Extension updatedExtension, String fieldName) {
        String newValue = (String)updatedExtension.getField(fieldName, ExtensionFieldType.STRING);
        if (newValue != null && (extensionField.getType() == ExtensionFieldType.INTEGER || extensionField.getType() == ExtensionFieldType.DECIMAL)) {
            newValue = this.numberPadder.pad(newValue);
        }
        return newValue;
    }

    private ExtensionFieldValueEntity findExtensionFieldValue(ExtensionFieldEntity extensionField, UserEntity userEntity) {
        for (ExtensionFieldValueEntity extensionFieldValue : userEntity.getExtensionFieldValues()) {
            if (!extensionFieldValue.getExtensionField().equals((Object)extensionField)) continue;
            return extensionFieldValue;
        }
        return null;
    }

    private Optional<String> getUrn(String attribute) {
        int lastIndexOf = attribute.lastIndexOf(46);
        String urn = lastIndexOf != -1 ? attribute.substring(0, lastIndexOf) : attribute;
        if (!this.extensionRepository.existsByUrnIgnoreCase(urn)) {
            return Optional.absent();
        }
        return Optional.of((Object)urn);
    }

    private Optional<String> getFieldName(String attribute) {
        int lastIndexOf = attribute.lastIndexOf(46);
        if (lastIndexOf != -1) {
            return Optional.of((Object)attribute.substring(lastIndexOf + 1));
        }
        return Optional.absent();
    }
}

