/*
 * Decompiled with CFR 0.152.
 */
package org.osiam.resources.provisioning.update;

import com.google.common.base.Strings;
import java.util.HashSet;
import java.util.Set;
import org.osiam.resources.exception.ResourceExistsException;
import org.osiam.resources.provisioning.update.ResourceUpdater;
import org.osiam.resources.scim.Group;
import org.osiam.resources.scim.MemberRef;
import org.osiam.resources.scim.Resource;
import org.osiam.storage.dao.GroupDao;
import org.osiam.storage.dao.ResourceDao;
import org.osiam.storage.entities.GroupEntity;
import org.osiam.storage.entities.ResourceEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GroupUpdater {
    private final GroupDao groupDao;
    private final ResourceUpdater resourceUpdater;
    private final ResourceDao resourceDao;

    @Autowired
    public GroupUpdater(GroupDao groupDao, ResourceUpdater resourceUpdater, ResourceDao resourceDao) {
        this.groupDao = groupDao;
        this.resourceUpdater = resourceUpdater;
        this.resourceDao = resourceDao;
    }

    public void update(Group group, GroupEntity groupEntity) {
        String displayName;
        this.resourceUpdater.update((Resource)group, (ResourceEntity)groupEntity);
        Set attributes = new HashSet();
        if (group.getMeta() != null && group.getMeta().getAttributes() != null) {
            attributes = group.getMeta().getAttributes();
        }
        if (!Strings.isNullOrEmpty((String)(displayName = group.getDisplayName()))) {
            if (this.groupDao.isDisplayNameAlreadyTaken(displayName, groupEntity.getId().toString())) {
                throw new ResourceExistsException(String.format("Group with displayName '%s' already exists", displayName));
            }
            groupEntity.setDisplayName(displayName);
        }
        this.updateMembers(group, groupEntity, attributes);
    }

    private void updateMembers(Group group, GroupEntity groupEntity, Set<String> attributes) {
        String attributeName = "members";
        for (String attribute : attributes) {
            if (!attribute.equalsIgnoreCase(attributeName)) continue;
            groupEntity.removeAllMembers();
        }
        if (group.getMembers() != null) {
            for (MemberRef memberRef : group.getMembers()) {
                ResourceEntity member;
                String memberId = memberRef.getValue();
                if (memberRef.getOperation() != null && memberRef.getOperation().equalsIgnoreCase("delete")) {
                    member = this.getMember(memberId, groupEntity);
                    if (member == null) continue;
                    groupEntity.removeMember(member);
                    continue;
                }
                member = this.resourceDao.getById(memberId, ResourceEntity.class);
                groupEntity.addMember(member);
            }
        }
    }

    private ResourceEntity getMember(String memberId, GroupEntity groupEntity) {
        Set members = groupEntity.getMembers();
        for (ResourceEntity member : members) {
            if (!member.getId().toString().equals(memberId)) continue;
            return member;
        }
        return null;
    }
}

