/*
 * Decompiled with CFR 0.152.
 */
package org.osiam.resources.provisioning.update;

import com.google.common.base.Strings;
import java.util.List;
import java.util.Set;
import org.osiam.resources.converter.ImConverter;
import org.osiam.resources.scim.Im;
import org.osiam.storage.entities.ImEntity;
import org.osiam.storage.entities.UserEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
class ImUpdater {
    private final ImConverter imConverter;

    @Autowired
    public ImUpdater(ImConverter imConverter) {
        this.imConverter = imConverter;
    }

    void update(List<Im> ims, UserEntity userEntity, Set<String> attributes) {
        if (attributes.contains("ims")) {
            userEntity.removeAllIms();
        }
        if (ims != null) {
            for (Im scimIm : ims) {
                ImEntity imEntity = this.imConverter.fromScim(scimIm);
                userEntity.removeIm(imEntity);
                if (!Strings.isNullOrEmpty((String)scimIm.getOperation()) && scimIm.getOperation().equalsIgnoreCase("delete")) continue;
                this.ensureOnlyOnePrimaryImExists(imEntity, userEntity.getIms());
                userEntity.addIm(imEntity);
            }
        }
    }

    private void ensureOnlyOnePrimaryImExists(ImEntity newIm, Set<ImEntity> ims) {
        if (newIm.isPrimary()) {
            for (ImEntity existingImEntity : ims) {
                if (!existingImEntity.isPrimary()) continue;
                existingImEntity.setPrimary(false);
            }
        }
    }
}

