/*
 * Decompiled with CFR 0.152.
 */
package org.osiam.resources.provisioning.update;

import com.google.common.base.Strings;
import java.util.Set;
import org.osiam.resources.scim.Name;
import org.osiam.storage.entities.NameEntity;
import org.osiam.storage.entities.UserEntity;
import org.springframework.stereotype.Service;

@Service
class NameUpdater {
    NameUpdater() {
    }

    void update(Name name, UserEntity userEntity, Set<String> attributes) {
        if (attributes.contains("name")) {
            userEntity.setName(null);
        }
        this.ensureNameEntityIsNotNull(name, userEntity);
        this.updateFormatted(name, userEntity, attributes);
        this.updateFamilyName(name, userEntity, attributes);
        this.updateGivenName(name, userEntity, attributes);
        this.updateMiddleName(name, userEntity, attributes);
        this.updateHonorificPrefix(name, userEntity, attributes);
        this.updateHonorificSuffix(name, userEntity, attributes);
    }

    private void updateFormatted(Name name, UserEntity userEntity, Set<String> attributes) {
        String formatted;
        if (attributes.contains("name.formatted") && userEntity.getName() != null) {
            userEntity.getName().setFormatted(null);
        }
        if (name != null && !Strings.isNullOrEmpty((String)(formatted = name.getFormatted()))) {
            userEntity.getName().setFormatted(name.getFormatted());
        }
    }

    private void updateFamilyName(Name name, UserEntity userEntity, Set<String> attributes) {
        String familyName;
        if (attributes.contains("name.familyName") && userEntity.getName() != null) {
            userEntity.getName().setFamilyName(null);
        }
        if (name != null && !Strings.isNullOrEmpty((String)(familyName = name.getFamilyName()))) {
            userEntity.getName().setFamilyName(name.getFamilyName());
        }
    }

    private void updateGivenName(Name name, UserEntity userEntity, Set<String> attributes) {
        String givenName;
        if (attributes.contains("name.givenName") && userEntity.getName() != null) {
            userEntity.getName().setGivenName(null);
        }
        if (name != null && !Strings.isNullOrEmpty((String)(givenName = name.getGivenName()))) {
            userEntity.getName().setGivenName(name.getGivenName());
        }
    }

    private void updateMiddleName(Name name, UserEntity userEntity, Set<String> attributes) {
        String middleName;
        if (attributes.contains("name.middleName") && userEntity.getName() != null) {
            userEntity.getName().setMiddleName(null);
        }
        if (name != null && !Strings.isNullOrEmpty((String)(middleName = name.getMiddleName()))) {
            userEntity.getName().setMiddleName(name.getMiddleName());
        }
    }

    private void updateHonorificPrefix(Name name, UserEntity userEntity, Set<String> attributes) {
        String honorificPrefix;
        if (attributes.contains("name.honorificPrefix") && userEntity.getName() != null) {
            userEntity.getName().setHonorificPrefix(null);
        }
        if (name != null && !Strings.isNullOrEmpty((String)(honorificPrefix = name.getHonorificPrefix()))) {
            userEntity.getName().setHonorificPrefix(name.getHonorificPrefix());
        }
    }

    private void updateHonorificSuffix(Name name, UserEntity userEntity, Set<String> attributes) {
        String honorificSuffix;
        if (attributes.contains("name.honorificSuffix") && userEntity.getName() != null) {
            userEntity.getName().setHonorificSuffix(null);
        }
        if (name != null && !Strings.isNullOrEmpty((String)(honorificSuffix = name.getHonorificSuffix()))) {
            userEntity.getName().setHonorificSuffix(name.getHonorificSuffix());
        }
    }

    private void ensureNameEntityIsNotNull(Name name, UserEntity userEntity) {
        if (userEntity.getName() != null) {
            return;
        }
        if (name == null) {
            return;
        }
        if (name.isEmpty()) {
            return;
        }
        userEntity.setName(new NameEntity());
    }
}

