/*
 * Decompiled with CFR 0.152.
 */
package org.osiam.resources.scim;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.validation.Valid;
import org.hibernate.validator.constraints.NotBlank;
import org.osiam.resources.scim.Address;
import org.osiam.resources.scim.Email;
import org.osiam.resources.scim.Entitlement;
import org.osiam.resources.scim.Extension;
import org.osiam.resources.scim.GroupRef;
import org.osiam.resources.scim.Im;
import org.osiam.resources.scim.Meta;
import org.osiam.resources.scim.Name;
import org.osiam.resources.scim.PhoneNumber;
import org.osiam.resources.scim.Photo;
import org.osiam.resources.scim.Resource;
import org.osiam.resources.scim.Role;
import org.osiam.resources.scim.User;
import org.osiam.resources.scim.X509Certificate;
import org.osiam.resources.validation.ValidCoreSchema;

/*
 * Exception performing whole class analysis ignored.
 */
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonFilter(value="attributeFilter")
public final class User
extends Resource
implements Serializable {
    public static final String SCHEMA = "urn:ietf:params:scim:schemas:core:2.0:User";
    private static final long serialVersionUID = -4076516708797425414L;
    @NotBlank(message="The userName is mandatory!")
    private final String userName;
    private final Name name;
    private final String displayName;
    private final String nickName;
    private final String profileUrl;
    private final String title;
    private final String userType;
    private final String preferredLanguage;
    private final String locale;
    private final String timezone;
    private final Boolean active;
    private final String password;
    @Valid
    private final List<Email> emails;
    @Valid
    private final List<PhoneNumber> phoneNumbers;
    @Valid
    private final List<Im> ims;
    @Valid
    private final List<Photo> photos;
    private final List<Address> addresses;
    @Valid
    private final List<GroupRef> groups;
    @Valid
    private final List<Entitlement> entitlements;
    @Valid
    private final List<Role> roles;
    @Valid
    private final List<X509Certificate> x509Certificates;
    private final Map<String, Extension> extensions;

    @JsonCreator
    private User(@JsonProperty(value="id") String id, @JsonProperty(value="externalId") String externalId, @JsonProperty(value="meta") Meta meta, @JsonProperty(value="schemas", required=true) Set<String> schemas, @JsonProperty(value="userName") String userName, @JsonProperty(value="name") Name name, @JsonProperty(value="displayName") String displayName, @JsonProperty(value="nickName") String nickName, @JsonProperty(value="profileUrl") String profileUrl, @JsonProperty(value="title") String title, @JsonProperty(value="userType") String userType, @JsonProperty(value="preferredLanguage") String preferredLanguage, @JsonProperty(value="locale") String locale, @JsonProperty(value="timezone") String timezone, @JsonProperty(value="active") Boolean active, @JsonProperty(value="emails") List<Email> emails, @JsonProperty(value="phoneNumbers") List<PhoneNumber> phoneNumbers, @JsonProperty(value="ims") List<Im> ims, @JsonProperty(value="photos") List<Photo> photos, @JsonProperty(value="addresses") List<Address> addresses, @JsonProperty(value="groups") List<GroupRef> groups, @JsonProperty(value="entitlements") List<Entitlement> entitlements, @JsonProperty(value="roles") List<Role> roles, @JsonProperty(value="x509Certificates") List<X509Certificate> x509Certificates, @JsonProperty(value="extensions") Map<String, Extension> extensions) {
        super(id, externalId, meta, schemas);
        this.userName = userName != null ? userName : "";
        this.name = name;
        this.displayName = displayName;
        this.nickName = nickName;
        this.profileUrl = profileUrl;
        this.title = title;
        this.userType = userType;
        this.preferredLanguage = preferredLanguage;
        this.locale = locale;
        this.timezone = timezone;
        this.active = active;
        this.password = "";
        this.emails = emails != null ? emails : new ArrayList();
        this.phoneNumbers = phoneNumbers != null ? phoneNumbers : new ArrayList();
        this.ims = ims != null ? ims : new ArrayList();
        this.photos = photos != null ? photos : new ArrayList();
        this.addresses = addresses != null ? addresses : new ArrayList();
        this.groups = groups != null ? groups : new ArrayList();
        this.entitlements = entitlements != null ? entitlements : new ArrayList();
        this.roles = roles != null ? roles : new ArrayList();
        this.x509Certificates = x509Certificates != null ? x509Certificates : new ArrayList();
        this.extensions = extensions != null ? extensions : new HashMap();
    }

    private User(Builder builder) {
        super((Resource.Builder)builder);
        this.userName = Builder.access$5((Builder)builder);
        this.name = Builder.access$6((Builder)builder);
        this.displayName = Builder.access$7((Builder)builder);
        this.nickName = Builder.access$8((Builder)builder);
        this.profileUrl = Builder.access$9((Builder)builder);
        this.title = Builder.access$10((Builder)builder);
        this.userType = Builder.access$11((Builder)builder);
        this.preferredLanguage = Builder.access$12((Builder)builder);
        this.locale = Builder.access$13((Builder)builder);
        this.timezone = Builder.access$14((Builder)builder);
        this.active = Builder.access$15((Builder)builder);
        this.password = Builder.access$16((Builder)builder);
        this.emails = Builder.access$17((Builder)builder);
        this.phoneNumbers = Builder.access$18((Builder)builder);
        this.ims = Builder.access$19((Builder)builder);
        this.photos = Builder.access$20((Builder)builder);
        this.addresses = Builder.access$21((Builder)builder);
        this.groups = Builder.access$22((Builder)builder);
        this.entitlements = Builder.access$23((Builder)builder);
        this.roles = Builder.access$24((Builder)builder);
        this.x509Certificates = Builder.access$25((Builder)builder);
        this.extensions = Builder.access$26((Builder)builder);
    }

    public String getUserName() {
        return this.userName;
    }

    public Name getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getNickName() {
        return this.nickName;
    }

    public String getProfileUrl() {
        return this.profileUrl;
    }

    public String getTitle() {
        return this.title;
    }

    public String getUserType() {
        return this.userType;
    }

    public String getPreferredLanguage() {
        return this.preferredLanguage;
    }

    public String getLocale() {
        return this.locale;
    }

    public String getTimezone() {
        return this.timezone;
    }

    public Boolean isActive() {
        return this.active;
    }

    public String getPassword() {
        return this.password;
    }

    public List<Email> getEmails() {
        return ImmutableList.copyOf((Collection)this.emails);
    }

    @JsonIgnore
    public Optional<Email> getPrimaryOrFirstEmail() {
        for (Email email : this.emails) {
            if (!email.isPrimary()) continue;
            return Optional.of((Object)email);
        }
        if (this.emails.size() > 0) {
            return Optional.of((Object)((Email)this.getEmails().get(0)));
        }
        return Optional.absent();
    }

    public List<PhoneNumber> getPhoneNumbers() {
        return ImmutableList.copyOf((Collection)this.phoneNumbers);
    }

    public List<Im> getIms() {
        return ImmutableList.copyOf((Collection)this.ims);
    }

    public List<Photo> getPhotos() {
        return ImmutableList.copyOf((Collection)this.photos);
    }

    public List<Address> getAddresses() {
        return ImmutableList.copyOf((Collection)this.addresses);
    }

    public List<GroupRef> getGroups() {
        return ImmutableList.copyOf((Collection)this.groups);
    }

    public List<Entitlement> getEntitlements() {
        return ImmutableList.copyOf((Collection)this.entitlements);
    }

    public List<Role> getRoles() {
        return ImmutableList.copyOf((Collection)this.roles);
    }

    public List<X509Certificate> getX509Certificates() {
        return ImmutableList.copyOf((Collection)this.x509Certificates);
    }

    @JsonAnyGetter
    public Map<String, Extension> getExtensions() {
        return ImmutableMap.copyOf((Map)this.extensions);
    }

    public Extension getExtension(String urn) {
        if (urn == null || urn.isEmpty()) {
            throw new IllegalArgumentException("urn must be neither null nor empty");
        }
        if (!this.extensions.containsKey(urn)) {
            throw new NoSuchElementException("extension " + urn + " is not available");
        }
        return (Extension)this.extensions.get(urn);
    }

    public boolean isExtensionPresent(String urn) {
        return this.extensions.containsKey(urn);
    }

    public String toString() {
        return "User [userName=" + this.userName + ", name=" + this.name + ", displayName=" + this.displayName + ", nickName=" + this.nickName + ", profileUrl=" + this.profileUrl + ", title=" + this.title + ", userType=" + this.userType + ", preferredLanguage=" + this.preferredLanguage + ", locale=" + this.locale + ", timezone=" + this.timezone + ", active=" + this.active + ", password=" + this.password + ", emails=" + this.emails + ", phoneNumbers=" + this.phoneNumbers + ", ims=" + this.ims + ", photos=" + this.photos + ", addresses=" + this.addresses + ", groups=" + this.groups + ", entitlements=" + this.entitlements + ", roles=" + this.roles + ", x509Certificates=" + this.x509Certificates + ", extensions=" + this.extensions + ", getId()=" + this.getId() + ", getExternalId()=" + this.getExternalId() + ", getMeta()=" + this.getMeta() + ", getSchemas()=" + this.getSchemas() + "]";
    }

    @ValidCoreSchema(value="urn:ietf:params:scim:schemas:core:2.0:User")
    public Set<String> getSchemas() {
        return super.getSchemas();
    }

    static /* synthetic */ String access$0(User user) {
        return user.userName;
    }

    static /* synthetic */ Name access$1(User user) {
        return user.name;
    }

    static /* synthetic */ String access$2(User user) {
        return user.displayName;
    }

    static /* synthetic */ String access$3(User user) {
        return user.nickName;
    }

    static /* synthetic */ String access$4(User user) {
        return user.profileUrl;
    }

    static /* synthetic */ String access$5(User user) {
        return user.title;
    }

    static /* synthetic */ String access$6(User user) {
        return user.userType;
    }

    static /* synthetic */ String access$7(User user) {
        return user.preferredLanguage;
    }

    static /* synthetic */ String access$8(User user) {
        return user.locale;
    }

    static /* synthetic */ String access$9(User user) {
        return user.timezone;
    }

    static /* synthetic */ Boolean access$10(User user) {
        return user.active;
    }

    static /* synthetic */ String access$11(User user) {
        return user.password;
    }

    static /* synthetic */ List access$12(User user) {
        return user.emails;
    }

    static /* synthetic */ List access$13(User user) {
        return user.phoneNumbers;
    }

    static /* synthetic */ List access$14(User user) {
        return user.ims;
    }

    static /* synthetic */ List access$15(User user) {
        return user.photos;
    }

    static /* synthetic */ List access$16(User user) {
        return user.addresses;
    }

    static /* synthetic */ List access$17(User user) {
        return user.groups;
    }

    static /* synthetic */ List access$18(User user) {
        return user.entitlements;
    }

    static /* synthetic */ List access$19(User user) {
        return user.roles;
    }

    static /* synthetic */ List access$20(User user) {
        return user.x509Certificates;
    }

    static /* synthetic */ Map access$21(User user) {
        return user.extensions;
    }

    /* synthetic */ User(Builder builder, User user) {
        this(builder);
    }
}

