/*
 * Decompiled with CFR 0.152.
 */
package org.osiam.storage.entities;

import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Lob;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.hibernate.annotations.Type;
import org.osiam.resources.exception.InvalidConstraintException;
import org.osiam.storage.entities.ExtensionFieldEntity;

@Entity
@Table(name="scim_extension", indexes={@Index(unique=true, columnList="urn")})
public class ExtensionEntity {
    @Id
    @SequenceGenerator(name="sequence_scim_extension", sequenceName="resource_server_sequence_scim_extension", allocationSize=1, initialValue=100)
    @GeneratedValue(generator="sequence_scim_extension")
    private long internalId;
    @Lob
    @Type(type="org.hibernate.type.StringClobType")
    @Column(nullable=false)
    private String urn;
    @OneToMany(mappedBy="extension", cascade={CascadeType.PERSIST})
    private Set<ExtensionFieldEntity> fields = new HashSet();

    public long getInternalId() {
        return this.internalId;
    }

    public void setInternalId(long internalId) {
        this.internalId = internalId;
    }

    public String getUrn() {
        return this.urn;
    }

    public void setUrn(String extensionUrn) {
        this.urn = extensionUrn;
    }

    public Set<ExtensionFieldEntity> getFields() {
        if (this.fields == null) {
            this.fields = new HashSet();
        }
        return this.fields;
    }

    public void setFields(Set<ExtensionFieldEntity> extensionFields) {
        if (extensionFields != null) {
            for (ExtensionFieldEntity extensionFieldEntity : extensionFields) {
                extensionFieldEntity.setExtension(this);
            }
        }
        this.fields = extensionFields;
    }

    public ExtensionFieldEntity getFieldForName(String fieldName, boolean caseInsensitive) {
        for (ExtensionFieldEntity field : this.fields) {
            if (!(!caseInsensitive ? field.getName().equals(fieldName) : field.getName().equalsIgnoreCase(fieldName))) continue;
            return field;
        }
        throw new InvalidConstraintException(String.format("Field '%s' not available in extension with urn '%s'", fieldName, this.urn));
    }

    public ExtensionFieldEntity getFieldForName(String fieldName) {
        return this.getFieldForName(fieldName, false);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.urn == null ? 0 : this.urn.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExtensionEntity other = (ExtensionEntity)obj;
        return !(this.urn == null ? other.urn != null : !this.urn.equals(other.urn));
    }

    public String toString() {
        return "ExtensionEntity [urn=" + this.urn + "]";
    }
}

