/*
 * Decompiled with CFR 0.152.
 */
package ru.r2cloud.bme;

import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Base64;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.r2cloud.bme.AuthenticationException;
import ru.r2cloud.bme.Satellite;

public class BmeClient {
    private static final int HEX_0X0F = 15;
    private static final String USER_AGENT = "bmeClient/1.1 (dernasherbrezon)";
    private static final Logger LOG = LoggerFactory.getLogger(BmeClient.class);
    private static final long TOKEN_EXPIRATION_MILLIS = Duration.ofHours(1L).toMillis();
    private static final int RETRIES = 3;
    private final String host;
    private final int port;
    private final String username;
    private final String password;
    private final long retryTimeoutMillis;
    private final int timeout;
    private String authToken;
    private HttpClient httpclient;
    private long validUntil;

    public BmeClient(String host, int port, int timeout, long retryTimeoutMillis, String username, String password) {
        this.host = host;
        this.port = port;
        this.username = username;
        this.password = password;
        this.timeout = timeout;
        this.retryTimeoutMillis = retryTimeoutMillis;
        this.httpclient = HttpClient.newBuilder().version(HttpClient.Version.HTTP_2).followRedirects(HttpClient.Redirect.NORMAL).connectTimeout(Duration.ofMillis(timeout)).build();
    }

    public void uploadBatch(Satellite satellite, List<byte[]> packets) throws IOException, AuthenticationException {
        if (satellite == null || packets == null) {
            throw new IllegalArgumentException();
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("uploading: {} number of packets: {}", (Object)satellite, (Object)packets.size());
        }
        if (packets.isEmpty()) {
            return;
        }
        int currentRetry = 0;
        while (!Thread.currentThread().isInterrupted()) {
            try {
                this.refreshToken();
                if (this.uploadBatchWithoutRetry(satellite, packets)) break;
            }
            catch (IOException e) {
                if (currentRetry < 3) {
                    LOG.info("unable to upload: {} retry...{} exception {}", new Object[]{satellite, ++currentRetry, e.getMessage()});
                    try {
                        Thread.sleep(this.retryTimeoutMillis);
                        continue;
                    }
                    catch (InterruptedException e1) {
                        LOG.info("sleep interrupted. exit");
                        Thread.currentThread().interrupt();
                        break;
                    }
                }
                throw e;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                break;
            }
        }
    }

    private boolean uploadBatchWithoutRetry(Satellite satellite, List<byte[]> packets) throws IOException, InterruptedException {
        String requestBody = BmeClient.convert(satellite, packets);
        if (LOG.isDebugEnabled()) {
            LOG.debug("request: {}", (Object)requestBody);
        }
        HttpRequest.Builder result = HttpRequest.newBuilder().uri(URI.create(this.host + ":" + this.port + "/api/packets/bulk"));
        result.timeout(Duration.ofMillis(this.timeout));
        result.header("User-Agent", USER_AGENT);
        result.header("Content-Type", "application/json");
        result.header("Authorization", "Bearer " + this.authToken);
        result.POST(HttpRequest.BodyPublishers.ofString(requestBody, StandardCharsets.UTF_8));
        HttpRequest request = result.build();
        HttpResponse<String> response = this.httpclient.send(request, HttpResponse.BodyHandlers.ofString());
        if (LOG.isDebugEnabled()) {
            LOG.debug("response: {}", (Object)response.body());
        }
        if (response.statusCode() == 401) {
            this.authToken = null;
            LOG.info("token expired. retry");
            return false;
        }
        if (response.statusCode() == 400) {
            LOG.error("invalid request. response: {}", (Object)response.body());
            return true;
        }
        if (response.statusCode() != 200) {
            throw new IOException("invalid response code: " + response.statusCode());
        }
        return true;
    }

    private static String convert(Satellite satellite, List<byte[]> packets) {
        JsonArray array = new JsonArray();
        for (byte[] cur : packets) {
            JsonObject curObject = new JsonObject();
            curObject.add("satellite", satellite.name().toLowerCase(Locale.UK));
            curObject.add("packet", BmeClient.convertToHex(cur));
            array.add((JsonValue)curObject);
        }
        JsonObject result = new JsonObject();
        result.add("packets", (JsonValue)array);
        return result.toString();
    }

    private void refreshToken() throws InterruptedException, IOException, AuthenticationException {
        if (this.authToken != null && System.currentTimeMillis() < this.validUntil) {
            return;
        }
        if (this.authToken != null) {
            LOG.info("re-newing auth token");
        }
        long start = System.currentTimeMillis();
        HttpRequest.Builder result = HttpRequest.newBuilder().uri(URI.create(this.host + ":" + this.port + "/api/tokens"));
        result.timeout(Duration.ofMillis(this.timeout));
        result.header("User-Agent", USER_AGENT);
        result.header("Authorization", "Basic " + Base64.getEncoder().encodeToString((this.username + ":" + this.password).getBytes()));
        result.POST(HttpRequest.BodyPublishers.noBody());
        HttpResponse<String> response = this.httpclient.send(result.build(), HttpResponse.BodyHandlers.ofString());
        if (response.statusCode() != 200) {
            if (response.statusCode() >= 500) {
                throw new IOException("unable to authenticate: " + response.statusCode());
            }
            throw new AuthenticationException("unable to authenticate");
        }
        this.authToken = BmeClient.parseToken(response.body());
        this.validUntil = start + TOKEN_EXPIRATION_MILLIS - (long)this.timeout;
        LOG.info("the token will expire at: {}", (Object)new Date(this.validUntil));
    }

    private static String parseToken(String body) throws IOException {
        JsonValue value = Json.parse((String)body);
        if (!value.isObject()) {
            LOG.error("invalid body: {}", (Object)body);
            throw new IOException("invalid response");
        }
        JsonObject object = value.asObject();
        String result = object.getString("token", null);
        if (result == null) {
            LOG.error("invalid body: {}", (Object)body);
            throw new IOException("invalid response");
        }
        return result;
    }

    private static String convertToHex(byte[] data) {
        StringBuilder buf = new StringBuilder();
        for (byte element : data) {
            int halfbyte = element >>> 4 & 0xF;
            int twoHalfs = 0;
            do {
                if (0 <= halfbyte && halfbyte <= 9) {
                    buf.append((char)(48 + halfbyte));
                } else {
                    buf.append((char)(97 + (halfbyte - 10)));
                }
                halfbyte = element & 0xF;
            } while (twoHalfs++ < 1);
        }
        return buf.toString();
    }
}

