/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.java.framework.model;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import software.amazon.smithy.java.core.schema.Schema;
import software.amazon.smithy.java.core.schema.SerializableStruct;
import software.amazon.smithy.java.core.serde.ShapeDeserializer;
import software.amazon.smithy.java.core.serde.ShapeSerializer;
import software.amazon.smithy.java.framework.model.SharedSchemas;
import software.amazon.smithy.java.framework.model.SharedSerde;
import software.amazon.smithy.java.framework.model.ValidationExceptionField;

final class SharedSerde {
    static List<ValidationExceptionField> deserializeValidationExceptionFieldList(Schema schema, ShapeDeserializer deserializer) {
        int size = deserializer.containerSize();
        ArrayList<ValidationExceptionField> result = size == -1 ? new ArrayList<ValidationExceptionField>() : new ArrayList(size);
        deserializer.readList(schema, result, (ShapeDeserializer.ListMemberConsumer)ValidationExceptionFieldList.MemberDeserializer.INSTANCE);
        return result;
    }

    private SharedSerde() {
    }

    static final class ValidationExceptionFieldListSerializer
    implements BiConsumer<List<ValidationExceptionField>, ShapeSerializer> {
        static final ValidationExceptionFieldListSerializer INSTANCE = new ValidationExceptionFieldListSerializer();

        ValidationExceptionFieldListSerializer() {
        }

        @Override
        public void accept(List<ValidationExceptionField> values, ShapeSerializer serializer) {
            for (ValidationExceptionField value : values) {
                serializer.writeStruct(SharedSchemas.VALIDATION_EXCEPTION_FIELD_LIST.listMember(), (SerializableStruct)value);
            }
        }
    }
}

